/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.pepsoft.util.MathUtils;

public final class GeometryUtil {
    private GeometryUtil() {
    }

    public static boolean visitCircle(int radius, PlaneVisitor visitor) {
        int dx = radius;
        int radiusError = 1 - dx;
        for (int dy = 0; dx >= dy; ++dy) {
            if (!visitor.visit(dx, dy, radius)) {
                return false;
            }
            if (!visitor.visit(-dx, dy, radius)) {
                return false;
            }
            if (!visitor.visit(-dx, -dy, radius)) {
                return false;
            }
            if (!visitor.visit(dx, -dy, radius)) {
                return false;
            }
            if (dx != dy) {
                if (!visitor.visit(dy, dx, radius)) {
                    return false;
                }
                if (!visitor.visit(-dy, dx, radius)) {
                    return false;
                }
                if (!visitor.visit(-dy, -dx, radius)) {
                    return false;
                }
                if (!visitor.visit(dy, -dx, radius)) {
                    return false;
                }
            }
            if (radiusError < 0) {
                radiusError += 2 * dy + 1;
                continue;
            }
            radiusError += 2 * (dy - --dx + 1);
        }
        return true;
    }

    public static boolean visitFilledCircle(int radius, PlaneVisitor visitor) {
        int dx = radius;
        int radiusError = 1 - dx;
        for (int dy = 0; dx >= dy; ++dy) {
            float d;
            int i;
            if (!visitor.visit(0, -dy, dy)) {
                return false;
            }
            if (dy > 0 && !visitor.visit(0, dy, dy)) {
                return false;
            }
            for (i = 1; i <= dx; ++i) {
                d = MathUtils.getDistance((int)i, (int)dy);
                if (!visitor.visit(-i, -dy, d)) {
                    return false;
                }
                if (!visitor.visit(-i, dy, d)) {
                    return false;
                }
                if (!visitor.visit(i, -dy, d)) {
                    return false;
                }
                if (visitor.visit(i, dy, d)) continue;
                return false;
            }
            if (dx > 0) {
                if (!visitor.visit(0, -dx, dx)) {
                    return false;
                }
                if (!visitor.visit(0, dx, dx)) {
                    return false;
                }
            }
            for (i = 1; i <= dy; ++i) {
                d = MathUtils.getDistance((int)i, (int)dx);
                if (!visitor.visit(-i, -dx, d)) {
                    return false;
                }
                if (!visitor.visit(-i, dx, d)) {
                    return false;
                }
                if (!visitor.visit(i, -dx, d)) {
                    return false;
                }
                if (visitor.visit(i, dx, d)) continue;
                return false;
            }
            if (radiusError < 0) {
                radiusError += 2 * dy + 1;
                continue;
            }
            radiusError += 2 * (dy - --dx + 1);
        }
        return true;
    }

    public static void visitAllOfFilledCircle(float radius, AllPlaneVisitor visitor) {
        int dx = (int)Math.ceil(radius);
        int radiusError = 1 - dx;
        for (int dy = 0; dx >= dy; ++dy) {
            float d;
            int i;
            if ((float)dy <= radius) {
                visitor.visit(0, -dy, dy);
                if (dy > 0) {
                    visitor.visit(0, dy, dy);
                }
            }
            for (i = 1; i <= dx; ++i) {
                d = MathUtils.getDistance((int)i, (int)dy);
                if (!(d <= radius)) continue;
                visitor.visit(-i, -dy, d);
                visitor.visit(-i, dy, d);
                visitor.visit(i, -dy, d);
                visitor.visit(i, dy, d);
            }
            if (dx > 0 && (float)dx <= radius) {
                visitor.visit(0, -dx, dx);
                visitor.visit(0, dx, dx);
            }
            for (i = 1; i <= dy; ++i) {
                d = MathUtils.getDistance((int)i, (int)dx);
                if (!(d <= radius)) continue;
                visitor.visit(-i, -dx, d);
                visitor.visit(-i, dx, d);
                visitor.visit(i, -dx, d);
                visitor.visit(i, dx, d);
            }
            if (radiusError < 0) {
                radiusError += 2 * dy + 1;
                continue;
            }
            radiusError += 2 * (dy - --dx + 1);
        }
    }

    public static List<Point> getFilledCircleCoordinates(float radius) {
        int dx = (int)Math.ceil(radius);
        ArrayList<Point> points = new ArrayList<Point>((dx * 2 + 1) * (dx * 2 + 1));
        int radiusError = 1 - dx;
        for (int dy = 0; dx >= dy; ++dy) {
            float d;
            int i;
            if ((float)dy <= radius) {
                points.add(new Point(0, -dy));
                if (dy > 0) {
                    points.add(new Point(0, dy));
                }
            }
            for (i = 1; i <= dx; ++i) {
                d = MathUtils.getDistance((int)i, (int)dy);
                if (!(d <= radius)) continue;
                points.add(new Point(-i, -dy));
                points.add(new Point(-i, dy));
                points.add(new Point(i, -dy));
                points.add(new Point(i, dy));
            }
            if (dx > 0 && (float)dx <= radius) {
                points.add(new Point(0, -dx));
                points.add(new Point(0, dx));
            }
            for (i = 1; i <= dy; ++i) {
                d = MathUtils.getDistance((int)i, (int)dx);
                if (!(d <= radius)) continue;
                points.add(new Point(-i, -dx));
                points.add(new Point(-i, dx));
                points.add(new Point(i, -dx));
                points.add(new Point(i, dx));
            }
            if (radiusError < 0) {
                radiusError += 2 * dy + 1;
                continue;
            }
            radiusError += 2 * (dy - --dx + 1);
        }
        return points;
    }

    public static float[][] getDistancesToCentre(float radius) {
        int r = (int)Math.ceil(radius);
        float[][] distances = new float[r * 2 + 1][r * 2 + 1];
        for (int dx = 0; dx <= r; ++dx) {
            for (int dy = 0; dy <= r; ++dy) {
                float d;
                distances[r + dx][r + dy] = d = MathUtils.getDistance((int)dx, (int)dy);
                distances[r + dx][r - dy] = d;
                distances[r - dx][r + dy] = d;
                distances[r - dx][r - dy] = d;
            }
        }
        return distances;
    }

    public static boolean visitFilledSphere(int radius, VolumeVisitor visitor) {
        for (int dz = 0; dz <= radius; ++dz) {
            int finalDz;
            int r = (int)Math.round(Math.sqrt(radius * radius - dz * dz));
            if (!GeometryUtil.visitFilledCircle(r, (arg_0, arg_1, arg_2) -> GeometryUtil.lambda$visitFilledSphere$0(visitor, finalDz = dz, arg_0, arg_1, arg_2))) {
                return false;
            }
            if (dz <= 0 || GeometryUtil.visitFilledCircle(r, (dx, dy, d) -> visitor.visit(dx, dy, -finalDz, MathUtils.getDistance((int)dx, (int)dy, (int)(-finalDz))))) continue;
            return false;
        }
        return true;
    }

    public static boolean visitFilledAbsoluteSphere(double x, double y, double z, float radius, AbsoluteVolumeVisitor visitor) {
        int centerX = (int)Math.round(x);
        int centerY = (int)Math.round(y);
        int centerZ = (int)Math.round(z);
        return GeometryUtil.visitFilledSphere((int)(Math.ceil(radius) + 1.0), (dx, dy, dz, d) -> {
            int actualX = centerX + dx;
            int actualY = centerY + dy;
            int actualZ = centerZ + dz;
            float actualDistance = (float)MathUtils.getDistance((double)(x - (double)actualX), (double)(y - (double)actualY), (double)(z - (double)actualZ));
            if (actualDistance <= radius) {
                return visitor.visit(actualX, actualY, actualZ, actualDistance);
            }
            return true;
        });
    }

    public static boolean visitLine(int x1, int y1, int x2, int y2, LineVisitor visitor) {
        if (x1 == x2 && y1 == y2) {
            return visitor.visit(x1, y1, 0.0f);
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (Math.abs(dx) > Math.abs(dy)) {
            float y = y1;
            float offset = (float)dy / (float)Math.abs(dx);
            float distance = 0.0f;
            float stepLength = (float)Math.sqrt(1.0f + (1.0f + offset) * (1.0f + offset));
            dx = dx < 0 ? -1 : 1;
            for (int x = x1; x != x2; x += dx) {
                if (!visitor.visit(x, (int)y, distance)) {
                    return false;
                }
                y += offset;
                distance += stepLength;
            }
        } else {
            float x = x1;
            float offset = (float)dx / (float)Math.abs(dy);
            float distance = 0.0f;
            float stepLength = (float)Math.sqrt(1.0f + (1.0f + offset) * (1.0f + offset));
            dy = dy < 0 ? -1 : 1;
            for (int y = y1; y != y2; y += dy) {
                if (!visitor.visit((int)x, y, distance)) {
                    return false;
                }
                x += offset;
                distance += stepLength;
            }
        }
        return true;
    }

    public static boolean visitLine(int x1, int y1, int x2, int y2, int every, LineVisitor visitor) {
        if (x1 == x2 && y1 == y2) {
            return visitor.visit(x1, y1, 0.0f);
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        int count = every / 2;
        if (Math.abs(dx) > Math.abs(dy)) {
            float y = y1;
            float offset = (float)dy / (float)Math.abs(dx);
            float distance = 0.0f;
            float stepLength = (float)Math.sqrt(1.0f + (1.0f + offset) * (1.0f + offset));
            dx = dx < 0 ? -1 : 1;
            for (int x = x1; x != x2; x += dx) {
                if (count % every == 0 && !visitor.visit(x, (int)y, distance)) {
                    return false;
                }
                y += offset;
                distance += stepLength;
                ++count;
            }
        } else {
            float x = x1;
            float offset = (float)dx / (float)Math.abs(dy);
            float distance = 0.0f;
            float stepLength = (float)Math.sqrt(1.0f + (1.0f + offset) * (1.0f + offset));
            dy = dy < 0 ? -1 : 1;
            for (int y = y1; y != y2; y += dy) {
                if (count % every == 0 && !visitor.visit((int)x, y, distance)) {
                    return false;
                }
                x += offset;
                distance += stepLength;
                ++count;
            }
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$visitFilledSphere$0(VolumeVisitor visitor, int finalDz, int dx, int dy, float d) {
        return visitor.visit(dx, dy, finalDz, MathUtils.getDistance((int)dx, (int)dy, (int)finalDz));
    }

    @FunctionalInterface
    public static interface AbsoluteVolumeVisitor {
        public boolean visit(int var1, int var2, int var3, float var4);
    }

    @FunctionalInterface
    public static interface VolumeVisitor {
        public boolean visit(int var1, int var2, int var3, float var4);
    }

    @FunctionalInterface
    public static interface AllPlaneVisitor {
        public void visit(int var1, int var2, float var3);
    }

    @FunctionalInterface
    public static interface PlaneVisitor {
        public boolean visit(int var1, int var2, float var3);
    }

    @FunctionalInterface
    public static interface LineVisitor {
        public boolean visit(int var1, int var2, float var3);
    }
}

