/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.util.Version;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_12BiomeInfo;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_17BiomeInfo;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_19Biomes;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_1BiomeInfo;
import org.pepsoft.worldpainter.biomeschemes.StaticBiomeInfo;

public final class BiomeUtils {
    private final String[] customBiomeNames;

    public BiomeUtils() {
        this.customBiomeNames = null;
    }

    public BiomeUtils(Dimension dimension) {
        this.customBiomeNames = new String[256];
        if (dimension.getCustomBiomes() != null) {
            dimension.getCustomBiomes().forEach(customBiome -> {
                this.customBiomeNames[customBiome.getId()] = customBiome.getName();
            });
        }
    }

    public void set2DBiome(Chunk chunk, int x, int z, int biome) {
        if (chunk.isBiomesSupported()) {
            chunk.setBiome(x, z, biome);
        } else if (chunk.is3DBiomesSupported()) {
            int blockX = x >> 2;
            int blockZ = z >> 2;
            int maxBlockY = chunk.getMaxHeight() >> 2;
            for (int blockY = chunk.getMinHeight() >> 2; blockY < maxBlockY; ++blockY) {
                chunk.set3DBiome(blockX, blockY, blockZ, biome);
            }
        } else if (chunk.isNamedBiomesSupported()) {
            String biomeName = this.findBiomeName(biome);
            int blockX = x >> 2;
            int blockZ = z >> 2;
            int maxBlockY = chunk.getMaxHeight() >> 2;
            for (int blockY = chunk.getMinHeight() >> 2; blockY < maxBlockY; ++blockY) {
                chunk.setNamedBiome(blockX, blockY, blockZ, biomeName);
            }
        } else {
            throw new IllegalArgumentException("Chunk of type " + chunk.getClass().getSimpleName() + " does not support any type of biomes");
        }
    }

    public void set3DBiome(Chunk chunk, int x, int y, int z, int biome) {
        if (chunk.is3DBiomesSupported()) {
            chunk.set3DBiome(x, y, z, biome);
        } else if (chunk.isNamedBiomesSupported()) {
            String biomeName = this.findBiomeName(biome);
            chunk.setNamedBiome(x, y, z, biomeName);
        } else {
            throw new IllegalArgumentException("Chunk of type " + chunk.getClass().getSimpleName() + " does not support any type of 3D biomes");
        }
    }

    public static List<Integer> getAllBiomes(Platform platform, CustomBiomeManager customBiomeManager) {
        ArrayList<Integer> allBiomes = new ArrayList<Integer>();
        BiomeScheme biomeScheme = BiomeUtils.getBiomeScheme(platform);
        for (int i = 0; i < biomeScheme.getBiomeCount(); ++i) {
            if (!biomeScheme.isBiomePresent(i)) continue;
            allBiomes.add(i);
        }
        if (platform.capabilities.contains((Object)Platform.Capability.NAMED_BIOMES)) {
            allBiomes.sort(Comparator.comparing(biomeScheme::getBiomeName));
        }
        if (customBiomeManager != null) {
            allBiomes.addAll(customBiomeManager.getCustomBiomes().stream().map(CustomBiome::getId).collect(Collectors.toList()));
        }
        return allBiomes;
    }

    public static BiomeScheme getBiomeScheme(Platform platform) {
        Version mcVersion = platform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION);
        if (mcVersion.isAtLeast(Constants.V_1_18)) {
            return StaticBiomeInfo.INSTANCE;
        }
        if (mcVersion.isAtLeast(Constants.V_1_15)) {
            return Minecraft1_17BiomeInfo.INSTANCE;
        }
        if (mcVersion.equals((Object)Constants.V_1_1)) {
            return Minecraft1_1BiomeInfo.INSTANCE;
        }
        return Minecraft1_12BiomeInfo.INSTANCE;
    }

    private String findBiomeName(int biome) {
        String biomeName = Minecraft1_19Biomes.MODERN_IDS[biome];
        if (biomeName == null && (biomeName = this.customBiomeNames[biome]) == null) {
            throw new IllegalArgumentException("Biome " + biome + " is not a valid default or custom biome");
        }
        return biomeName;
    }
}

