/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.util.Random;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;
import org.pepsoft.worldpainter.heightMaps.BicubicHeightMap;
import org.pepsoft.worldpainter.heightMaps.BitmapHeightMap;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;
import org.pepsoft.worldpainter.importing.HeightMapImporter;
import org.pepsoft.worldpainter.themes.Theme;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class ImportHeightMapOp
extends AbstractOperation<World2> {
    private final HeightMapImporter importer = new HeightMapImporter();
    private BitmapHeightMap heightMap;
    private boolean fromLevelsSpecified;
    private boolean toLevelsSpecified;
    private int scale = 100;
    private int waterLevel = 62;
    private int offsetX;
    private int offsetY;
    private int lowerBuildLimit = Integer.MIN_VALUE;
    private int upperBuildLimit = Integer.MAX_VALUE;
    private Platform platform = Configuration.getInstance().getDefaultPlatform();

    protected ImportHeightMapOp(ScriptingContext context) {
        super(context);
    }

    public ImportHeightMapOp fromHeightMap(HeightMap heightMap) {
        this.heightMap = (BitmapHeightMap)heightMap;
        return this;
    }

    public ImportHeightMapOp scale(int scale) {
        this.scale = scale;
        return this;
    }

    public ImportHeightMapOp shift(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public ImportHeightMapOp fromLevels(int imageLow, int imageHigh) throws ScriptException {
        if (this.fromLevelsSpecified) {
            throw new ScriptException("Only one mapped range supported, for now");
        }
        this.importer.setImageLowLevel(imageLow);
        this.importer.setImageHighLevel(imageHigh);
        this.fromLevelsSpecified = true;
        return this;
    }

    public ImportHeightMapOp toLevels(int worldLow, int worldHigh) throws ScriptException {
        if (this.toLevelsSpecified) {
            throw new ScriptException("Only one mapped range supported, for now");
        }
        this.importer.setWorldLowLevel(worldLow);
        this.importer.setWorldHighLevel(worldHigh);
        this.toLevelsSpecified = true;
        return this;
    }

    public ImportHeightMapOp withWaterLevel(int level) {
        this.waterLevel = level;
        this.importer.setWorldWaterLevel(level);
        return this;
    }

    public ImportHeightMapOp withMapFormat(Platform platform) {
        this.platform = platform;
        return this;
    }

    public ImportHeightMapOp withLowerBuildLimit(int lowerBuildLimit) {
        this.lowerBuildLimit = lowerBuildLimit;
        return this;
    }

    public ImportHeightMapOp withUpperBuildLimit(int upperBuildLimit) {
        this.upperBuildLimit = upperBuildLimit;
        return this;
    }

    @Override
    public World2 go() throws ScriptException {
        this.goCalled();
        if (this.heightMap == null) {
            throw new ScriptException("heightMap not set");
        }
        AbstractHeightMap adjustedHeightMap = this.heightMap;
        if (this.scale != 100 || this.offsetX != 0 || this.offsetY != 0) {
            if (this.scale != 100) {
                adjustedHeightMap = new BicubicHeightMap(adjustedHeightMap);
            }
            adjustedHeightMap = new TransformingHeightMap(this.heightMap.getName() + " transformed", adjustedHeightMap, (float)this.scale / 100.0f, (float)this.scale / 100.0f, this.offsetX, this.offsetY, 0.0f);
        }
        this.importer.setHeightMap(adjustedHeightMap);
        this.importer.setImageFile(this.heightMap.getImageFile());
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        if (this.lowerBuildLimit != Integer.MIN_VALUE) {
            minHeight = this.lowerBuildLimit;
            if (minHeight < this.platform.minMinHeight) {
                throw new ScriptException("Lower build limit " + this.lowerBuildLimit + " lower than map format minimum lower build limit of " + this.platform.minMinHeight);
            }
            if (minHeight > this.platform.maxMinHeight) {
                throw new ScriptException("Lower build limit " + this.lowerBuildLimit + " higher than map format maximum lower build limit of " + this.platform.maxMinHeight);
            }
        } else {
            for (int platformMinHeight : this.platform.minHeights) {
                if (platformMinHeight > this.platform.minZ || platformMinHeight > Math.min(this.importer.getWorldLowLevel(), this.importer.getWorldWaterLevel())) continue;
                minHeight = platformMinHeight;
                break;
            }
            if (minHeight == Integer.MAX_VALUE) {
                throw new ScriptException("Map format " + this.platform + " not deep enough to accommodate minimum terrain height of " + this.importer.getWorldLowLevel() + " or water level of " + this.importer.getWorldWaterLevel());
            }
        }
        if (this.upperBuildLimit != Integer.MAX_VALUE) {
            maxHeight = this.upperBuildLimit;
            if (maxHeight < this.platform.minMaxHeight) {
                throw new ScriptException("Upper build limit " + this.upperBuildLimit + " lower than map format minimum upper build limit of " + this.platform.minMaxHeight);
            }
            if (maxHeight > this.platform.maxMaxHeight) {
                throw new ScriptException("Upper build limit " + this.upperBuildLimit + " higher than map format maximum upper build limit of " + this.platform.maxMaxHeight);
            }
        } else {
            for (int platformMaxHeight : this.platform.maxHeights) {
                if (platformMaxHeight < this.platform.standardMaxHeight || platformMaxHeight <= Math.max(this.importer.getWorldHighLevel(), this.importer.getWorldWaterLevel())) continue;
                maxHeight = platformMaxHeight;
                break;
            }
            if (maxHeight == Integer.MIN_VALUE) {
                throw new ScriptException("Map format " + this.platform + " not high enough to accommodate maximum terrain height of " + this.importer.getWorldHighLevel() + " or water level of " + this.importer.getWorldWaterLevel());
            }
        }
        this.importer.setMinHeight(minHeight);
        this.importer.setMaxHeight(maxHeight);
        HeightMapTileFactory tileFactory = TileFactoryFactory.createNoiseTileFactory(new Random().nextLong(), Terrain.GRASS, minHeight, maxHeight, 58, this.waterLevel, false, true, 20.0f, 1.0);
        Theme defaults = Configuration.getInstance().getHeightMapDefaultTheme();
        if (defaults != null) {
            tileFactory.setTheme(defaults);
        }
        this.importer.setTileFactory(tileFactory);
        String name = this.heightMap.getName();
        int p = name.lastIndexOf(46);
        if (p != -1) {
            name = name.substring(0, p);
        }
        this.importer.setName(name);
        this.importer.setPlatform(this.platform);
        try {
            return this.importer.importToNewWorld(Dimension.Anchor.NORMAL_DETAIL, null);
        }
        catch (ProgressReceiver.OperationCancelled e) {
            throw new InternalError();
        }
    }
}

