/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class GetPlatformOp
extends AbstractOperation<Platform> {
    private String id;
    private String name;

    protected GetPlatformOp(ScriptingContext context) {
        super(context);
    }

    public GetPlatformOp withId(String id) {
        this.id = id;
        return this;
    }

    public GetPlatformOp withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Platform go() throws ScriptException {
        this.goCalled();
        if (this.id != null) {
            if (this.name != null) {
                throw new ScriptException("Both name and id set");
            }
            Platform platform = Platform.getById(this.id);
            if (platform == null) {
                throw new ScriptException("There is no map format with ID \"" + this.id + "\"");
            }
            return platform;
        }
        if (this.name != null) {
            for (Platform platform : PlatformManager.getInstance().getAllPlatforms()) {
                if (!platform.displayName.equalsIgnoreCase(this.name)) continue;
                return platform;
            }
            throw new ScriptException("There is no map format with name \"" + this.name + "\"");
        }
        throw new ScriptException("name or id not set");
    }
}

