/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.io.File;
import java.io.IOException;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.JavaWorldExporter;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;
import org.pepsoft.worldpainter.util.MinecraftUtil;

public class ExportWorldOp
extends AbstractOperation<Void> {
    private final World2 world;
    private String directory = ".";

    public ExportWorldOp(ScriptingContext context, World2 world) throws ScriptException {
        super(context);
        File savesDir;
        if (world == null) {
            throw new ScriptException("world may not be null");
        }
        this.world = world;
        File minecraftDir = MinecraftUtil.findMinecraftDir();
        if (minecraftDir != null && (savesDir = new File(minecraftDir, "saves")).isDirectory() && savesDir.canWrite()) {
            this.directory = savesDir.getAbsolutePath();
        }
    }

    public ExportWorldOp toDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    @Override
    public Void go() throws ScriptException {
        this.goCalled();
        for (int i = 0; i < 96; ++i) {
            MixedMaterial material = this.world.getMixedMaterial(i);
            Terrain.setCustomMaterial(i, material);
        }
        File baseDir = new File(this.directory);
        if (!baseDir.isDirectory()) {
            throw new ScriptException("Directory " + this.directory + " does not exist or is not a directory");
        }
        JavaWorldExporter exporter = new JavaWorldExporter(this.world, null);
        try {
            File backupDir = exporter.selectBackupDir(baseDir, this.world.getName());
            exporter.export(baseDir, this.world.getName(), backupDir, null);
        }
        catch (ProgressReceiver.OperationCancelled e) {
            throw new InternalError();
        }
        catch (IOException e) {
            throw new ScriptException("I/O error while exporting world", e);
        }
        return null;
    }
}

