/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.JavaWorldExporter;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.gardenofeden.Garden;

public class TestTool {
    public static void main(String[] args) throws IOException, ProgressReceiver.OperationCancelled {
        Random random = new Random();
        long seed = random.nextLong();
        HeightMapTileFactory tileFactory = TileFactoryFactory.createFlatTileFactory(seed, Terrain.GRASS, DefaultPlugin.JAVA_ANVIL_1_15.minZ, DefaultPlugin.JAVA_ANVIL_1_15.standardMaxHeight, 62, 0, false, false);
        World2 world = new World2(DefaultPlugin.JAVA_ANVIL_1_15, seed, tileFactory);
        world.setName("TestWorld");
        world.setSpawnPoint(new Point(64, 64));
        world.setGameType(GameType.CREATIVE);
        Dimension dimension = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        dimension.addTile(tileFactory.createTile(0, 0));
        Garden garden = dimension.getGarden();
        while (!garden.tick()) {
        }
        JavaWorldExporter worldExporter = new JavaWorldExporter(world, WorldExportSettings.EXPORT_EVERYTHING);
        File exportDir = new File(args[0]);
        worldExporter.export(exportDir, "TestWorld", worldExporter.selectBackupDir(exportDir, world.getName()), null);
    }
}

