/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.layers.FloodWithLava;

public class ResetLava {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        World2 world;
        System.out.println("Loading world " + args[0]);
        File worldFile = new File(args[0]);
        int waterLevel = Integer.parseInt(args[1]);
        ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(worldFile)));
        Object object = null;
        try {
            world = (World2)in.readObject();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        System.out.println("World loaded");
        Dimension dim0 = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        for (Tile tile : dim0.getTiles()) {
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    tile.setBitLayerValue(FloodWithLava.INSTANCE, x, y, false);
                    tile.setWaterLevel(x, y, waterLevel);
                }
            }
            System.out.print('.');
        }
        System.out.println();
        System.out.println("Saving world " + args[0]);
        Throwable throwable = null;
        try (ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(worldFile)));){
            out.writeObject(world);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        System.out.println("World saved");
    }
}

