/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.World2;

public class PruneTiles {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        World2 world;
        File worldFile = new File(args[0]);
        int maxTileDistance = Integer.parseInt(args[1]);
        try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(worldFile)));){
            world = (World2)in.readObject();
        }
        for (Dimension dimension : world.getDimensions()) {
            for (Point tileCoords : dimension.getTileCoords()) {
                int dx = Math.abs(tileCoords.x);
                int dy = Math.abs(tileCoords.y);
                if (dx <= maxTileDistance && dy <= maxTileDistance) continue;
                System.out.println("Removing tile at " + tileCoords.getX() + ", " + tileCoords.getY());
                dimension.removeTile(tileCoords);
            }
        }
        var5_4 = null;
        try (ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(worldFile)));){
            out.writeObject(world);
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }
}

