/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.TextProgressReceiver;
import org.pepsoft.worldpainter.AbstractTool;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.importing.MapImporter;
import org.pepsoft.worldpainter.plugins.MapImporterProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.PlatformProvider;

public class Import
extends AbstractTool {
    public static void main(String[] args) throws ProgressReceiver.OperationCancelled, IOException {
        Import.initialisePlatform();
        File mapDir = new File(args[0]);
        PlatformManager platformManager = PlatformManager.getInstance();
        PlatformProvider.MapInfo mapInfo = platformManager.identifyMap(mapDir);
        PlatformProvider platformProvider = platformManager.getPlatformProvider(mapInfo.platform);
        HeightMapTileFactory tileFactory = TileFactoryFactory.createNoiseTileFactory(0L, Terrain.GRASS, mapInfo.minHeight, mapInfo.maxHeight, 58, 62, false, true, 20.0f, 1.0);
        MapImporter importer = ((MapImporterProvider)((Object)platformProvider)).getImporter(mapDir, tileFactory, null, MapImporter.ReadOnlyOption.MAN_MADE, (Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)2));
        System.out.println("+---------+---------+---------+---------+---------+");
        World2 world = importer.doImport((ProgressReceiver)new TextProgressReceiver());
        System.out.println("Successfully imported world " + world.getName());
    }
}

