/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.TextProgressReceiver;
import org.pepsoft.worldpainter.AbstractTool;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.UnloadableWorldException;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldIO;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.exporting.WorldExporter;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export
extends AbstractTool {
    private static final Logger logger = LoggerFactory.getLogger(Export.class);

    public static void main(String[] args) throws IOException, ClassNotFoundException, ProgressReceiver.OperationCancelled, CertificateException, UnloadableWorldException {
        File exportDir;
        World2 world;
        Export.initialisePlatform();
        File worldFile = new File(args[0]);
        logger.info("Loading " + worldFile);
        try (FileInputStream in = new FileInputStream(worldFile);){
            WorldIO worldIO = new WorldIO();
            worldIO.load(in);
            world = worldIO.getWorld();
        }
        for (int i = 0; i < 96; ++i) {
            MixedMaterial material = world.getMixedMaterial(i);
            Terrain.setCustomMaterial(i, material);
        }
        Platform platform = world.getPlatform();
        PlatformManager platformManager = PlatformManager.getInstance();
        if (args.length > 1) {
            exportDir = new File(args[1]);
        } else {
            exportDir = platformManager.getDefaultExportDir(platform);
            if (exportDir == null) {
                exportDir = DesktopUtils.getDocumentsFolder();
            }
        }
        logger.info("Exporting to " + exportDir);
        WorldExporter exporter = platformManager.getExporter(world, WorldExportSettings.EXPORT_EVERYTHING);
        exporter.export(exportDir, world.getName(), exporter.selectBackupDir(exportDir, world.getName()), (ProgressReceiver)new TextProgressReceiver());
        System.out.println();
        logger.info("World " + world.getName() + " exported successfully");
    }
}

