/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MC115AnvilChunk;
import org.pepsoft.minecraft.MC118AnvilChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.Sign;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.TextUtils;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_17Biomes;
import org.pepsoft.worldpainter.exporting.JavaMinecraftWorld;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.util.MinecraftUtil;

public class BiomeNameHarvester {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        try {
            Class.forName("org.pepsoft.worldpainter.DefaultPlugin");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Configuration config = Configuration.load();
        if (config == null) {
            System.out.println("Creating new configuration");
            config = new Configuration();
        }
        Configuration.setInstance(config);
        System.out.println("Installation ID: " + config.getUuid());
        WPPluginManager.initialise(config.getUuid());
        if (args[0].equals("--create")) {
            File savesDir = new File(MinecraftUtil.findMinecraftDir(), "saves");
            File worldDir = new File(savesDir, "BiomeNames");
            if (worldDir.isDirectory()) {
                FileUtils.deleteDir((File)worldDir);
            }
            JavaLevel level = JavaLevel.create(DefaultPlugin.JAVA_ANVIL_1_15, 0, 256);
            level.setSeed(0L);
            level.setName("BiomeNames");
            level.setGameType(1);
            level.setHardcore(false);
            level.setDifficulty(0);
            level.setAllowCommands(true);
            level.setMapFeatures(false);
            level.setGenerator(0, new SuperflatGenerator(SuperflatPreset.defaultPreset(DefaultPlugin.JAVA_ANVIL_1_15)));
            level.setSpawnX(0);
            level.setSpawnY(5);
            level.setSpawnZ(0);
            level.save(worldDir);
            File regionDir = new File(worldDir, "region");
            regionDir.mkdirs();
            JavaMinecraftWorld world = new JavaMinecraftWorld(worldDir, 0, 0, 256, DefaultPlugin.JAVA_ANVIL_1_15, false, 256);
            try {
                for (int x = -8; x < 8; ++x) {
                    for (int z = -8; z < 8; ++z) {
                        int biomeId = (x + 8) * 16 + z + 8;
                        MC115AnvilChunk chunk = new MC115AnvilChunk(x, z, 256);
                        for (int xx = 0; xx < 16; ++xx) {
                            for (int zz = 0; zz < 16; ++zz) {
                                chunk.setMaterialAt(xx, zz, 0, Material.BEDROCK);
                                chunk.setMaterialAt(xx, zz, 1, Material.DIRT);
                                chunk.setMaterialAt(xx, zz, 2, Material.DIRT);
                                chunk.setMaterialAt(xx, zz, 3, Material.GRASS_BLOCK);
                                if (xx == 0 || zz == 0) {
                                    chunk.setMaterialAt(xx, zz, 4, Material.WOOL_MAGENTA);
                                } else if (xx == 8 && zz == 8) {
                                    chunk.setMaterialAt(xx, zz, 4, Material.OAK_SIGN);
                                    Sign sign = new Sign();
                                    String name = biomeId < Minecraft1_17Biomes.BIOME_NAMES.length && Minecraft1_17Biomes.BIOME_NAMES[biomeId] != null ? Minecraft1_17Biomes.BIOME_NAMES[biomeId] : "";
                                    sign.setText("Biome ID: " + biomeId, TextUtils.getLine((String)name, (int)15, (int)0), TextUtils.getLine((String)name, (int)15, (int)1), TextUtils.getLine((String)name, (int)15, (int)2));
                                    sign.setX(x << 4 | xx);
                                    sign.setY(4);
                                    sign.setZ(z << 4 | zz);
                                    chunk.getTileEntities().add(sign);
                                }
                                if (xx % 4 != 0 || zz % 4 != 0) continue;
                                for (int yy = 0; yy < 16; ++yy) {
                                    chunk.set3DBiome(xx >> 2, yy, zz >> 2, biomeId);
                                }
                            }
                        }
                        world.addChunk(chunk);
                    }
                }
            }
            finally {
                world.flush();
            }
        } else if (args[0].equals("--scan")) {
            HashMap<Integer, String> biomes = new HashMap<Integer, String>();
            HashMap<String, Set> legacyIds = new HashMap<String, Set>();
            File savesDir = new File(MinecraftUtil.findMinecraftDir(), "saves");
            File worldDir = new File(savesDir, "BiomeNames");
            JavaMinecraftWorld world = new JavaMinecraftWorld(worldDir, 0, 0, 256, DefaultPlugin.JAVA_ANVIL_1_18, true, 320);
            for (int x = -8; x < 8; ++x) {
                for (int z = -8; z < 8; ++z) {
                    int biomeId = (x + 8) * 16 + z + 8;
                    MC118AnvilChunk chunk = (MC118AnvilChunk)world.getChunk(x, z);
                    for (int y = 0; y < 16; ++y) {
                        String biome = chunk.getNamedBiome(2, y, 2);
                        if (biomes.containsKey(biomeId) && !((String)biomes.get(biomeId)).equals(biome)) {
                            System.err.println("Biome ID " + biomeId + " maps to multiple named biomes (at least " + (String)biomes.get(biomeId) + " and " + biome + ")");
                        } else {
                            biomes.put(biomeId, biome);
                        }
                        legacyIds.computeIfAbsent(biome, key -> new HashSet()).add(biomeId);
                    }
                }
            }
            for (int i = 0; i < 256; ++i) {
                if (i < Minecraft1_17Biomes.BIOME_NAMES.length && Minecraft1_17Biomes.BIOME_NAMES[i] != null) {
                    System.out.printf("    public static final int BIOME_%s = %d;%n", BiomeNameHarvester.toTechnicalName(Minecraft1_17Biomes.BIOME_NAMES[i]).toUpperCase(), i);
                }
                if ((i + 1) % 10 != 0) continue;
                System.out.println();
            }
        }
    }

    private static String toTechnicalName(String displayName) {
        return displayName.toLowerCase().replace(' ', '_');
    }
}

