/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.plugins;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.worldpainter.StartupMessages;
import org.pepsoft.worldpainter.plugins.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WPPluginManager {
    private final List<Plugin> allPlugins;
    public static final String DESCRIPTOR_PATH = "org.pepsoft.worldpainter.plugins";
    private static WPPluginManager instance;
    private static final Logger logger;

    private WPPluginManager(UUID uuid, ClassLoader classLoader) {
        this.allPlugins = PluginManager.findPlugins(Plugin.class, (String)DESCRIPTOR_PATH, (ClassLoader)classLoader);
        PluginManager.getErrors().forEach(StartupMessages::addError);
        PluginManager.getMessages().forEach(StartupMessages::addMessage);
        HashSet<String> namesEncountered = new HashSet<String>();
        Iterator<Plugin> i = this.allPlugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            if (plugin.getUUIDs() != null && uuid != null && !plugin.getUUIDs().contains(uuid)) {
                String message = plugin.getName() + " plugin is not authorised for this installation";
                StartupMessages.addError(message);
                logger.error(message + "; not loading it");
                i.remove();
                continue;
            }
            String name = plugin.getName();
            if (namesEncountered.contains(name)) {
                throw new RuntimeException("Multiple plugins with the same name (" + name + ") detected!");
            }
            namesEncountered.add(name);
            logger.info("Loaded plugin: " + name + " (version " + plugin.getVersion() + ")");
        }
    }

    public List<Plugin> getAllPlugins() {
        return Collections.unmodifiableList(this.allPlugins);
    }

    public <T extends Plugin> List<T> getPlugins(Class<T> type) {
        return this.allPlugins.stream().filter(plugin -> type.isAssignableFrom(plugin.getClass())).map(plugin -> plugin).collect(Collectors.toList());
    }

    public static synchronized void initialise(UUID uuid) {
        WPPluginManager.initialise(uuid, ClassLoader.getSystemClassLoader());
    }

    public static synchronized void initialise(UUID uuid, ClassLoader classLoader) {
        if (instance != null) {
            throw new IllegalStateException("Already initialised");
        }
        instance = new WPPluginManager(uuid, classLoader);
    }

    public static synchronized WPPluginManager getInstance() {
        return instance;
    }

    static {
        logger = LoggerFactory.getLogger(WPPluginManager.class);
    }
}

