/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.plugins;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.ExportSettingsEditor;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.exporting.WorldExporter;
import org.pepsoft.worldpainter.mapexplorer.MapRecognizer;
import org.pepsoft.worldpainter.plugins.Provider;

public interface PlatformProvider
extends Provider<Platform> {
    public WorldExporter getExporter(World2 var1, WorldExportSettings var2);

    public File getDefaultExportDir(Platform var1);

    default public File selectBackupDir(File exportDir) throws IOException {
        return null;
    }

    @Deprecated
    default public MapRecognizer getMapRecognizer() {
        throw new UnsupportedOperationException("Deprecated");
    }

    default public MapInfo identifyMap(File dir) {
        return null;
    }

    default public ExportSettings getDefaultExportSettings(Platform platform) {
        return null;
    }

    default public ExportSettingsEditor getExportSettingsEditor(Platform platform) {
        throw new UnsupportedOperationException("This platform has no export settings");
    }

    default public String isCompatible(Platform platform, World2 world) {
        return platform.isCompatible(world);
    }

    public static class MapInfo {
        public File dir;
        public Platform platform;
        public String name;
        public Icon icon;
        public int minHeight;
        public int maxHeight;

        public MapInfo(File dir, Platform platform, String name, Icon icon, int minHeight, int maxHeight) {
            this.dir = dir;
            this.platform = platform;
            this.name = name;
            this.icon = icon;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        @Deprecated
        public MapInfo(File dir, Platform platform, String name, Icon icon, int maxHeight) {
            this(dir, platform, name, icon, platform.minZ, maxHeight);
        }
    }
}

