/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.plugins;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.pepsoft.worldpainter.plugins.Plugin;

public abstract class AbstractPlugin
implements Plugin {
    private final Properties properties = new Properties();

    public AbstractPlugin(String name, String version) {
        this(name, version, null);
    }

    public AbstractPlugin(String name, String version, UUID uuid) {
        this.properties.setProperty("name", name);
        this.properties.setProperty("version", version);
        if (uuid != null) {
            this.properties.setProperty("uuids", uuid.toString());
        }
    }

    @Override
    public final String getName() {
        return this.properties.getProperty("name");
    }

    @Override
    public final String getVersion() {
        return this.properties.getProperty("version");
    }

    @Override
    public final Set<UUID> getUUIDs() {
        String uuidsStr = this.properties.getProperty("uuids");
        if (uuidsStr != null) {
            String[] uuidsStrs;
            HashSet<UUID> uuids = new HashSet<UUID>();
            for (String uuidStr : uuidsStrs = uuidsStr.split(",")) {
                uuids.add(UUID.fromString(uuidStr.trim()));
            }
            return uuids;
        }
        return null;
    }

    @Override
    public final Properties getProperties() {
        return (Properties)this.properties.clone();
    }
}

