/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import com.google.common.collect.ImmutableSet;
import java.awt.Point;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jnbt.CompoundTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.MCRegionChunk;
import org.pepsoft.minecraft.NBTChunk;
import org.pepsoft.worldpainter.exporting.PostProcessor;
import org.pepsoft.worldpainter.platforms.AbstractJavaPlatformProviderImpl;
import org.pepsoft.worldpainter.platforms.Java1_2PostProcessor;

final class MCRegionPlatformProvider
extends AbstractJavaPlatformProviderImpl {
    private static final Set<DataType> DATA_TYPES = ImmutableSet.of((Object)((Object)DataType.REGION));
    private static final Pattern REGION_FILE_PATTERN = Pattern.compile("r\\.-?\\d+\\.-?\\d+\\.mcr");

    MCRegionPlatformProvider() {
    }

    @Override
    Set<DataType> getDataTypes() {
        return DATA_TYPES;
    }

    @Override
    NBTChunk createChunk(Map<DataType, Tag> tags, int minHeight, int maxHeight, boolean readOnly) {
        if (minHeight != 0) {
            throw new IllegalArgumentException("minHeight " + minHeight);
        }
        return new MCRegionChunk((CompoundTag)tags.get((Object)DataType.REGION), maxHeight, readOnly);
    }

    @Override
    File[] getRegionFiles(File regionDir, DataType dataType) {
        if (dataType != DataType.REGION) {
            throw new IllegalArgumentException("Only REGION data type is supported");
        }
        return regionDir.listFiles((dir, name) -> REGION_FILE_PATTERN.matcher(name).matches());
    }

    @Override
    File getRegionFileFile(File regionDir, DataType dataType, Point coords) {
        if (dataType != DataType.REGION) {
            throw new IllegalArgumentException("Only REGION data type is supported");
        }
        return new File(regionDir, "r." + coords.x + "." + coords.y + ".mcr");
    }

    @Override
    PostProcessor getPostProcessor() {
        return new Java1_2PostProcessor();
    }

    @Override
    NBTChunk createChunk(int x, int z, int minHeight, int maxHeight) {
        if (minHeight != 0) {
            throw new IllegalArgumentException("minHeight " + minHeight);
        }
        return new MCRegionChunk(x, z, maxHeight);
    }
}

