/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.awt.Image;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jnbt.CompoundTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.CustomGenerator;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.NBTChunk;
import org.pepsoft.minecraft.RegionFile;
import org.pepsoft.minecraft.mapexplorer.JavaMapRootNode;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.ExportSettingsEditor;
import org.pepsoft.worldpainter.exporting.JavaChunkStore;
import org.pepsoft.worldpainter.exporting.JavaWorldExporter;
import org.pepsoft.worldpainter.exporting.PostProcessor;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.exporting.WorldExporter;
import org.pepsoft.worldpainter.importing.JavaMapImporter;
import org.pepsoft.worldpainter.importing.MapImporter;
import org.pepsoft.worldpainter.mapexplorer.MapExplorerSupport;
import org.pepsoft.worldpainter.mapexplorer.Node;
import org.pepsoft.worldpainter.platforms.AbstractJavaPlatformProviderImpl;
import org.pepsoft.worldpainter.platforms.AbstractPlatformProvider;
import org.pepsoft.worldpainter.platforms.Anvil1_15PlatformProvider;
import org.pepsoft.worldpainter.platforms.Anvil1_17PlatformProvider;
import org.pepsoft.worldpainter.platforms.Anvil1_18PlatformProvider;
import org.pepsoft.worldpainter.platforms.Anvil1_2PlatformProvider;
import org.pepsoft.worldpainter.platforms.JavaExportSettings;
import org.pepsoft.worldpainter.platforms.JavaExportSettingsEditor;
import org.pepsoft.worldpainter.platforms.MCRegionPlatformProvider;
import org.pepsoft.worldpainter.plugins.BlockBasedPlatformProvider;
import org.pepsoft.worldpainter.plugins.MapImporterProvider;
import org.pepsoft.worldpainter.plugins.PlatformProvider;
import org.pepsoft.worldpainter.util.MinecraftUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaPlatformProvider
extends AbstractPlatformProvider
implements BlockBasedPlatformProvider,
MapExplorerSupport,
MapImporterProvider {
    private final Map<Platform, AbstractJavaPlatformProviderImpl> implementations = ImmutableMap.of((Object)DefaultPlugin.JAVA_MCREGION, (Object)new MCRegionPlatformProvider(), (Object)DefaultPlugin.JAVA_ANVIL, (Object)new Anvil1_2PlatformProvider(), (Object)DefaultPlugin.JAVA_ANVIL_1_15, (Object)new Anvil1_15PlatformProvider(), (Object)DefaultPlugin.JAVA_ANVIL_1_17, (Object)new Anvil1_17PlatformProvider(), (Object)DefaultPlugin.JAVA_ANVIL_1_18, (Object)new Anvil1_18PlatformProvider(), (Object)DefaultPlugin.JAVA_ANVIL_1_19, (Object)new Anvil1_18PlatformProvider());
    public static final Icon ICON = new ImageIcon(IconUtils.scaleIcon((Image)IconUtils.loadUnscaledImage((String)"org/pepsoft/worldpainter/mapexplorer/maproot.png"), (int)16));
    private static final Logger logger = LoggerFactory.getLogger(JavaPlatformProvider.class);

    public JavaPlatformProvider() {
        super(Version.VERSION, DefaultPlugin.DEFAULT_JAVA_PLATFORMS, "JavaPlatformProvider");
    }

    public Set<DataType> getDataTypes(Platform platform) {
        return this.implementations.get(platform).getDataTypes();
    }

    public NBTChunk createChunk(Platform platform, Map<DataType, Tag> tags, int minHeight, int maxHeight) {
        return this.createChunk(platform, tags, minHeight, maxHeight, false);
    }

    public NBTChunk createChunk(Platform platform, Map<DataType, Tag> tags, int minHeight, int maxHeight, boolean readOnly) {
        return this.implementations.get(platform).createChunk(tags, minHeight, maxHeight, readOnly);
    }

    public File[] getRegionFiles(Platform platform, File regionDir, DataType dataType) {
        return this.implementations.get(platform).getRegionFiles(regionDir, dataType);
    }

    public RegionFile getRegionFile(Platform platform, File regionDir, DataType dataType, Point coords, boolean readOnly) throws IOException {
        File file = this.getRegionFileFile(platform, regionDir, dataType, coords);
        if (file.isFile() || !readOnly) {
            return new RegionFile(file, readOnly);
        }
        return null;
    }

    public RegionFile getRegionFileIfExists(Platform platform, File regionDir, DataType dataType, Point coords, boolean readOnly) throws IOException {
        File file = this.getRegionFileFile(platform, regionDir, dataType, coords);
        return file.isFile() ? new RegionFile(file, readOnly) : null;
    }

    @Override
    public int[] getDimensions(Platform platform, File worldDir) {
        this.ensurePlatformSupported(platform);
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        for (int dim : new int[]{0, 1, 2}) {
            if (!this.containsFiles(MinecraftUtil.getRegionDir(worldDir, dim))) continue;
            dimensions.add(dim);
        }
        return Ints.toArray(dimensions);
    }

    @Override
    public Chunk createChunk(Platform platform, int x, int z, int minHeight, int maxHeight) {
        return this.implementations.get(platform).createChunk(x, z, minHeight, maxHeight);
    }

    @Override
    public JavaChunkStore getChunkStore(Platform platform, File worldDir, int dimension) {
        JavaLevel level;
        this.ensurePlatformSupported(platform);
        File levelDatFile = new File(worldDir, "level.dat");
        try {
            level = JavaLevel.load(levelDatFile);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while trying to read level.dat", e);
        }
        return new JavaChunkStore(platform, MinecraftUtil.getRegionDir(worldDir, dimension), level.getMinHeight(), level.getMaxHeight());
    }

    @Override
    public PostProcessor getPostProcessor(Platform platform) {
        return this.implementations.get(platform).getPostProcessor();
    }

    @Override
    public WorldExporter getExporter(World2 world, WorldExportSettings exportSettings) {
        Platform platform = world.getPlatform();
        this.ensurePlatformSupported(platform);
        return new JavaWorldExporter(world, exportSettings);
    }

    @Override
    public File getDefaultExportDir(Platform platform) {
        File minecraftDir = MinecraftUtil.findMinecraftDir();
        return minecraftDir != null ? new File(minecraftDir, "saves") : null;
    }

    @Override
    public File selectBackupDir(File exportDir) {
        return new File(exportDir.getParentFile(), "backups");
    }

    @Override
    public PlatformProvider.MapInfo identifyMap(File dir) {
        File file = new File(dir, "level.dat");
        if (file.isFile() && !new File(dir, "db").isDirectory() && !new File(dir, "levelname.txt").isFile()) {
            try {
                JavaLevel level = JavaLevel.load(file);
                return new PlatformProvider.MapInfo(dir, level.getPlatform(), level.getName(), ICON, level.getMinHeight(), level.getMaxHeight());
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.info("I/O error reading {}; assuming it is not a (supported) Java Minecraft level.dat file", (Object)file.getAbsolutePath(), (Object)e);
                }
                logger.info("I/O error reading {}; assuming it is not a (supported) Java Minecraft level.dat file (type: {}, message: \"{}\")", new Object[]{file.getAbsolutePath(), e.getClass().getSimpleName(), e.getMessage()});
            }
        }
        return null;
    }

    @Override
    public Node getMapNode(File mapDir) {
        return new JavaMapRootNode(mapDir);
    }

    @Override
    public MapImporter getImporter(File dir, TileFactory tileFactory, Set<MinecraftCoords> chunksToSkip, MapImporter.ReadOnlyOption readOnlyOption, Set<Integer> dimensionsToImport) {
        PlatformProvider.MapInfo mapInfo = this.identifyMap(dir);
        if (mapInfo != null) {
            this.ensurePlatformSupported(mapInfo.platform);
            return new JavaMapImporter(mapInfo.platform, tileFactory, new File(dir, "level.dat"), chunksToSkip, readOnlyOption, dimensionsToImport);
        }
        throw new IllegalArgumentException("Platform for map " + dir.getName() + " could not be identified");
    }

    @Override
    public ExportSettings getDefaultExportSettings(Platform platform) {
        return new JavaExportSettings();
    }

    @Override
    public ExportSettingsEditor getExportSettingsEditor(Platform platform) {
        return new JavaExportSettingsEditor(platform);
    }

    @Override
    public String isCompatible(Platform platform, World2 world) {
        this.ensurePlatformSupported(platform);
        String superReason = super.isCompatible(platform, world);
        if (superReason == null && platform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION).isAtLeast(Constants.V_1_17)) {
            for (Dimension dimension : world.getDimensions()) {
                MapGenerator generator = dimension.getGenerator();
                if (generator == null || generator.getType() != Generator.CUSTOM || ((CustomGenerator)generator).getSettings() instanceof CompoundTag) continue;
                return "World type " + generator + " not supported by map format";
            }
        }
        return superReason;
    }

    private File getRegionFileFile(Platform platform, File regionDir, DataType dataType, Point coords) {
        return this.implementations.get(platform).getRegionFileFile(regionDir, dataType, coords);
    }

    private boolean containsFiles(File dir) {
        return dir.isDirectory() && dir.listFiles().length > 0;
    }
}

