/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import org.pepsoft.minecraft.Block;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.Box;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.PostProcessor;
import org.pepsoft.worldpainter.objects.MinecraftWorldObject;
import org.pepsoft.worldpainter.platforms.JavaExportSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java1_2PostProcessor
extends PostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Java1_2PostProcessor.class);

    @Override
    public void postProcess(MinecraftWorld minecraftWorld, Box volume, ExportSettings exportSettings, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        int y;
        int x;
        int maxZ;
        int minZ;
        int y2;
        int y1;
        int x2;
        int x1;
        if (!enabled) {
            return;
        }
        if (progressReceiver != null) {
            progressReceiver.setMessage("Post processing exported blocks (first pass)");
        }
        int worldMaxZ = minecraftWorld.getMaxHeight() - 1;
        JavaExportSettings settings = exportSettings instanceof JavaExportSettings ? (JavaExportSettings)exportSettings : new JavaExportSettings();
        JavaExportSettings.FloatMode sandMode = "false".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.supportSand")) ? JavaExportSettings.FloatMode.LEAVE_FLOATING : settings.sandMode;
        JavaExportSettings.FloatMode gravelMode = settings.gravelMode;
        JavaExportSettings.FloatMode cementMode = settings.cementMode;
        JavaExportSettings.FloatMode waterMode = settings.waterMode;
        JavaExportSettings.FloatMode lavaMode = settings.lavaMode;
        boolean flowLava = settings.flowLava;
        boolean flowWater = settings.flowWater;
        boolean makeAllLeavesPersistent = settings.makeAllLeavesPersistent;
        boolean leavePlants = settings.leavePlants;
        if (minecraftWorld instanceof MinecraftWorldObject) {
            Box objectVolume = ((MinecraftWorldObject)minecraftWorld).getVolume();
            objectVolume.intersect(volume);
            if (objectVolume.isEmpty()) {
                return;
            }
            x1 = objectVolume.getX1();
            x2 = objectVolume.getX2() - 1;
            y1 = objectVolume.getY1();
            y2 = objectVolume.getY2() - 1;
            minZ = objectVolume.getZ1();
            maxZ = objectVolume.getZ2() - 1;
        } else {
            x1 = volume.getX1();
            y1 = volume.getY1();
            x2 = volume.getX2() - 1;
            y2 = volume.getY2() - 1;
            minZ = volume.getZ1();
            maxZ = volume.getZ2() - 1;
        }
        boolean traceEnabled = logger.isTraceEnabled();
        for (x = x1; x <= x2; ++x) {
            for (y = y1; y <= y2; ++y) {
                int blockTypeBelow = minZ <= 0 ? 0 : minecraftWorld.getBlockTypeAt(x, y, minZ - 1);
                int dataBelow = minZ <= 0 ? 0 : minecraftWorld.getDataAt(x, y, minZ - 1);
                int blockTypeAbove = minecraftWorld.getBlockTypeAt(x, y, minZ);
                int dataAbove = minecraftWorld.getDataAt(x, y, minZ);
                int columnMaxZ = Math.min(minecraftWorld.getHighestNonAirBlock(x, y), maxZ);
                for (int z = minZ; z <= columnMaxZ; ++z) {
                    int blockType = blockTypeAbove;
                    int data = dataAbove;
                    blockTypeAbove = z < worldMaxZ ? minecraftWorld.getBlockTypeAt(x, y, z + 1) : 0;
                    int n = dataAbove = z < worldMaxZ ? minecraftWorld.getDataAt(x, y, z + 1) : 0;
                    if ((blockTypeBelow == 2 || blockTypeBelow == 110 || blockTypeBelow == 60) && (blockType == 8 || blockType == 9 || blockType == 79 || blockType <= 255 && Block.BLOCK_TRANSPARENCY[blockType] == 15)) {
                        minecraftWorld.setMaterialAt(x, y, z - 1, Material.DIRT);
                        blockTypeBelow = 3;
                        dataBelow = 0;
                    }
                    block0 : switch (blockType) {
                        case 12: {
                            if (!Block.BLOCKS[blockTypeBelow].veryInsubstantial) break;
                            switch (sandMode) {
                                case DROP: {
                                    this.dropBlock(minecraftWorld, x, y, z);
                                    blockType = 0;
                                    data = 0;
                                    break block0;
                                }
                                case SUPPORT: {
                                    minecraftWorld.setMaterialAt(x, y, z, data == 1 ? Material.RED_SANDSTONE : Material.SANDSTONE);
                                    blockType = minecraftWorld.getBlockTypeAt(x, y, z);
                                    data = 0;
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 13: {
                            if (!Block.BLOCKS[blockTypeBelow].veryInsubstantial) break;
                            switch (gravelMode) {
                                case DROP: {
                                    this.dropBlock(minecraftWorld, x, y, z);
                                    blockType = 0;
                                    data = 0;
                                    break block0;
                                }
                                case SUPPORT: {
                                    minecraftWorld.setMaterialAt(x, y, z, Material.STONE);
                                    blockType = 1;
                                    data = 0;
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 252: {
                            if (!Block.BLOCKS[blockTypeBelow].veryInsubstantial) break;
                            switch (cementMode) {
                                case DROP: {
                                    this.dropBlock(minecraftWorld, x, y, z);
                                    blockType = 0;
                                    data = 0;
                                    break block0;
                                }
                                case SUPPORT: {
                                    throw new UnsupportedOperationException("Don't know how to support cement yet");
                                }
                            }
                            break;
                        }
                        case 8: 
                        case 9: {
                            if (blockTypeBelow == 8 || blockTypeBelow == 9 || !Block.BLOCKS[blockTypeBelow].veryInsubstantial) break;
                            switch (waterMode) {
                                case DROP: {
                                    this.dropFluid(minecraftWorld, x, y, z);
                                    break block0;
                                }
                                case SUPPORT: {
                                    throw new UnsupportedOperationException("Don't know how to support water yet");
                                }
                            }
                            break;
                        }
                        case 10: 
                        case 11: {
                            if (blockTypeBelow == 10 || blockTypeBelow == 11 || !Block.BLOCKS[blockTypeBelow].veryInsubstantial) break;
                            switch (lavaMode) {
                                case DROP: {
                                    this.dropFluid(minecraftWorld, x, y, z);
                                    break block0;
                                }
                                case SUPPORT: {
                                    throw new UnsupportedOperationException("Don't know how to support lava yet");
                                }
                            }
                            break;
                        }
                        case 78: {
                            if (blockTypeBelow != 79 && blockTypeBelow != 78 && blockTypeBelow != 0 && blockTypeBelow != 174) break;
                            minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                            blockType = 0;
                            data = 0;
                            break;
                        }
                        case 51: {
                            if (blockTypeBelow != 0 || blockTypeAbove != 0 || minecraftWorld.getBlockTypeAt(x - 1, y, z) != 0 || minecraftWorld.getBlockTypeAt(x + 1, y, z) != 0 || minecraftWorld.getBlockTypeAt(x, y - 1, z) != 0 || minecraftWorld.getBlockTypeAt(x, y + 1, z) != 0) break;
                            minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                            blockType = 0;
                            data = 0;
                            break;
                        }
                        case 18: 
                        case 161: {
                            if (!makeAllLeavesPersistent || (data & 4) != 0) break;
                            minecraftWorld.setDataAt(x, y, z, data | 4);
                        }
                    }
                    if (!leavePlants) {
                        Material materialBelow = Material.getByCombinedIndex(blockTypeBelow << 4 | dataBelow);
                        if (!materialBelow.modded) {
                            switch (blockType) {
                                case 32: {
                                    if (blockTypeBelow == 12 || blockTypeBelow == 3 || blockTypeBelow == 159 || blockTypeBelow == 172) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 31: 
                                case 37: 
                                case 38: {
                                    if (blockTypeBelow == 2 || blockTypeBelow == 3) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 39: 
                                case 40: {
                                    if (blockTypeBelow == 2 || blockTypeBelow == 3 || blockTypeBelow == 110 || blockTypeBelow == 1) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 59: {
                                    if (blockTypeBelow == 60) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 175: {
                                    if ((data & 8) != 0 || blockTypeBelow == 2 || blockTypeBelow == 3) break;
                                    if (traceEnabled) {
                                        logger.trace("Block @ " + x + "," + z + "," + y + " is lower large flower block; block above is " + Block.BLOCK_TYPE_NAMES[blockTypeBelow] + "; removing block");
                                    }
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 81: {
                                    if (blockTypeBelow == 12 || blockTypeBelow == 81) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 83: {
                                    if (blockTypeBelow == 2 || blockTypeBelow == 3 || blockTypeBelow == 12 || blockTypeBelow == 83) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 115: {
                                    if (blockTypeBelow == 88) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 199: 
                                case 200: {
                                    if (blockTypeBelow == 121 || blockTypeBelow == 199) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                    break;
                                }
                                case 111: {
                                    if (materialBelow.containsWater()) break;
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                }
                            }
                        }
                        if (blockType == 175) {
                            if ((data & 8) == 8) {
                                if (blockTypeBelow != 175) {
                                    if (traceEnabled) {
                                        logger.trace("Block @ " + x + "," + z + "," + y + " is upper large flower block; block below is " + Block.BLOCK_TYPE_NAMES[blockTypeBelow] + "; removing block");
                                    }
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                }
                            } else if (blockTypeAbove == 175) {
                                if ((minecraftWorld.getDataAt(x, y, z + 1) & 8) == 0) {
                                    if (traceEnabled) {
                                        logger.trace("Block @ " + x + "," + z + "," + y + " is lower large flower block; block above is another lower large flower block; removing block");
                                    }
                                    minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                    blockType = 0;
                                    data = 0;
                                }
                            } else {
                                if (traceEnabled) {
                                    logger.trace("Block @ " + x + "," + z + "," + y + " is lower large flower block; block above is " + Block.BLOCK_TYPE_NAMES[blockTypeBelow] + "; removing block");
                                }
                                minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                                blockType = 0;
                                data = 0;
                            }
                        }
                    }
                    blockTypeBelow = blockType;
                    dataBelow = data;
                }
            }
            if (progressReceiver == null) continue;
            progressReceiver.setProgress((float)(x - x1 + 1) / (float)(x2 - x1 + 1));
        }
        if (flowWater || flowLava) {
            if (progressReceiver != null) {
                progressReceiver.setMessage("Post processing exported blocks (fluids pass)");
            }
            for (x = x1; x <= x2; ++x) {
                for (y = y1; y <= y2; ++y) {
                    int columnMaxZ = Math.min(minecraftWorld.getHighestNonAirBlock(x, y), maxZ);
                    for (int z = minZ + 1; z <= columnMaxZ; ++z) {
                        Material materialBelow;
                        int blockType = minecraftWorld.getBlockTypeAt(x, y, z);
                        Material material = materialBelow = z > minZ ? minecraftWorld.getMaterialAt(x, y, z - 1) : Material.AIR;
                        if (flowWater && blockType == 9 && !this.isWaterContained(minecraftWorld, x, y, z, materialBelow)) {
                            minecraftWorld.setMaterialAt(x, y, z, Material.get(8, minecraftWorld.getDataAt(x, y, z)));
                            continue;
                        }
                        if (!flowLava || blockType != 11 || this.isLavaContained(minecraftWorld, x, y, z, materialBelow)) continue;
                        minecraftWorld.setMaterialAt(x, y, z, Material.get(10, minecraftWorld.getDataAt(x, y, z)));
                    }
                }
                if (progressReceiver == null) continue;
                progressReceiver.setProgress(0.75f + (float)(x - x1 + 1) / (float)(x2 - x1 + 1) * 0.25f);
            }
        } else if (progressReceiver != null) {
            progressReceiver.setProgress(1.0f);
        }
    }
}

