/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.panels;

import org.pepsoft.minecraft.Constants;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.selection.SelectionBlock;
import org.pepsoft.worldpainter.selection.SelectionChunk;

public final class DefaultFilter
implements Filter {
    final boolean checkLevel;
    final boolean onlyOn;
    final boolean exceptOn;
    final boolean feather;
    final boolean checkSlope;
    final boolean slopeIsAbove;
    final boolean inSelection;
    final boolean outsideSelection;
    final LevelType levelType;
    final ObjectType onlyOnObjectType;
    final ObjectType exceptOnObjectType;
    final int aboveLevel;
    final int belowLevel;
    final int onlyOnValue;
    final int exceptOnValue;
    final int degrees;
    final Terrain onlyOnTerrain;
    final Terrain exceptOnTerrain;
    final Layer onlyOnLayer;
    final Layer exceptOnLayer;
    final float slope;
    Dimension dimension;
    public static final String LAND = "Land";
    public static final String WATER = "Water";
    public static final String LAVA = "Lava";
    public static final String AUTO_BIOMES = "Automatic Biomes";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultFilter(Dimension dimension, boolean inSelection, boolean outsideSelection, int aboveLevel, int belowLevel, boolean feather, Object onlyOn, Object exceptOn, int aboveDegrees, boolean slopeIsAbove) {
        LayerValue layerValue;
        this.dimension = dimension;
        this.inSelection = inSelection;
        this.outsideSelection = outsideSelection;
        if (inSelection && outsideSelection) {
            throw new IllegalArgumentException("inSelection and outsideSelection are mutually exclusive");
        }
        this.aboveLevel = aboveLevel;
        this.belowLevel = belowLevel;
        if (aboveLevel != Integer.MIN_VALUE) {
            this.checkLevel = true;
            this.levelType = belowLevel != Integer.MIN_VALUE ? (belowLevel >= aboveLevel ? LevelType.BETWEEN : LevelType.OUTSIDE) : LevelType.ABOVE;
        } else if (belowLevel != Integer.MIN_VALUE) {
            this.checkLevel = true;
            this.levelType = LevelType.BELOW;
        } else {
            this.checkLevel = false;
            this.levelType = null;
        }
        this.feather = feather;
        if (onlyOn instanceof Terrain) {
            this.onlyOn = true;
            this.onlyOnObjectType = ObjectType.TERRAIN;
            this.onlyOnTerrain = (Terrain)((Object)onlyOn);
            this.onlyOnLayer = null;
            this.onlyOnValue = -1;
        } else if (onlyOn instanceof Layer) {
            this.onlyOn = true;
            this.onlyOnObjectType = ((Layer)onlyOn).getDataSize() == Layer.DataSize.BIT || ((Layer)onlyOn).getDataSize() == Layer.DataSize.BIT_PER_CHUNK ? ObjectType.BIT_LAYER : ObjectType.INT_LAYER_ANY;
            this.onlyOnTerrain = null;
            this.onlyOnLayer = (Layer)onlyOn;
            this.onlyOnValue = -1;
        } else if (onlyOn instanceof LayerValue) {
            this.onlyOn = true;
            layerValue = (LayerValue)onlyOn;
            if (layerValue.layer instanceof Biome) {
                if (layerValue.value < 0) {
                    this.onlyOnObjectType = ObjectType.AUTO_BIOME;
                    this.onlyOnTerrain = null;
                    this.onlyOnLayer = null;
                    this.onlyOnValue = -layerValue.value;
                } else {
                    this.onlyOnObjectType = ObjectType.BIOME;
                    this.onlyOnTerrain = null;
                    this.onlyOnLayer = null;
                    this.onlyOnValue = layerValue.value;
                }
            } else if (layerValue.layer instanceof Annotations) {
                if (layerValue.condition == null) {
                    this.onlyOnObjectType = ObjectType.ANNOTATION_ANY;
                    this.onlyOnTerrain = null;
                    this.onlyOnLayer = null;
                    this.onlyOnValue = -1;
                } else {
                    this.onlyOnObjectType = ObjectType.ANNOTATION;
                    this.onlyOnTerrain = null;
                    this.onlyOnLayer = null;
                    this.onlyOnValue = layerValue.value;
                }
            } else {
                if (layerValue.layer.getDataSize() == Layer.DataSize.BIT || layerValue.layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK || layerValue.layer.getDataSize() == Layer.DataSize.NONE) throw new IllegalArgumentException("Layer value of type " + layerValue.layer.getClass().getSimpleName() + " not supported");
                if (layerValue.condition == null) {
                    this.onlyOnObjectType = ObjectType.INT_LAYER_ANY;
                    this.onlyOnTerrain = null;
                    this.onlyOnLayer = null;
                    this.onlyOnValue = -1;
                } else {
                    switch (layerValue.condition) {
                        case EQUAL: {
                            this.onlyOnObjectType = ObjectType.INT_LAYER_EQUAL;
                            break;
                        }
                        case HIGHER_THAN_OR_EQUAL: {
                            this.onlyOnObjectType = ObjectType.INT_LAYER_EQUAL_OR_HIGHER;
                            break;
                        }
                        case LOWER_THAN_OR_EQUAL: {
                            this.onlyOnObjectType = ObjectType.INT_LAYER_EQUAL_OR_LOWER;
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.onlyOnTerrain = null;
                    this.onlyOnLayer = null;
                    this.onlyOnValue = layerValue.value;
                }
            }
        } else if (WATER.equals(onlyOn)) {
            this.onlyOn = true;
            this.onlyOnObjectType = ObjectType.WATER;
            this.onlyOnTerrain = null;
            this.onlyOnLayer = null;
            this.onlyOnValue = -1;
        } else if (LAVA.equals(onlyOn)) {
            this.onlyOn = true;
            this.onlyOnObjectType = ObjectType.LAVA;
            this.onlyOnTerrain = null;
            this.onlyOnLayer = null;
            this.onlyOnValue = -1;
        } else if (LAND.equals(onlyOn)) {
            this.onlyOn = true;
            this.onlyOnObjectType = ObjectType.LAND;
            this.onlyOnTerrain = null;
            this.onlyOnLayer = null;
            this.onlyOnValue = -1;
        } else if (AUTO_BIOMES.equals(onlyOn)) {
            this.onlyOn = true;
            this.onlyOnObjectType = ObjectType.BIOME;
            this.onlyOnTerrain = null;
            this.onlyOnLayer = null;
            this.onlyOnValue = 255;
        } else {
            this.onlyOn = false;
            this.onlyOnObjectType = null;
            this.onlyOnTerrain = null;
            this.onlyOnLayer = null;
            this.onlyOnValue = -1;
        }
        if (exceptOn instanceof Terrain) {
            this.exceptOn = true;
            this.exceptOnObjectType = ObjectType.TERRAIN;
            this.exceptOnTerrain = (Terrain)((Object)exceptOn);
            this.exceptOnLayer = null;
            this.exceptOnValue = -1;
        } else if (exceptOn instanceof Layer) {
            this.exceptOn = true;
            this.exceptOnObjectType = ((Layer)exceptOn).getDataSize() == Layer.DataSize.BIT || ((Layer)exceptOn).getDataSize() == Layer.DataSize.BIT_PER_CHUNK ? ObjectType.BIT_LAYER : ObjectType.INT_LAYER_ANY;
            this.exceptOnTerrain = null;
            this.exceptOnLayer = (Layer)exceptOn;
            this.exceptOnValue = -1;
        } else if (exceptOn instanceof LayerValue) {
            this.exceptOn = true;
            layerValue = (LayerValue)exceptOn;
            if (layerValue.layer instanceof Biome) {
                if (layerValue.value < 0) {
                    this.exceptOnObjectType = ObjectType.AUTO_BIOME;
                    this.exceptOnTerrain = null;
                    this.exceptOnLayer = null;
                    this.exceptOnValue = -layerValue.value;
                } else {
                    this.exceptOnObjectType = ObjectType.BIOME;
                    this.exceptOnTerrain = null;
                    this.exceptOnLayer = null;
                    this.exceptOnValue = layerValue.value;
                }
            } else if (layerValue.layer instanceof Annotations) {
                if (layerValue.condition == null) {
                    this.exceptOnObjectType = ObjectType.ANNOTATION_ANY;
                    this.exceptOnTerrain = null;
                    this.exceptOnLayer = null;
                    this.exceptOnValue = -1;
                } else {
                    this.exceptOnObjectType = ObjectType.ANNOTATION;
                    this.exceptOnTerrain = null;
                    this.exceptOnLayer = null;
                    this.exceptOnValue = layerValue.value;
                }
            } else {
                if (layerValue.layer.getDataSize() == Layer.DataSize.BIT || layerValue.layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK || layerValue.layer.getDataSize() == Layer.DataSize.NONE) throw new IllegalArgumentException("Layer value of type " + layerValue.layer.getClass().getSimpleName() + " not supported");
                if (layerValue.condition == null) {
                    this.exceptOnObjectType = ObjectType.INT_LAYER_ANY;
                    this.exceptOnTerrain = null;
                    this.exceptOnLayer = null;
                    this.exceptOnValue = -1;
                } else {
                    switch (layerValue.condition) {
                        case EQUAL: {
                            this.exceptOnObjectType = ObjectType.INT_LAYER_EQUAL;
                            break;
                        }
                        case HIGHER_THAN_OR_EQUAL: {
                            this.exceptOnObjectType = ObjectType.INT_LAYER_EQUAL_OR_HIGHER;
                            break;
                        }
                        case LOWER_THAN_OR_EQUAL: {
                            this.exceptOnObjectType = ObjectType.INT_LAYER_EQUAL_OR_LOWER;
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.exceptOnTerrain = null;
                    this.exceptOnLayer = null;
                    this.exceptOnValue = layerValue.value;
                }
            }
        } else if (WATER.equals(exceptOn)) {
            this.exceptOn = true;
            this.exceptOnObjectType = ObjectType.WATER;
            this.exceptOnTerrain = null;
            this.exceptOnLayer = null;
            this.exceptOnValue = -1;
        } else if (LAVA.equals(exceptOn)) {
            this.exceptOn = true;
            this.exceptOnObjectType = ObjectType.LAVA;
            this.exceptOnTerrain = null;
            this.exceptOnLayer = null;
            this.exceptOnValue = -1;
        } else if (LAND.equals(exceptOn)) {
            this.exceptOn = true;
            this.exceptOnObjectType = ObjectType.LAND;
            this.exceptOnTerrain = null;
            this.exceptOnLayer = null;
            this.exceptOnValue = -1;
        } else if (AUTO_BIOMES.equals(exceptOn)) {
            this.exceptOn = true;
            this.exceptOnObjectType = ObjectType.BIOME;
            this.exceptOnTerrain = null;
            this.exceptOnLayer = null;
            this.exceptOnValue = 255;
        } else {
            this.exceptOn = false;
            this.exceptOnObjectType = null;
            this.exceptOnTerrain = null;
            this.exceptOnLayer = null;
            this.exceptOnValue = -1;
        }
        this.degrees = aboveDegrees;
        this.checkSlope = aboveDegrees >= 0;
        this.slope = this.checkSlope ? (float)Math.tan((double)aboveDegrees / 57.29577951308232) : 0.0f;
        this.slopeIsAbove = slopeIsAbove;
    }

    public int getAboveLevel() {
        return this.aboveLevel;
    }

    public int getBelowLevel() {
        return this.belowLevel;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public boolean isInSelection() {
        return this.inSelection;
    }

    public Layer getOnlyOnLayer() {
        return this.onlyOnLayer;
    }

    public Layer getExceptOnLayer() {
        return this.exceptOnLayer;
    }

    public static Builder buildForDimension(Dimension dimension) {
        return new Builder(dimension);
    }

    @Override
    public float modifyStrength(int x, int y, float strength) {
        if (strength > 0.0f) {
            if (this.inSelection && !this.dimension.getBitLayerValueAt(SelectionChunk.INSTANCE, x, y) && !this.dimension.getBitLayerValueAt(SelectionBlock.INSTANCE, x, y)) {
                return 0.0f;
            }
            if (this.outsideSelection && (this.dimension.getBitLayerValueAt(SelectionChunk.INSTANCE, x, y) || this.dimension.getBitLayerValueAt(SelectionBlock.INSTANCE, x, y))) {
                return 0.0f;
            }
            if (this.exceptOn) {
                switch (this.exceptOnObjectType) {
                    case BIOME: {
                        if (this.dimension.getLayerValueAt(Biome.INSTANCE, x, y) != this.exceptOnValue) break;
                        return 0.0f;
                    }
                    case AUTO_BIOME: {
                        if (this.dimension.getAutoBiome(x, y) != this.exceptOnValue) break;
                        return 0.0f;
                    }
                    case BIT_LAYER: {
                        if (!this.dimension.getBitLayerValueAt(this.exceptOnLayer, x, y)) break;
                        return 0.0f;
                    }
                    case INT_LAYER_ANY: {
                        if (this.dimension.getLayerValueAt(this.exceptOnLayer, x, y) == 0) break;
                        return 0.0f;
                    }
                    case INT_LAYER_EQUAL: {
                        if (this.dimension.getLayerValueAt(this.exceptOnLayer, x, y) == this.exceptOnValue) break;
                        return 0.0f;
                    }
                    case INT_LAYER_EQUAL_OR_HIGHER: {
                        if (this.dimension.getLayerValueAt(this.exceptOnLayer, x, y) >= this.exceptOnValue) break;
                        return 0.0f;
                    }
                    case INT_LAYER_EQUAL_OR_LOWER: {
                        if (this.dimension.getLayerValueAt(this.exceptOnLayer, x, y) <= this.exceptOnValue) break;
                        return 0.0f;
                    }
                    case TERRAIN: {
                        if (this.dimension.getTerrainAt(x, y) != this.exceptOnTerrain) break;
                        return 0.0f;
                    }
                    case WATER: {
                        if (this.dimension.getWaterLevelAt(x, y) <= this.dimension.getIntHeightAt(x, y) || this.dimension.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y)) break;
                        return 0.0f;
                    }
                    case LAVA: {
                        if (this.dimension.getWaterLevelAt(x, y) <= this.dimension.getIntHeightAt(x, y) || !this.dimension.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y)) break;
                        return 0.0f;
                    }
                    case LAND: {
                        if (this.dimension.getWaterLevelAt(x, y) > this.dimension.getIntHeightAt(x, y)) break;
                        return 0.0f;
                    }
                    case ANNOTATION_ANY: {
                        if (this.dimension.getLayerValueAt(Annotations.INSTANCE, x, y) <= 0) break;
                        return 0.0f;
                    }
                    case ANNOTATION: {
                        if (this.dimension.getLayerValueAt(Annotations.INSTANCE, x, y) != this.exceptOnValue) break;
                        return 0.0f;
                    }
                }
            }
            if (this.onlyOn) {
                switch (this.onlyOnObjectType) {
                    case BIOME: {
                        if (this.dimension.getLayerValueAt(Biome.INSTANCE, x, y) == this.onlyOnValue) break;
                        return 0.0f;
                    }
                    case AUTO_BIOME: {
                        if (this.dimension.getLayerValueAt(Biome.INSTANCE, x, y) == 255 && this.dimension.getAutoBiome(x, y) == this.onlyOnValue) break;
                        return 0.0f;
                    }
                    case BIT_LAYER: {
                        if (this.dimension.getBitLayerValueAt(this.onlyOnLayer, x, y)) break;
                        return 0.0f;
                    }
                    case INT_LAYER_ANY: {
                        if (this.dimension.getLayerValueAt(this.onlyOnLayer, x, y) != 0) break;
                        return 0.0f;
                    }
                    case INT_LAYER_EQUAL: {
                        if (this.dimension.getLayerValueAt(this.onlyOnLayer, x, y) != this.onlyOnValue) break;
                        return 0.0f;
                    }
                    case INT_LAYER_EQUAL_OR_HIGHER: {
                        if (this.dimension.getLayerValueAt(this.onlyOnLayer, x, y) < this.onlyOnValue) break;
                        return 0.0f;
                    }
                    case INT_LAYER_EQUAL_OR_LOWER: {
                        if (this.dimension.getLayerValueAt(this.onlyOnLayer, x, y) > this.onlyOnValue) break;
                        return 0.0f;
                    }
                    case TERRAIN: {
                        if (this.dimension.getTerrainAt(x, y) == this.onlyOnTerrain) break;
                        return 0.0f;
                    }
                    case WATER: {
                        if (this.dimension.getWaterLevelAt(x, y) > this.dimension.getIntHeightAt(x, y) && !this.dimension.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y)) break;
                        return 0.0f;
                    }
                    case LAVA: {
                        if (this.dimension.getWaterLevelAt(x, y) > this.dimension.getIntHeightAt(x, y) && this.dimension.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y)) break;
                        return 0.0f;
                    }
                    case LAND: {
                        if (this.dimension.getWaterLevelAt(x, y) <= this.dimension.getIntHeightAt(x, y)) break;
                        return 0.0f;
                    }
                    case ANNOTATION_ANY: {
                        if (this.dimension.getLayerValueAt(Annotations.INSTANCE, x, y) != 0) break;
                        return 0.0f;
                    }
                    case ANNOTATION: {
                        if (this.dimension.getLayerValueAt(Annotations.INSTANCE, x, y) == this.onlyOnValue) break;
                        return 0.0f;
                    }
                }
            }
            if (this.checkLevel) {
                int terrainLevel = this.dimension.getIntHeightAt(x, y);
                switch (this.levelType) {
                    case ABOVE: {
                        if (terrainLevel >= this.aboveLevel) break;
                        return this.feather ? Math.max((1.0f - (float)(this.aboveLevel - terrainLevel) / 4.0f) * strength, 0.0f) : 0.0f;
                    }
                    case BELOW: {
                        if (terrainLevel <= this.belowLevel) break;
                        return this.feather ? Math.max((1.0f - (float)(terrainLevel - this.belowLevel) / 4.0f) * strength, 0.0f) : 0.0f;
                    }
                    case BETWEEN: {
                        if (terrainLevel >= this.aboveLevel && terrainLevel <= this.belowLevel) break;
                        return this.feather ? Math.max(Math.min(1.0f - (float)(this.aboveLevel - terrainLevel) / 4.0f, 1.0f - (float)(terrainLevel - this.belowLevel) / 4.0f) * strength, 0.0f) : 0.0f;
                    }
                    case OUTSIDE: {
                        if (terrainLevel <= this.belowLevel || terrainLevel >= this.aboveLevel) break;
                        return this.feather ? Math.max(Math.max(1.0f - (float)(terrainLevel - this.belowLevel) / 4.0f, 1.0f - (float)(this.aboveLevel - terrainLevel) / 4.0f) * strength, 0.0f) : 0.0f;
                    }
                }
            }
            if (this.checkSlope) {
                float terrainSlope = this.dimension.getSlope(x, y);
                if (this.slopeIsAbove ? terrainSlope < this.slope : terrainSlope > this.slope) {
                    return 0.0f;
                }
            }
            return strength;
        }
        return 0.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultFilter{");
        if (this.inSelection) {
            sb.append("in selection");
        } else if (this.outsideSelection) {
            sb.append("outside selection");
        }
        if (this.onlyOn) {
            if (this.inSelection || this.outsideSelection) {
                sb.append(" and ");
            }
            sb.append("only on ");
            this.append(sb, this.onlyOnObjectType, this.onlyOnValue, this.onlyOnLayer, this.onlyOnTerrain);
        }
        if (this.exceptOn) {
            if (this.inSelection || this.outsideSelection || this.onlyOn) {
                sb.append(' ');
            }
            sb.append("except on ");
            this.append(sb, this.exceptOnObjectType, this.exceptOnValue, this.exceptOnLayer, this.exceptOnTerrain);
        }
        if (this.checkLevel) {
            if (this.inSelection || this.outsideSelection || this.onlyOn || this.exceptOn) {
                sb.append(" and ");
            }
            sb.append("height ");
            switch (this.levelType) {
                case ABOVE: {
                    sb.append("at or above ").append(this.aboveLevel);
                    break;
                }
                case BELOW: {
                    sb.append("at or below ").append(this.belowLevel);
                    break;
                }
                case BETWEEN: {
                    sb.append("between ").append(this.aboveLevel).append(" and ").append(this.belowLevel);
                    break;
                }
                case OUTSIDE: {
                    sb.append("not between ").append(this.aboveLevel).append(" and ").append(this.belowLevel);
                }
            }
        }
        if (this.checkSlope) {
            if (this.inSelection || this.outsideSelection || this.onlyOn || this.exceptOn || this.checkLevel) {
                sb.append(" and ");
            }
            sb.append("gradient ").append(this.slopeIsAbove ? "above " : "below ").append(this.slope);
        }
        sb.append('}');
        return sb.toString();
    }

    private void append(StringBuilder sb, ObjectType objectType, int value, Layer layer, Terrain terrain) {
        switch (objectType) {
            case BIOME: {
                sb.append("biome ").append(value);
                break;
            }
            case AUTO_BIOME: {
                sb.append("auto biome ").append(value);
                break;
            }
            case BIT_LAYER: 
            case INT_LAYER_ANY: {
                sb.append("layer ").append(layer.getName().toLowerCase());
                break;
            }
            case INT_LAYER_EQUAL: {
                sb.append("layer ").append(layer).append(" is ").append(value);
                break;
            }
            case INT_LAYER_EQUAL_OR_HIGHER: {
                sb.append("layer ").append(layer).append(" >= ").append(value);
                break;
            }
            case INT_LAYER_EQUAL_OR_LOWER: {
                sb.append("layer ").append(layer).append(" <= ").append(value);
                break;
            }
            case TERRAIN: {
                sb.append("terrain ").append(terrain.name().toLowerCase());
                break;
            }
            case WATER: {
                sb.append("water");
                break;
            }
            case LAVA: {
                sb.append("lava");
                break;
            }
            case LAND: {
                sb.append("land");
                break;
            }
            case ANNOTATION_ANY: {
                sb.append("annotations");
                break;
            }
            case ANNOTATION: {
                sb.append(Constants.COLOUR_NAMES[value].toLowerCase()).append(" annotations");
            }
        }
    }

    public static class Builder {
        private final Dimension dimension;
        private boolean inSelection;
        private boolean outsideSelection;
        private boolean feather;
        private boolean slopeIsAbove;
        private int aboveLevel;
        private int belowLevel;
        private int aboveDegrees;
        private Object onlyOn;
        private Object exceptOn;

        public Builder(Dimension dimension) {
            this.dimension = dimension;
        }

        public Builder inSelection() {
            this.inSelection = true;
            return this;
        }

        public Builder outsideSelection() {
            this.outsideSelection = true;
            return this;
        }

        public Builder aboveLevel(int level) {
            this.aboveLevel = level;
            return this;
        }

        public Builder belowLevel(int level) {
            this.belowLevel = level;
            return this;
        }

        public Builder betweenLevels(int aboveLevel, int belowLevel) {
            this.aboveLevel = aboveLevel;
            this.belowLevel = belowLevel;
            return this;
        }

        public Builder feather() {
            this.feather = true;
            return this;
        }

        public Builder onlyOn(Object item) {
            this.onlyOn = item;
            return this;
        }

        public Builder exceptOn(Object item) {
            this.exceptOn = item;
            return this;
        }

        public Builder slopeIsAbove(int degrees) {
            this.aboveDegrees = degrees;
            this.slopeIsAbove = true;
            return this;
        }

        public Builder slopeIsBelow(int degrees) {
            this.aboveDegrees = degrees;
            this.slopeIsAbove = false;
            return this;
        }

        public DefaultFilter build() {
            return new DefaultFilter(this.dimension, this.inSelection, this.outsideSelection, this.aboveLevel, this.belowLevel, this.feather, this.onlyOn, this.exceptOn, this.aboveDegrees, this.slopeIsAbove);
        }
    }

    public static class LayerValue {
        public final Layer layer;
        public final int value;
        public final Condition condition;

        public LayerValue(Layer layer) {
            this.layer = layer;
            this.value = -1;
            this.condition = null;
        }

        public LayerValue(Layer layer, int value) {
            this(layer, value, Condition.EQUAL);
        }

        public LayerValue(Layer layer, int value, Condition condition) {
            switch (layer.getDataSize()) {
                case BIT_PER_CHUNK: 
                case BIT: {
                    if (value >= -1 && value <= 1) break;
                    throw new IllegalArgumentException("value " + value);
                }
                case NIBBLE: {
                    if (value >= -15 && value <= 15) break;
                    throw new IllegalArgumentException("value " + value);
                }
                case BYTE: {
                    if (value >= -255 && value <= 255) break;
                    throw new IllegalArgumentException("value " + value);
                }
                default: {
                    throw new IllegalArgumentException("Data size " + (Object)((Object)layer.getDataSize()) + " not supported");
                }
            }
            this.layer = layer;
            this.value = value;
            this.condition = condition;
        }
    }

    public static enum Condition {
        EQUAL,
        LOWER_THAN_OR_EQUAL,
        HIGHER_THAN_OR_EQUAL;

    }

    public static enum ObjectType {
        TERRAIN,
        BIT_LAYER,
        INT_LAYER_ANY,
        INT_LAYER_EQUAL,
        INT_LAYER_EQUAL_OR_HIGHER,
        INT_LAYER_EQUAL_OR_LOWER,
        BIOME,
        WATER,
        LAND,
        LAVA,
        AUTO_BIOME,
        ANNOTATION_ANY,
        ANNOTATION;

    }

    public static enum LevelType {
        BETWEEN,
        OUTSIDE,
        ABOVE,
        BELOW;

    }
}

