/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.objects;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.objects.AbstractObject;
import org.pepsoft.worldpainter.objects.WPObject;

public class SkewedObject
extends AbstractObject {
    private final WPObject object;
    private final int dx;
    private final int dy;
    private final Point3i objectDimensions;
    private final Point3i dimensions;
    private final float xSkew;
    private final float ySkew;
    private final Map<String, Serializable> attributes;
    private static final long serialVersionUID = 1L;

    public SkewedObject(WPObject object, float xSkew, float ySkew) {
        this.object = object;
        this.xSkew = xSkew;
        this.ySkew = ySkew;
        this.objectDimensions = object.getDimensions();
        this.dx = (int)((float)this.objectDimensions.z * xSkew);
        this.dy = (int)((float)this.objectDimensions.z * ySkew);
        this.dimensions = new Point3i(this.objectDimensions.x + this.dx, this.objectDimensions.y + this.dy, this.objectDimensions.z);
        this.attributes = object.getAttributes() != null ? new HashMap<String, Serializable>(object.getAttributes()) : new HashMap();
    }

    @Override
    public Point3i getDimensions() {
        return this.dimensions;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        Point3i coords = this.translate(x, y, z);
        return this.object.getMaterial(coords.x, coords.y, coords.z);
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        Point3i coords = this.translate(x, y, z);
        if (coords.x < 0 || coords.x >= this.objectDimensions.x || coords.y < 0 || coords.y >= this.objectDimensions.y) {
            return false;
        }
        return this.object.getMask(coords.x, coords.y, coords.z);
    }

    @Override
    public List<Entity> getEntities() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TileEntity> getTileEntities() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.object.getName();
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        throw new UnsupportedOperationException("Not supported");
    }

    private Point3i translate(int x, int y, int z) {
        return new Point3i(x - (int)((float)z * this.xSkew) + (this.dx < 0 ? this.dx : 0), y - (int)((float)z * this.ySkew) + (this.dy < 0 ? this.dy : 0), z);
    }
}

