/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.objects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.objects.AbstractObject;
import org.pepsoft.worldpainter.objects.WPObject;

public class RotatedObject
extends AbstractObject {
    private final WPObject object;
    private final int steps;
    private final Platform platform;
    private final Point3i dimensions;
    private final Map<String, Serializable> attributes;
    private static final long serialVersionUID = 1L;

    public RotatedObject(WPObject object, int steps, Platform platform) {
        if (steps < 0 || steps > 3) {
            throw new IllegalArgumentException(Integer.toString(steps));
        }
        this.object = object;
        this.steps = steps;
        this.platform = platform;
        Point3i origDim = object.getDimensions();
        HashMap<String, Serializable> attributes = object.getAttributes() != null ? new HashMap<String, Serializable>(object.getAttributes()) : new HashMap();
        Point3i offset = object.getOffset();
        switch (steps) {
            case 0: {
                this.dimensions = origDim;
                break;
            }
            case 1: {
                this.dimensions = new Point3i(origDim.y, origDim.x, origDim.z);
                offset = new Point3i(-(origDim.y - -offset.y - 1), offset.x, offset.z);
                break;
            }
            case 2: {
                this.dimensions = origDim;
                offset = new Point3i(-(origDim.x - -offset.x - 1), -(origDim.y - -offset.y - 1), offset.z);
                break;
            }
            case 3: {
                this.dimensions = new Point3i(origDim.y, origDim.x, origDim.z);
                offset = new Point3i(offset.y, -(origDim.x - -offset.x - 1), offset.z);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (offset.x != 0 || offset.y != 0 || offset.z != 0) {
            attributes.put(RotatedObject.ATTRIBUTE_OFFSET.key, (Serializable)offset);
        } else {
            attributes.remove(RotatedObject.ATTRIBUTE_OFFSET.key);
        }
        this.attributes = !attributes.isEmpty() ? attributes : null;
    }

    @Override
    public Point3i getDimensions() {
        return this.dimensions;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        switch (this.steps) {
            case 0: {
                return this.object.getMaterial(x, y, z);
            }
            case 1: {
                return this.object.getMaterial(y, this.dimensions.x - x - 1, z).rotate(1, this.platform);
            }
            case 2: {
                return this.object.getMaterial(this.dimensions.x - x - 1, this.dimensions.y - y - 1, z).rotate(2, this.platform);
            }
            case 3: {
                return this.object.getMaterial(this.dimensions.y - y - 1, x, z).rotate(3, this.platform);
            }
        }
        throw new InternalError();
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        switch (this.steps) {
            case 0: {
                return this.object.getMask(x, y, z);
            }
            case 1: {
                return this.object.getMask(y, this.dimensions.x - x - 1, z);
            }
            case 2: {
                return this.object.getMask(this.dimensions.x - x - 1, this.dimensions.y - y - 1, z);
            }
            case 3: {
                return this.object.getMask(this.dimensions.y - y - 1, x, z);
            }
        }
        throw new InternalError();
    }

    @Override
    public List<Entity> getEntities() {
        if (this.steps == 0) {
            return this.object.getEntities();
        }
        List<Entity> objectEntities = this.object.getEntities();
        if (objectEntities != null) {
            ArrayList<Entity> entities = new ArrayList<Entity>(objectEntities.size());
            for (Entity origEntity : objectEntities) {
                Entity rotEntity = origEntity.rotate(this.steps);
                double[] origRelPos = origEntity.getRelPos();
                double[] rotRelPos = rotEntity.getRelPos();
                switch (this.steps) {
                    case 1: {
                        rotRelPos[0] = (double)this.dimensions.x - origRelPos[2];
                        rotRelPos[2] = origRelPos[0];
                        break;
                    }
                    case 2: {
                        rotRelPos[0] = (double)this.dimensions.x - origRelPos[0];
                        rotRelPos[2] = (double)this.dimensions.y - origRelPos[2];
                        break;
                    }
                    case 3: {
                        rotRelPos[0] = origRelPos[2];
                        rotRelPos[2] = (double)this.dimensions.y - origRelPos[0];
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                rotEntity.setRelPos(rotRelPos);
                entities.add(rotEntity);
            }
            return entities;
        }
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        if (this.steps == 0) {
            return this.object.getTileEntities();
        }
        List<TileEntity> objectTileEntities = this.object.getTileEntities();
        if (objectTileEntities != null) {
            ArrayList<TileEntity> tileEntities = new ArrayList<TileEntity>(objectTileEntities.size());
            for (TileEntity objectTileEntity : objectTileEntities) {
                TileEntity tileEntity = (TileEntity)objectTileEntity.clone();
                switch (this.steps) {
                    case 1: {
                        tileEntity.setX(this.dimensions.x - objectTileEntity.getZ() - 1);
                        tileEntity.setZ(objectTileEntity.getX());
                        break;
                    }
                    case 2: {
                        tileEntity.setX(this.dimensions.x - objectTileEntity.getX() - 1);
                        tileEntity.setZ(this.dimensions.y - objectTileEntity.getZ() - 1);
                        break;
                    }
                    case 3: {
                        tileEntity.setX(objectTileEntity.getZ());
                        tileEntity.setZ(this.dimensions.y - objectTileEntity.getX() - 1);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                tileEntities.add(tileEntity);
            }
            return tileEntities;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.object.getName();
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        throw new UnsupportedOperationException("Not supported");
    }
}

