/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.objects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.objects.AbstractObject;
import org.pepsoft.worldpainter.objects.WPObject;

public class MirroredObject
extends AbstractObject {
    private final WPObject object;
    private final boolean mirrorYAxis;
    private final Platform platform;
    private final Point3i dimensions;
    private final Map<String, Serializable> attributes;
    private static final long serialVersionUID = 1L;

    public MirroredObject(WPObject object, boolean mirrorYAxis, Platform platform) {
        this.object = object;
        this.mirrorYAxis = mirrorYAxis;
        this.platform = platform;
        this.dimensions = object.getDimensions();
        HashMap<String, Serializable> attributes = object.getAttributes() != null ? new HashMap<String, Serializable>(object.getAttributes()) : new HashMap();
        Point3i offset = object.getOffset();
        Point3i point3i = offset = mirrorYAxis ? new Point3i(offset.x, -(this.dimensions.y - -offset.y - 1), offset.z) : new Point3i(-(this.dimensions.x - -offset.x - 1), offset.y, offset.z);
        if (offset.x != 0 || offset.y != 0 || offset.z != 0) {
            attributes.put(MirroredObject.ATTRIBUTE_OFFSET.key, (Serializable)offset);
        } else {
            attributes.remove(MirroredObject.ATTRIBUTE_OFFSET.key);
        }
        this.attributes = !attributes.isEmpty() ? attributes : null;
    }

    @Override
    public Point3i getDimensions() {
        return this.object.getDimensions();
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.mirrorYAxis ? this.object.getMaterial(x, this.dimensions.y - y - 1, z).mirror(Direction.EAST, this.platform) : this.object.getMaterial(this.dimensions.x - x - 1, y, z).mirror(Direction.SOUTH, this.platform);
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        return this.mirrorYAxis ? this.object.getMask(x, this.dimensions.y - y - 1, z) : this.object.getMask(this.dimensions.x - x - 1, y, z);
    }

    @Override
    public List<Entity> getEntities() {
        List<Entity> objectEntities = this.object.getEntities();
        if (objectEntities != null) {
            ArrayList<Entity> entities = new ArrayList<Entity>(objectEntities.size());
            for (Entity objectEntity : objectEntities) {
                Entity entity = objectEntity.mirror(this.mirrorYAxis);
                double[] relPos = entity.getRelPos();
                if (this.mirrorYAxis) {
                    relPos[2] = (double)this.dimensions.y - relPos[2];
                } else {
                    relPos[0] = (double)this.dimensions.x - relPos[0];
                }
                entity.setRelPos(relPos);
                entities.add(entity);
            }
            return entities;
        }
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        List<TileEntity> objectTileEntities = this.object.getTileEntities();
        if (objectTileEntities != null) {
            ArrayList<TileEntity> tileEntities = new ArrayList<TileEntity>(objectTileEntities.size());
            for (TileEntity objectTileEntity : objectTileEntities) {
                TileEntity tileEntity = (TileEntity)objectTileEntity.clone();
                if (this.mirrorYAxis) {
                    tileEntity.setZ(this.dimensions.y - objectTileEntity.getZ() - 1);
                } else {
                    tileEntity.setX(this.dimensions.x - objectTileEntity.getX() - 1);
                }
                tileEntities.add(tileEntity);
            }
            return tileEntities;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.object.getName();
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        throw new UnsupportedOperationException("Not supported");
    }
}

