/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.objects;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.util.Box;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.VirtualChunk;
import org.pepsoft.worldpainter.objects.WPObject;

public final class MinecraftWorldObject
implements MinecraftWorld,
WPObject {
    private final String name;
    private final Box volume;
    private final int dx;
    private final int dy;
    private final int dz;
    private final int maxHeight;
    private final Point3i dimensions;
    private final Point3i offset;
    private final Material[][][] blocks;
    private final Material[] lowestBlocks;

    public MinecraftWorldObject(String name, Box volume, int maxHeight) {
        this(name, volume, maxHeight, null, new Point3i(0, 0, 0));
    }

    public MinecraftWorldObject(String name, Box volume, int maxHeight, Material[] lowestBlocks, Point3i offset) {
        this.name = name;
        this.volume = volume;
        this.maxHeight = maxHeight;
        this.lowestBlocks = lowestBlocks;
        this.offset = offset;
        this.dx = volume.getX1();
        this.dy = volume.getY1();
        this.dz = volume.getZ1();
        this.dimensions = new Point3i(volume.getWidth(), volume.getLength(), volume.getHeight());
        Material[][][] materialArray = this.blocks = new Material[volume.getWidth()][volume.getLength()][volume.getHeight()];
        int n = materialArray.length;
        for (int i = 0; i < n; ++i) {
            Material[][] slice;
            for (Object[] objectArray : slice = materialArray[i]) {
                Arrays.fill(objectArray, Material.AIR);
                if (lowestBlocks == null) continue;
                System.arraycopy(this.lowestBlocks, 0, objectArray, 0, this.lowestBlocks.length);
            }
        }
    }

    private MinecraftWorldObject(String name, Box volume, int maxHeight, Material[][][] blocks, Material[] lowestBlocks, Point3i offset) {
        this.name = name;
        this.volume = volume;
        this.maxHeight = maxHeight;
        this.blocks = blocks;
        this.lowestBlocks = lowestBlocks;
        this.dx = volume.getX1();
        this.dy = volume.getY1();
        this.dz = volume.getZ1();
        this.dimensions = new Point3i(volume.getWidth(), volume.getLength(), volume.getHeight());
        this.offset = offset;
    }

    public void reset() {
        Material[][][] materialArray = this.blocks;
        int n = materialArray.length;
        for (int i = 0; i < n; ++i) {
            Material[][] slice;
            for (Object[] objectArray : slice = materialArray[i]) {
                Arrays.fill(objectArray, Material.AIR);
                if (this.lowestBlocks == null) continue;
                System.arraycopy(this.lowestBlocks, 0, objectArray, 0, this.lowestBlocks.length);
            }
        }
    }

    public Box getVolume() {
        return this.volume.clone();
    }

    @Override
    public int getBlockTypeAt(int x, int y, int height) {
        if (this.volume.contains(x, y, height)) {
            return this.blocks[x - this.dx][y - this.dy][height - this.dz].blockType;
        }
        return 0;
    }

    @Override
    public int getDataAt(int x, int y, int height) {
        if (this.volume.contains(x, y, height)) {
            return this.blocks[x - this.dx][y - this.dy][height - this.dz].data;
        }
        return 0;
    }

    @Override
    public Material getMaterialAt(int x, int y, int height) {
        if (this.volume.contains(x, y, height)) {
            return this.blocks[x - this.dx][y - this.dy][height - this.dz];
        }
        return Material.AIR;
    }

    @Override
    public void setBlockTypeAt(int x, int y, int height, int blockType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAt(int x, int y, int height, int data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaterialAt(int x, int y, int height, Material material) {
        if (this.volume.contains(x, y, height)) {
            this.blocks[x - this.dx][y - this.dy][height - this.dz] = material;
        }
    }

    @Override
    public void markForUpdateWorld(int x, int y, int height) {
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void addEntity(double x, double y, double height, Entity entity) {
    }

    @Override
    public void addTileEntity(int x, int y, int height, TileEntity tileEntity) {
    }

    @Override
    public int getBlockLightLevel(int x, int y, int height) {
        return 0;
    }

    @Override
    public void setBlockLightLevel(int x, int y, int height, int blockLightLevel) {
    }

    @Override
    public int getSkyLightLevel(int x, int y, int height) {
        return 15;
    }

    @Override
    public void setSkyLightLevel(int x, int y, int height, int skyLightLevel) {
    }

    @Override
    public boolean isChunkPresent(int x, int y) {
        return this.volume.containsXY(x << 4, y << 4);
    }

    @Override
    public void addChunk(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockY;
                int blockX = chunk.getxPos() << 4 | x;
                if (!this.volume.containsXY(blockX, blockY = chunk.getzPos() << 4 | z)) continue;
                for (int y = Math.min(chunk.getHighestNonAirBlock(x, z), this.dz + this.volume.getHeight() - 1); y >= this.dz; --y) {
                    this.blocks[blockX - this.dx][blockY - this.dy][y - this.dz] = chunk.getMaterial(x, y, z);
                }
            }
        }
    }

    @Override
    public int getHighestNonAirBlock(int x, int y) {
        if (this.volume.containsXY(x, y)) {
            for (int z = this.volume.getHeight() - 1; z >= 0; --z) {
                if (this.blocks[x - this.dx][y - this.dy][z] == null) continue;
                return z + this.dz;
            }
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Chunk getChunk(int x, int z) {
        return new VirtualChunk(this, x, z);
    }

    @Override
    public Chunk getChunkForEditing(int x, int z) {
        return this.getChunk(x, z);
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Point3i getDimensions() {
        return this.dimensions;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.blocks[x][y][z];
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        return this.blocks[x][y][z] != null;
    }

    @Override
    public List<Entity> getEntities() {
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return null;
    }

    @Override
    public void prepareForExport(Dimension dimension) {
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return null;
    }

    @Override
    public <T extends Serializable> T getAttribute(AttributeKey<T> key) {
        if (key.equals((Object)ATTRIBUTE_OFFSET)) {
            return (T)this.offset;
        }
        return (T)((Serializable)key.defaultValue);
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Point3i getOffset() {
        return (Point3i)this.getAttribute(ATTRIBUTE_OFFSET);
    }

    @Override
    public MinecraftWorldObject clone() {
        return new MinecraftWorldObject(this.name, this.volume.clone(), this.maxHeight, (Material[][][])this.blocks.clone(), (Material[])this.lowestBlocks.clone(), (Point3i)this.offset.clone());
    }
}

