/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import org.pepsoft.util.ColourUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.layers.renderers.DimensionAwareRenderer;
import org.pepsoft.worldpainter.layers.renderers.TransparentColourRenderer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;

public class TunnelLayerRenderer
extends TransparentColourRenderer
implements DimensionAwareRenderer {
    private final TunnelLayer layer;
    private final TunnelLayer.Mode floorMode;
    private final TunnelLayer.Mode roofMode;
    private final int floorLevel;
    private final int roofLevel;
    private Dimension dimension;
    private Dimension floorDimension;

    public TunnelLayerRenderer(TunnelLayer layer) {
        super(layer.getColour());
        this.layer = layer;
        this.floorMode = layer.floorMode;
        this.floorLevel = layer.floorLevel;
        this.roofMode = layer.roofMode;
        this.roofLevel = layer.roofLevel;
    }

    @Override
    public int getPixelColour(int x, int y, int underlyingColour, boolean value) {
        if (!value) {
            return underlyingColour;
        }
        if (this.dimension != null) {
            switch (this.getEffect(x, y)) {
                case BREAKS_SURFACE: {
                    return this.layer.getColour();
                }
                case NONE: {
                    return ColourUtils.mix((int)this.layer.getColour(), (int)underlyingColour, (int)64);
                }
                case UNDERGROUND: {
                    return ColourUtils.mix((int)this.layer.getColour(), (int)underlyingColour, (int)160);
                }
            }
            throw new InternalError();
        }
        return super.getPixelColour(x, y, underlyingColour, true);
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
        if (this.layer.getFloorDimensionId() != null) {
            Dimension.Anchor anchor = dimension.getAnchor();
            this.floorDimension = dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.CAVE_FLOOR, anchor.invert, this.layer.getFloorDimensionId()));
        } else {
            this.floorDimension = null;
        }
    }

    private Effect getEffect(int x, int y) {
        int roofLevel;
        int floorLevel;
        int terrainHeight = this.dimension.getIntHeightAt(x, y);
        switch (this.floorMode) {
            case CONSTANT_DEPTH: {
                floorLevel = terrainHeight - this.floorLevel;
                break;
            }
            case FIXED_HEIGHT: {
                floorLevel = this.floorLevel;
                break;
            }
            case INVERTED_DEPTH: {
                floorLevel = this.floorLevel - (terrainHeight - this.floorLevel);
                break;
            }
            case CUSTOM_DIMENSION: {
                floorLevel = this.floorDimension != null ? this.floorDimension.getIntHeightAt(x, y) : this.floorLevel;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (floorLevel >= terrainHeight) {
            return Effect.NONE;
        }
        switch (this.roofMode) {
            case CONSTANT_DEPTH: {
                roofLevel = terrainHeight - this.roofLevel;
                break;
            }
            case FIXED_HEIGHT: {
                roofLevel = this.roofLevel;
                break;
            }
            case INVERTED_DEPTH: {
                roofLevel = this.roofLevel - (terrainHeight - this.roofLevel);
                break;
            }
            case FIXED_HEIGHT_ABOVE_FLOOR: {
                roofLevel = floorLevel + this.roofLevel;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (floorLevel >= roofLevel) {
            return Effect.NONE;
        }
        if (terrainHeight <= roofLevel) {
            return Effect.BREAKS_SURFACE;
        }
        return Effect.UNDERGROUND;
    }

    static enum Effect {
        NONE,
        BREAKS_SURFACE,
        UNDERGROUND;

    }
}

