/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;

public class TunnelLayerHelper {
    private final TunnelLayer layer;
    private final Dimension floorDimension;
    private final NoiseHeightMap floorNoise;
    private final NoiseHeightMap roofNoise;
    private final int floorNoiseOffset;
    private final int roofNoiseOffset;
    private final HeightMap wallDistanceCache;
    private static final long FLOOR_NOISE_SEED_OFFSET = 177766561L;
    private static final long ROOF_NOISE_SEED_OFFSET = 184818453L;

    public TunnelLayerHelper(TunnelLayer layer, Dimension dimension) {
        this.layer = layer;
        Dimension dimension2 = this.floorDimension = layer.floorMode == TunnelLayer.Mode.CUSTOM_DIMENSION && layer.floorDimensionId != null && dimension != null ? dimension.getWorld().getDimension(new Dimension.Anchor(dimension.getAnchor().dim, Dimension.Role.CAVE_FLOOR, dimension.getAnchor().invert, layer.floorDimensionId)) : null;
        if (layer.floorNoise != null) {
            this.floorNoise = new NoiseHeightMap(layer.floorNoise, 177766561L);
            if (dimension != null) {
                this.floorNoise.setSeed(dimension.getSeed());
            }
            this.floorNoiseOffset = layer.floorNoise.getRange();
        } else {
            this.floorNoise = null;
            this.floorNoiseOffset = 0;
        }
        if (layer.roofNoise != null) {
            this.roofNoise = new NoiseHeightMap(layer.roofNoise, 184818453L);
            if (dimension != null) {
                this.roofNoise.setSeed(dimension.getSeed());
            }
            this.roofNoiseOffset = layer.roofNoise.getRange();
        } else {
            this.roofNoise = null;
            this.roofNoiseOffset = 0;
        }
        if (dimension != null) {
            int maxWallDepth = Math.max(layer.floorWallDepth, layer.roofWallDepth);
            this.wallDistanceCache = dimension.getDistancesToEdge(layer, maxWallDepth);
        } else {
            this.wallDistanceCache = null;
        }
    }

    public int calculateRoofLevel(int x, int y, int terrainHeight, int minZ, int maxZ, int floorLevel) {
        switch (this.layer.roofMode) {
            case CONSTANT_DEPTH: {
                return MathUtils.clamp((int)minZ, (int)(MathUtils.clamp((int)this.layer.roofMin, (int)(terrainHeight - this.layer.roofLevel), (int)this.layer.roofMax) + (this.roofNoise != null ? (int)this.roofNoise.getHeight(x, y) - this.roofNoiseOffset : 0)), (int)maxZ);
            }
            case FIXED_HEIGHT: {
                return MathUtils.clamp((int)minZ, (int)(this.layer.roofLevel + (this.roofNoise != null ? (int)this.roofNoise.getHeight(x, y) - this.roofNoiseOffset : 0)), (int)maxZ);
            }
            case INVERTED_DEPTH: {
                return MathUtils.clamp((int)minZ, (int)(MathUtils.clamp((int)this.layer.roofMin, (int)(this.layer.roofLevel - (terrainHeight - this.layer.roofLevel)), (int)this.layer.roofMax) + (this.roofNoise != null ? (int)this.roofNoise.getHeight(x, y) - this.roofNoiseOffset : 0)), (int)maxZ);
            }
            case FIXED_HEIGHT_ABOVE_FLOOR: {
                return MathUtils.clamp((int)minZ, (int)(MathUtils.clamp((int)this.layer.roofMin, (int)(floorLevel + this.layer.roofLevel), (int)this.layer.roofMax) + (this.roofNoise != null ? (int)this.roofNoise.getHeight(x, y) - this.roofNoiseOffset : 0)), (int)maxZ);
            }
        }
        throw new InternalError("layer.roofMode " + (Object)((Object)this.layer.roofMode));
    }

    public int calculateFloorLevel(int x, int y, int terrainHeight, int minZ, int maxZ) {
        switch (this.layer.floorMode) {
            case CONSTANT_DEPTH: {
                return MathUtils.clamp((int)minZ, (int)(MathUtils.clamp((int)this.layer.floorMin, (int)(terrainHeight - this.layer.floorLevel), (int)this.layer.floorMax) + (this.floorNoise != null ? (int)this.floorNoise.getHeight(x, y) - this.floorNoiseOffset : 0)), (int)maxZ);
            }
            case FIXED_HEIGHT: {
                return MathUtils.clamp((int)minZ, (int)(this.layer.floorLevel + (this.floorNoise != null ? (int)this.floorNoise.getHeight(x, y) - this.floorNoiseOffset : 0)), (int)maxZ);
            }
            case INVERTED_DEPTH: {
                return MathUtils.clamp((int)minZ, (int)(MathUtils.clamp((int)this.layer.floorMin, (int)(this.layer.floorLevel - (terrainHeight - this.layer.floorLevel)), (int)this.layer.floorMax) + (this.floorNoise != null ? (int)this.floorNoise.getHeight(x, y) - this.floorNoiseOffset : 0)), (int)maxZ);
            }
            case CUSTOM_DIMENSION: {
                return MathUtils.clamp((int)minZ, (int)(this.floorDimension != null ? this.floorDimension.getIntHeightAt(x, y) : 32), (int)maxZ);
            }
        }
        throw new InternalError("layer.floorMode " + (Object)((Object)this.layer.floorMode));
    }

    public int calculateTopLedgeHeight(int x, int y) {
        return this.calculateTopLedgeHeight((float)this.wallDistanceCache.getHeight(x, y) - 1.0f);
    }

    public int calculateTopLedgeHeight(float distanceToWall) {
        if (distanceToWall > (float)this.layer.roofWallDepth) {
            return 0;
        }
        float a = (float)this.layer.roofWallDepth - distanceToWall;
        return (int)Math.round((double)this.layer.roofWallDepth - Math.sqrt((float)(this.layer.roofWallDepth * this.layer.roofWallDepth) - a * a));
    }

    public int calculateBottomLedgeHeight(int x, int y) {
        return this.calculateBottomLedgeHeight((float)this.wallDistanceCache.getHeight(x, y) - 1.0f);
    }

    public int calculateBottomLedgeHeight(float distanceToWall) {
        if (distanceToWall > (float)this.layer.floorWallDepth) {
            return 0;
        }
        float a = (float)this.layer.floorWallDepth - distanceToWall;
        return (int)Math.round((double)this.layer.floorWallDepth - Math.sqrt((float)(this.layer.floorWallDepth * this.layer.floorWallDepth) - a * a));
    }
}

