/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.Caverns;
import org.pepsoft.worldpainter.layers.Caves;
import org.pepsoft.worldpainter.layers.Chasms;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresentBlock;
import org.pepsoft.worldpainter.layers.Populate;
import org.pepsoft.worldpainter.layers.ReadOnly;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerExporter;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerHelper;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerRenderer;
import org.pepsoft.worldpainter.operations.Filter;

public class TunnelLayer
extends CustomLayer {
    Mode roofMode = Mode.FIXED_HEIGHT_ABOVE_FLOOR;
    Mode floorMode = Mode.FIXED_HEIGHT;
    int roofLevel = 16;
    int floorLevel = 32;
    int floorWallDepth = 4;
    int roofWallDepth = 4;
    int roofMin = Integer.MIN_VALUE;
    int roofMax = Integer.MAX_VALUE;
    int floorMin = Integer.MIN_VALUE;
    int floorMax = Integer.MAX_VALUE;
    int floodLevel = Integer.MIN_VALUE;
    private boolean stalactites;
    private boolean stalagmites;
    private boolean floodWithLava;
    private boolean removeWater;
    private MixedMaterial floorMaterial;
    private MixedMaterial wallMaterial;
    private MixedMaterial roofMaterial;
    NoiseSettings floorNoise;
    NoiseSettings roofNoise;
    NoiseSettings wallNoise;
    @Deprecated
    private Map<Layer, LayerSettings> floorLayers;
    private Integer tunnelBiome;
    private int wpVersion = 2;
    private List<LayerSettings> orderedFloorLayers;
    private List<LayerSettings> orderedRoofLayers;
    Integer floorDimensionId;
    private static final int CURRENT_WP_VERSION = 2;
    private static final long serialVersionUID = 1L;

    public TunnelLayer(String name, int colour) {
        super(name, name, Layer.DataSize.BIT, 22, colour);
    }

    public Mode getRoofMode() {
        return this.roofMode;
    }

    public void setRoofMode(Mode roofMode) {
        this.roofMode = roofMode;
    }

    public Mode getFloorMode() {
        return this.floorMode;
    }

    public void setFloorMode(Mode floorMode) {
        this.floorMode = floorMode;
    }

    public int getRoofLevel() {
        return this.roofLevel;
    }

    public void setRoofLevel(int roofLevel) {
        this.roofLevel = roofLevel;
    }

    public int getFloorLevel() {
        return this.floorLevel;
    }

    public void setFloorLevel(int floorLevel) {
        this.floorLevel = floorLevel;
    }

    public int getFloorWallDepth() {
        return this.floorWallDepth;
    }

    public void setFloorWallDepth(int floorWallDepth) {
        this.floorWallDepth = floorWallDepth;
    }

    public int getRoofWallDepth() {
        return this.roofWallDepth;
    }

    public void setRoofWallDepth(int roofWallDepth) {
        this.roofWallDepth = roofWallDepth;
    }

    public boolean isStalactites() {
        return this.stalactites;
    }

    public void setStalactites(boolean stalactites) {
        this.stalactites = stalactites;
    }

    public boolean isStalagmites() {
        return this.stalagmites;
    }

    public void setStalagmites(boolean stalagmites) {
        this.stalagmites = stalagmites;
    }

    public MixedMaterial getFloorMaterial() {
        return this.floorMaterial;
    }

    public void setFloorMaterial(MixedMaterial floorMaterial) {
        this.floorMaterial = floorMaterial;
    }

    public MixedMaterial getWallMaterial() {
        return this.wallMaterial;
    }

    public void setWallMaterial(MixedMaterial wallMaterial) {
        this.wallMaterial = wallMaterial;
    }

    public MixedMaterial getRoofMaterial() {
        return this.roofMaterial;
    }

    public void setRoofMaterial(MixedMaterial roofMaterial) {
        this.roofMaterial = roofMaterial;
    }

    public NoiseSettings getFloorNoise() {
        return this.floorNoise;
    }

    public void setFloorNoise(NoiseSettings floorNoise) {
        this.floorNoise = floorNoise;
    }

    public NoiseSettings getRoofNoise() {
        return this.roofNoise;
    }

    public void setRoofNoise(NoiseSettings roofNoise) {
        this.roofNoise = roofNoise;
    }

    public NoiseSettings getWallNoise() {
        return this.wallNoise;
    }

    public void setWallNoise(NoiseSettings wallNoise) {
        this.wallNoise = wallNoise;
    }

    public int getRoofMin() {
        return this.roofMin;
    }

    public void setRoofMin(int roofMin) {
        this.roofMin = roofMin;
    }

    public int getRoofMax() {
        return this.roofMax;
    }

    public void setRoofMax(int roofMax) {
        this.roofMax = roofMax;
    }

    public int getFloorMin() {
        return this.floorMin;
    }

    public void setFloorMin(int floorMin) {
        this.floorMin = floorMin;
    }

    public int getFloorMax() {
        return this.floorMax;
    }

    public void setFloorMax(int floorMax) {
        this.floorMax = floorMax;
    }

    public boolean isRemoveWater() {
        return this.removeWater;
    }

    public void setRemoveWater(boolean removeWater) {
        this.removeWater = removeWater;
    }

    @Override
    public void setMinMaxHeight(int oldMinHeight, int newMinHeight, int oldMaxHeight, int newMaxHeight, HeightTransform transform) {
        this.adjustLayers(this.orderedFloorLayers, oldMinHeight, newMinHeight, oldMaxHeight, newMaxHeight);
        this.adjustLayers(this.orderedRoofLayers, oldMinHeight, newMinHeight, oldMaxHeight, newMaxHeight);
    }

    @Override
    public String getType() {
        return "Cave/Tunnel";
    }

    public int getFloodLevel() {
        return this.floodLevel;
    }

    public void setFloodLevel(int floodLevel) {
        this.floodLevel = floodLevel;
    }

    public boolean isFloodWithLava() {
        return this.floodWithLava;
    }

    public void setFloodWithLava(boolean floodWithLava) {
        this.floodWithLava = floodWithLava;
    }

    public List<LayerSettings> getFloorLayers() {
        return this.orderedFloorLayers;
    }

    public void setFloorLayers(List<LayerSettings> floorLayers) {
        this.orderedFloorLayers = floorLayers;
    }

    public List<LayerSettings> getRoofLayers() {
        return this.orderedRoofLayers;
    }

    public void setRoofLayers(List<LayerSettings> roofLayers) {
        this.orderedRoofLayers = roofLayers;
    }

    public Integer getTunnelBiome() {
        return this.tunnelBiome;
    }

    public void setTunnelBiome(Integer biome) {
        this.tunnelBiome = biome;
    }

    public Integer getFloorDimensionId() {
        return this.floorDimensionId;
    }

    public void setFloorDimensionId(Integer floorDimensionId) {
        this.floorDimensionId = floorDimensionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension updateFloorDimension(Dimension dimension, String name) {
        Dimension.Anchor anchor = dimension.getAnchor();
        Dimension floorDimension = dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.CAVE_FLOOR, anchor.invert, this.floorDimensionId));
        if (name != null) {
            floorDimension.setName(name);
        }
        TileFactory tileFactory = floorDimension.getTileFactory();
        floorDimension.setEventsInhibited(true);
        try {
            dimension.visitTiles().forFilter(Filter.build(dimension).onlyOn(this).build()).andDo(tile -> {
                Tile floorTile = floorDimension.getTileForEditing(tile.getX(), tile.getY());
                if (floorTile == null) {
                    floorTile = tileFactory.createTile(tile.getX(), tile.getY());
                    floorDimension.addTile(floorTile);
                } else {
                    floorTile.clearLayerData(NotPresentBlock.INSTANCE);
                }
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        if (tile.getBitLayerValue(this, x, y)) continue;
                        floorTile.setBitLayerValue(NotPresentBlock.INSTANCE, x, y, true);
                    }
                }
            });
        }
        finally {
            floorDimension.setEventsInhibited(false);
        }
        return floorDimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloorDimensionTiles(Dimension dimension) {
        Dimension.Anchor anchor = dimension.getAnchor();
        Dimension floorDimension = dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.CAVE_FLOOR, anchor.invert, this.floorDimensionId));
        TileFactory tileFactory = floorDimension.getTileFactory();
        floorDimension.setEventsInhibited(true);
        try {
            dimension.visitTiles().forFilter(Filter.build(dimension).onlyOn(this).build()).andDo(tile -> {
                Tile floorTile = floorDimension.getTileForEditing(tile.getX(), tile.getY());
                if (floorTile == null) {
                    floorTile = tileFactory.createTile(tile.getX(), tile.getY());
                    floorDimension.addTile(floorTile);
                }
            });
        }
        finally {
            floorDimension.setEventsInhibited(false);
        }
    }

    public TunnelLayerHelper getHelper(Dimension dimension) {
        return new TunnelLayerHelper(this, dimension);
    }

    public static TunnelLayer find(Dimension floorDimension) {
        Dimension.Anchor floorAnchor = floorDimension.getAnchor();
        if (floorAnchor.role != Dimension.Role.CAVE_FLOOR) {
            throw new IllegalArgumentException("Not a CAVE_FLOOR dimension");
        }
        Dimension.Anchor detailAnchor = new Dimension.Anchor(floorAnchor.dim, Dimension.Role.DETAIL, floorAnchor.invert, 0);
        Dimension detailDimension = floorDimension.getWorld().getDimension(detailAnchor);
        if (detailDimension != null) {
            for (CustomLayer layer : detailDimension.getCustomLayers()) {
                if (!(layer instanceof TunnelLayer) || ((TunnelLayer)layer).getFloorDimensionId() == null || ((TunnelLayer)layer).getFloorDimensionId() != floorAnchor.id) continue;
                return (TunnelLayer)layer;
            }
            throw new IllegalArgumentException("Could not find TunnelLayer for floor dimension " + floorAnchor);
        }
        throw new IllegalArgumentException("Could not find detail dimension for floor dimension " + floorAnchor);
    }

    public static boolean isLayerTypeSupportedForFloorDimension(Class<? extends Layer> layerType) {
        return !Caves.class.isAssignableFrom(layerType) && !Caverns.class.isAssignableFrom(layerType) && !Chasms.class.isAssignableFrom(layerType) && !Resources.class.isAssignableFrom(layerType) && !Populate.class.isAssignableFrom(layerType) && !ReadOnly.class.isAssignableFrom(layerType) && !TunnelLayer.class.isAssignableFrom(layerType) && !UndergroundPocketsLayer.class.isAssignableFrom(layerType);
    }

    public static boolean isLayerSupportedForFloorDimension(Layer layer) {
        if (!TunnelLayer.isLayerTypeSupportedForFloorDimension(layer.getClass())) {
            return false;
        }
        if (layer instanceof CombinedLayer) {
            for (Layer constituentLayer : ((CombinedLayer)layer).getLayers()) {
                if (TunnelLayer.isLayerSupportedForFloorDimension(constituentLayer)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Class<? extends LayerExporter> getExporterType() {
        return TunnelLayerExporter.class;
    }

    @Override
    public TunnelLayerExporter getExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        return new TunnelLayerExporter(dimension, platform, this, this.getHelper(dimension));
    }

    @Override
    public TunnelLayerRenderer getRenderer() {
        return new TunnelLayerRenderer(this);
    }

    @Override
    public boolean isExportable() {
        return this.floorMode != Mode.CUSTOM_DIMENSION;
    }

    @Override
    public TunnelLayer clone() {
        if (this.floorMode == Mode.CUSTOM_DIMENSION) {
            throw new MDCCapturingRuntimeException("TunnelLayers with a floor dimension are not Cloneable");
        }
        TunnelLayer clone = (TunnelLayer)super.clone();
        MixedMaterialManager mixedMaterialManager = MixedMaterialManager.getInstance();
        if (this.floorMaterial != null) {
            clone.floorMaterial = this.floorMaterial.clone();
            mixedMaterialManager.register(clone.floorMaterial);
        }
        if (this.wallMaterial != null) {
            clone.wallMaterial = this.wallMaterial.clone();
            mixedMaterialManager.register(clone.wallMaterial);
        }
        if (this.roofMaterial != null) {
            clone.roofMaterial = this.roofMaterial.clone();
            mixedMaterialManager.register(clone.roofMaterial);
        }
        if (this.floorNoise != null) {
            clone.floorNoise = this.floorNoise.clone();
        }
        if (this.roofNoise != null) {
            clone.roofNoise = this.roofNoise.clone();
        }
        if (this.wallNoise != null) {
            clone.wallNoise = this.wallNoise.clone();
        }
        if (this.orderedFloorLayers != null) {
            clone.orderedFloorLayers = new ArrayList<LayerSettings>(this.orderedFloorLayers.size());
            for (LayerSettings layerSettings : this.orderedFloorLayers) {
                clone.orderedFloorLayers.add(layerSettings.clone());
            }
        }
        if (this.orderedRoofLayers != null) {
            clone.orderedRoofLayers = new ArrayList<LayerSettings>(this.orderedRoofLayers.size());
            for (LayerSettings layerSettings : this.orderedRoofLayers) {
                clone.orderedRoofLayers.add(layerSettings.clone());
            }
        }
        return clone;
    }

    private void adjustLayers(List<LayerSettings> layers, int oldMinHeight, int newMinHeight, int oldMaxHeight, int newMaxHeight) {
        if (layers != null) {
            layers.forEach(layerSettings -> {
                if (layerSettings.getMinLevel() == oldMinHeight || layerSettings.getMinLevel() < newMinHeight) {
                    layerSettings.setMinLevel(newMinHeight);
                }
                if (layerSettings.getMaxLevel() == oldMaxHeight - 1 || layerSettings.getMaxLevel() >= newMaxHeight) {
                    layerSettings.setMaxLevel(newMaxHeight - 1);
                }
            });
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.wpVersion < 1) {
            if (this.roofMin == 0) {
                this.roofMin = Integer.MIN_VALUE;
            }
            if (this.floorMin == 0) {
                this.floorMin = Integer.MIN_VALUE;
            }
            if (this.floodLevel == 0) {
                this.floodLevel = Integer.MIN_VALUE;
            }
        }
        if (this.wpVersion < 2 && this.floorLayers != null) {
            this.orderedFloorLayers = new ArrayList<LayerSettings>(this.floorLayers.size());
            for (Map.Entry<Layer, LayerSettings> entry : this.floorLayers.entrySet()) {
                entry.getValue().setLayer(entry.getKey());
                this.orderedFloorLayers.add(entry.getValue());
            }
            this.floorLayers = null;
        }
        this.wpVersion = 2;
    }

    public static class LayerSettings
    implements Serializable,
    Cloneable {
        private int intensity = 50;
        private NoiseSettings variation;
        private int minLevel;
        private int maxLevel;
        private boolean invert;
        private Layer layer;
        private static final long serialVersionUID = 1L;

        public LayerSettings(int minLevel, int maxLevel) {
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public void setLayer(Layer layer) {
            this.layer = layer;
        }

        public int getIntensity() {
            return this.intensity;
        }

        public void setIntensity(int intensity) {
            this.intensity = intensity;
        }

        public NoiseSettings getVariation() {
            return this.variation;
        }

        public void setVariation(NoiseSettings variation) {
            this.variation = variation;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public void setMinLevel(int minLevel) {
            this.minLevel = minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public void setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public boolean isInvert() {
            return this.invert;
        }

        public void setInvert(boolean invert) {
            this.invert = invert;
        }

        public LayerSettings clone() {
            try {
                LayerSettings clone = (LayerSettings)super.clone();
                if (this.layer instanceof CustomLayer) {
                    clone.layer = ((CustomLayer)this.layer).clone();
                }
                if (this.variation != null) {
                    clone.variation = this.variation.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }

    public static enum Mode {
        FIXED_HEIGHT,
        CONSTANT_DEPTH,
        INVERTED_DEPTH,
        CUSTOM_DIMENSION,
        FIXED_HEIGHT_ABOVE_FLOOR;

    }
}

