/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import java.awt.Point;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.RODelegatingDimension;
import org.pepsoft.worldpainter.RODelegatingTile;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerHelper;

abstract class TunnelDimension
extends RODelegatingDimension<TunnelTile> {
    private final TunnelLayer layer;
    private final int minZ;
    private final int maxZ;
    private final TunnelLayerHelper helper;

    TunnelDimension(Dimension dimension, TunnelLayer layer, TunnelLayerHelper helper) {
        super(dimension);
        this.layer = layer;
        this.helper = helper;
        this.minZ = dimension.getMinHeight() + (dimension.isBottomless() ? 0 : 1);
        this.maxZ = dimension.getMaxHeight() - 1;
    }

    @Override
    public float getHeightAt(int x, int y) {
        float terrainHeight = this.dimension.getHeightAt(x, y);
        if (this.dimension.getBitLayerValueAt(this.layer, x, y)) {
            int actualFloorLevel;
            int intTerrainHeight = Math.round(terrainHeight);
            int actualRoofLevel = this.helper.calculateRoofLevel(x, y, intTerrainHeight, this.minZ, this.maxZ, actualFloorLevel = this.helper.calculateFloorLevel(x, y, intTerrainHeight, this.minZ, this.maxZ));
            if (actualRoofLevel <= actualFloorLevel) {
                return this.determineHeight(true, actualFloorLevel, actualRoofLevel, terrainHeight);
            }
            int floorLedgeHeight = this.helper.calculateBottomLedgeHeight(x, y);
            int roofLedgeHeight = this.helper.calculateTopLedgeHeight(x, y);
            return this.determineHeight(true, actualFloorLevel += floorLedgeHeight, actualRoofLevel -= roofLedgeHeight, terrainHeight);
        }
        return this.determineHeight(false, Integer.MAX_VALUE, Integer.MIN_VALUE, terrainHeight);
    }

    @Override
    public float getHeightAt(Point coords) {
        return this.getHeightAt(coords.x, coords.y);
    }

    @Override
    public int getWaterLevelAt(int x, int y) {
        float terrainHeight = this.dimension.getHeightAt(x, y);
        if (this.dimension.getBitLayerValueAt(this.layer, x, y)) {
            int actualFloorLevel;
            int intTerrainHeight = Math.round(terrainHeight);
            int actualRoofLevel = this.helper.calculateRoofLevel(x, y, intTerrainHeight, this.minZ, this.maxZ, actualFloorLevel = this.helper.calculateFloorLevel(x, y, intTerrainHeight, this.minZ, this.maxZ));
            if (actualRoofLevel <= actualFloorLevel) {
                return this.dimension.getWaterLevelAt(x, y);
            }
            int floorLedgeHeight = this.helper.calculateBottomLedgeHeight(x, y);
            int roofLedgeHeight = this.helper.calculateTopLedgeHeight(x, y);
            if ((actualRoofLevel -= roofLedgeHeight) <= (actualFloorLevel += floorLedgeHeight)) {
                return this.dimension.getWaterLevelAt(x, y);
            }
            int floodLevel = this.layer.getFloodLevel();
            return floodLevel == Integer.MIN_VALUE ? this.getMinHeight() : floodLevel;
        }
        return this.dimension.getWaterLevelAt(x, y);
    }

    @Override
    public int getWaterLevelAt(Point coords) {
        return this.getWaterLevelAt(coords.x, coords.y);
    }

    @Override
    public int getIntHeightAt(int x, int y) {
        return Math.round(this.getHeightAt(x, y));
    }

    @Override
    public int getIntHeightAt(int x, int y, int defaultValue) {
        float height = this.getHeightAt(x, y);
        return height == -3.4028235E38f ? defaultValue : Math.round(height);
    }

    @Override
    public int getIntHeightAt(Point coords) {
        return this.getIntHeightAt(coords.x, coords.y);
    }

    @Override
    protected TunnelTile wrapTile(Tile tile) {
        return new TunnelTile(tile);
    }

    protected abstract float determineHeight(boolean var1, int var2, int var3, float var4);

    final class TunnelTile
    extends RODelegatingTile {
        TunnelTile(Tile tile) {
            super(tile);
        }

        @Override
        public float getHeight(int x, int y) {
            float terrainHeight = this.tile.getHeight(x, y);
            if (this.tile.getBitLayerValue(TunnelDimension.this.layer, x, y)) {
                int intTerrainHeight = Math.round(terrainHeight);
                int worldX = this.tile.getX() << 7 | x;
                int worldY = this.tile.getY() << 7 | y;
                int actualFloorLevel = TunnelDimension.this.helper.calculateFloorLevel(worldX, worldY, intTerrainHeight, TunnelDimension.this.minZ, TunnelDimension.this.maxZ);
                int actualRoofLevel = TunnelDimension.this.helper.calculateRoofLevel(worldX, worldY, intTerrainHeight, TunnelDimension.this.minZ, TunnelDimension.this.maxZ, actualFloorLevel);
                if (actualRoofLevel <= actualFloorLevel) {
                    return TunnelDimension.this.determineHeight(true, actualFloorLevel, actualRoofLevel, terrainHeight);
                }
                int floorLedgeHeight = TunnelDimension.this.helper.calculateBottomLedgeHeight(worldX, worldY);
                int roofLedgeHeight = TunnelDimension.this.helper.calculateTopLedgeHeight(worldX, worldY);
                return TunnelDimension.this.determineHeight(true, actualFloorLevel += floorLedgeHeight, actualRoofLevel -= roofLedgeHeight, terrainHeight);
            }
            return TunnelDimension.this.determineHeight(false, Integer.MAX_VALUE, Integer.MIN_VALUE, terrainHeight);
        }

        @Override
        public int getIntHeight(int x, int y) {
            return Math.round(this.getHeight(x, y));
        }
    }
}

