/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.trees;

import java.io.Serializable;
import java.util.Random;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.exporting.Cursor;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;

public abstract class TreeType
implements Serializable {
    protected final Material trunkMaterial;
    protected final Material leafMaterial;
    private static final int VINE_INCIDENCE = 5;
    private static final long serialVersionUID = 1L;

    protected TreeType(Material trunkMaterial, Material leafMaterial) {
        this.trunkMaterial = trunkMaterial;
        this.leafMaterial = leafMaterial;
    }

    public abstract void renderTree(int var1, int var2, int var3, int var4, MinecraftWorld var5, Dimension var6, Random var7);

    protected void renderTrunk(int blockInWorldX, int blockInWorldY, int height, int size, MinecraftWorld minecraftWorld) {
        for (int i = 1; i < size; ++i) {
            minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY, height + i, this.trunkMaterial);
        }
        minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY, height + size, this.getCapMaterial());
    }

    protected final Material getCapMaterial() {
        if (this.trunkMaterial.name.endsWith("_log")) {
            String woodType = this.trunkMaterial.name.substring(0, this.trunkMaterial.name.length() - 4);
            return Material.get(woodType + "_wood", "axis", "y");
        }
        return this.trunkMaterial;
    }

    protected void maybePlaceLeaves(int x, int y, int h, int r, float distance, MinecraftWorld minecraftWorld, Random random) {
        if (minecraftWorld.getMaterialAt(x, y, h) == Material.AIR) {
            int n = r > 0 ? random.nextInt(r) : 0;
            if ((float)n + 1.5f >= distance) {
                minecraftWorld.setMaterialAt(x, y, h, this.leafMaterial);
            }
        }
    }

    protected void renderVines(int x, int y, int z, int size, MinecraftWorld world, Random random) {
        this.renderVines(x, y, z, size, world, random, 5, 3, 4);
    }

    protected void renderVines(int x, int y, int z, int size, MinecraftWorld world, Random random, int vineIncidence, int vineLengthBase, int vineLengthVariation) {
        int r = Math.max(1, Math.min(size / 2 + 1, 4));
        int minZ = world.getMinHeight();
        int maxZ = world.getMaxHeight() - 1;
        for (int dz = 0; dz <= size + r && z + dz <= maxZ; ++dz) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    Cursor cursor;
                    if (random.nextInt(vineIncidence) != 0 || !(cursor = new Cursor(world, x + dx, y + dy, z + dz, Direction.NORTH)).isFreeOrInsubstantial()) continue;
                    int turns = random.nextInt(4);
                    for (int i = 0; i < turns; ++i) {
                        cursor.turnRight();
                    }
                    if (!this.isTreeBlock(cursor.getBlockInFront())) continue;
                    int vineLength = random.nextInt(vineLengthVariation) + vineLengthBase;
                    for (int i = 0; i < vineLength && z + dz - i > minZ && this.addVine(world, x + dx, y + dy, z + dz - i, cursor.getDirection()); ++i) {
                    }
                }
            }
        }
    }

    private boolean isTreeBlock(Material material) {
        return material.leafBlock || material.sustainsLeaves;
    }

    private boolean addVine(MinecraftWorld world, int x, int y, int z, Direction direction) {
        Material existingBlock = world.getMaterialAt(x, y, z);
        if (existingBlock == null || existingBlock != Material.AIR && existingBlock.isNotNamed("minecraft:vine")) {
            return false;
        }
        Material vine = existingBlock.isNamed("minecraft:vine") ? existingBlock : Material.VINE;
        switch (direction) {
            case NORTH: {
                vine = vine.withProperty(Material.NORTH, true);
                break;
            }
            case EAST: {
                vine = vine.withProperty(Material.EAST, true);
                break;
            }
            case SOUTH: {
                vine = vine.withProperty(Material.SOUTH, true);
                break;
            }
            case WEST: {
                vine = vine.withProperty(Material.WEST, true);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        world.setMaterialAt(x, y, z, vine);
        return true;
    }
}

