/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.trees;

import java.util.Random;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.layers.trees.TreeType;

public class PineTree
extends TreeType {
    private static final long serialVersionUID = 1L;

    public PineTree() {
        super(Material.WOOD_PINE, Material.LEAVES_PINE);
    }

    @Override
    public void renderTree(int blockInWorldX, int blockInWorldY, int height, int strength, MinecraftWorld minecraftWorld, Dimension dimension, Random random) {
        int size = Math.min(5 + strength / 2, 7) + random.nextInt(3);
        if (height + size >= minecraftWorld.getMaxHeight()) {
            return;
        }
        this.renderTrunk(blockInWorldX, blockInWorldY, height, size, minecraftWorld);
        this.renderCanopy(blockInWorldX, blockInWorldY, height, size, minecraftWorld, random);
    }

    private void renderCanopy(int blockInWorldX, int blockInWorldY, int height, int size, MinecraftWorld minecraftWorld, Random random) {
        int canopyTop = Math.min(size + 5, (int)((float)size * 1.5625f)) - random.nextInt(2);
        int canopyStart = Math.min(size / 2 + 1, 4 + random.nextInt(3));
        int canopyHeight = canopyTop - canopyStart + 1;
        int maxZ = minecraftWorld.getMaxHeight() - 1;
        for (int z = 0; z < canopyHeight && height + z + canopyStart <= maxZ; ++z) {
            int r = (canopyHeight - z) * 4 / 10;
            if (z + canopyStart > size) {
                this.maybePlaceLeaves(blockInWorldX, blockInWorldY, height + z + canopyStart, r, 0.0f, minecraftWorld, random);
            }
            int maxDistance = Math.min(4 - (z + canopyStart - size), r);
            if (r <= 0) continue;
            for (int d = 1; d <= maxDistance; ++d) {
                for (int i = 0; i < d; ++i) {
                    float distance = MathUtils.getDistance((int)(d - i), (int)i);
                    this.maybePlaceLeaves(blockInWorldX - d + i, blockInWorldY - i, height + z + canopyStart, r, distance, minecraftWorld, random);
                    this.maybePlaceLeaves(blockInWorldX + i, blockInWorldY - d + i, height + z + canopyStart, r, distance, minecraftWorld, random);
                    this.maybePlaceLeaves(blockInWorldX + d - i, blockInWorldY + i, height + z + canopyStart, r, distance, minecraftWorld, random);
                    this.maybePlaceLeaves(blockInWorldX - i, blockInWorldY + d - i, height + z + canopyStart, r, distance, minecraftWorld, random);
                }
            }
        }
    }
}

