/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.trees;

import java.util.Random;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.exporting.Cursor;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.layers.trees.TreeType;

public class JungleTree
extends TreeType {
    private static final int VINE_INCIDENCE = 3;
    private static final Material[] COCOA_PODS = new Material[]{Material.COCOA_PLANT, Material.COCOA_PLANT_HALF_RIPE, Material.COCOA_PLANT_RIPE};
    private static final long serialVersionUID = 1L;

    public JungleTree() {
        super(Material.WOOD_JUNGLE, Material.LEAVES_JUNGLE);
    }

    @Override
    public void renderTree(int x, int y, int height, int strength, MinecraftWorld world, Dimension dimension, Random random) {
        int i;
        int size = (int)Math.round((double)random.nextInt(strength) + Math.pow(random.nextDouble(), 4.0) * (double)strength * 3.0);
        if (height + size >= world.getMaxHeight()) {
            return;
        }
        this.renderTrunk(x, y, height, size, world);
        if (size < 12) {
            this.renderCanopy(x, y, height, size, world, random);
        } else if (size < 32) {
            this.renderCanopy(x, y, height, size, world, random);
            this.renderCanopy(x + 1, y, height, size, world, random);
            this.renderCanopy(x, y + 1, height, size, world, random);
            this.renderCanopy(x + 1, y + 1, height, size, world, random);
        } else {
            this.renderCanopy(x - 1, y, height, size, world, random);
            this.renderCanopy(x + 1, y - 1, height, size, world, random);
            this.renderCanopy(x + 2, y + 1, height, size, world, random);
            this.renderCanopy(x, y + 2, height, size, world, random);
        }
        for (i = 0; i < size / 10 + 1; ++i) {
            this.renderBranch(x, y, height, size, (float)(random.nextDouble() * Math.PI * 2.0), world, random);
        }
        for (int z = 4; z < size - 2; ++z) {
            if (random.nextInt(5) != 0) continue;
            this.renderBranch(x, y, height, z, (float)(random.nextDouble() * Math.PI * 2.0), world, random);
        }
        if (size >= 24) {
            for (i = 0; i < size / 10 + 1; ++i) {
                this.renderRoot(x, y, height, size, (float)(random.nextDouble() * Math.PI * 2.0), world, random);
            }
        }
        this.renderVines(x, y, height, size, world, random, 3, 5, 5);
        if (size < 12 && random.nextInt(5) == 0) {
            this.renderCocoaPods(x, y, height, size, world, random);
        }
    }

    private void renderRoot(int x, int y, int height, int size, float angle, MinecraftWorld world, Random random) {
        int minHeight = world.getMinHeight();
        int h = Math.round((float)size / 5.0f);
        Material capMaterial = this.getCapMaterial();
        int i = 1;
        int maxDepth = -1;
        int previousDx = Integer.MIN_VALUE;
        int previousDy = Integer.MIN_VALUE;
        while (h > 0) {
            int dx = (int)Math.round(Math.sin(angle) * (double)i);
            int dy = (int)Math.round(Math.cos(angle) * (double)i);
            if (dx == previousDx && dy == previousDy) {
                ++i;
                continue;
            }
            previousDx = dx;
            previousDy = dy;
            int worldX = x + dx;
            int worldY = y + dy;
            int depth = 0;
            for (int z = height + h; z > minHeight; --z) {
                if (!world.getMaterialAt((int)worldX, (int)worldY, (int)z).veryInsubstantial) {
                    ++depth;
                }
                world.setMaterialAt(worldX, worldY, z, z < height + h ? this.trunkMaterial : capMaterial);
                if (depth > maxDepth) break;
            }
            if (random.nextInt(15) == 0) {
                world.setMaterialAt(worldX, worldY, height + h + 1, random.nextBoolean() ? Material.RED_MUSHROOM : Material.BROWN_MUSHROOM);
            }
            h -= random.nextInt(2) + 1;
            ++i;
            ++maxDepth;
        }
    }

    @Override
    protected void renderTrunk(int blockInWorldX, int blockInWorldY, int height, int size, MinecraftWorld minecraftWorld) {
        if (size < 12) {
            super.renderTrunk(blockInWorldX, blockInWorldY, height, size, minecraftWorld);
        } else if (size < 32) {
            minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY, height, Material.DIRT);
            minecraftWorld.setMaterialAt(blockInWorldX + 1, blockInWorldY, height, Material.DIRT);
            minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY + 1, height, Material.DIRT);
            minecraftWorld.setMaterialAt(blockInWorldX + 1, blockInWorldY + 1, height, Material.DIRT);
            for (int i = 1; i < size; ++i) {
                minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY, height + i, this.trunkMaterial);
                minecraftWorld.setMaterialAt(blockInWorldX + 1, blockInWorldY, height + i, this.trunkMaterial);
                minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY + 1, height + i, this.trunkMaterial);
                minecraftWorld.setMaterialAt(blockInWorldX + 1, blockInWorldY + 1, height + i, this.trunkMaterial);
            }
            Material capMaterial = this.getCapMaterial();
            minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY, height + size, capMaterial);
            minecraftWorld.setMaterialAt(blockInWorldX + 1, blockInWorldY, height + size, capMaterial);
            minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY + 1, height + size, capMaterial);
            minecraftWorld.setMaterialAt(blockInWorldX + 1, blockInWorldY + 1, height + size, capMaterial);
        } else {
            Material capMaterial = this.getCapMaterial();
            for (int dx = -1; dx < 3; ++dx) {
                for (int dy = -1; dy < 3; ++dy) {
                    if (!(dx != -1 && dx != 2 || dy != -1 && dy != 2)) continue;
                    minecraftWorld.setMaterialAt(blockInWorldX + dx, blockInWorldY + dy, height, Material.DIRT);
                    for (int i = 1; i < size; ++i) {
                        minecraftWorld.setMaterialAt(blockInWorldX + dx, blockInWorldY + dy, height + i, this.trunkMaterial);
                    }
                    minecraftWorld.setMaterialAt(blockInWorldX + dx, blockInWorldY + dy, height + size, capMaterial);
                }
            }
        }
    }

    protected void renderCanopy(int x, int y, int height, int size, MinecraftWorld world, Random random) {
        int r = Math.max(Math.min(size, 4), 2);
        int maxZ = world.getMaxHeight() - 1;
        for (int z = Math.max(size - r, 1); z <= size + r && height + z <= maxZ; ++z) {
            float distance = Math.abs(z - size) * 2;
            this.maybePlaceLeaves(x, y, height + z, r, distance, world, random);
            int maxDistance = Math.min(4 - Math.abs(z - size), r);
            for (int d = 1; d <= maxDistance; ++d) {
                for (int i = 0; i < d; ++i) {
                    distance = Math.round(MathUtils.getDistance((int)(d - i), (int)i, (int)((z - size) * 2)));
                    this.maybePlaceLeaves(x - d + i, y - i, height + z, r, distance + (float)random.nextInt(2), world, random);
                    this.maybePlaceLeaves(x + i, y - d + i, height + z, r, distance + (float)random.nextInt(2), world, random);
                    this.maybePlaceLeaves(x + d - i, y + i, height + z, r, distance + (float)random.nextInt(2), world, random);
                    this.maybePlaceLeaves(x - i, y + d - i, height + z, r, distance + (float)random.nextInt(2), world, random);
                }
            }
        }
    }

    protected void renderBranch(int x, int y, int height, int size, float angle, MinecraftWorld world, Random random) {
        Material capMaterial;
        Material branchMaterial;
        int l = Math.round((float)size / 5.0f);
        if (this.trunkMaterial.blockType == 17 || this.trunkMaterial.blockType == 162) {
            branchMaterial = (double)angle < 0.7853981633974483 || (double)angle > 2.356194490192345 && (double)angle < 3.9269908169872414 || (double)angle > 5.497787143782138 ? Material.get(this.trunkMaterial.blockType, this.trunkMaterial.data & 3 | 8) : Material.get(this.trunkMaterial.blockType, this.trunkMaterial.data & 3 | 4);
            capMaterial = this.getCapMaterial();
        } else {
            branchMaterial = capMaterial = this.trunkMaterial;
        }
        float slope = random.nextFloat() / 10.0f - 0.5f;
        for (int i = 1; i < l; ++i) {
            int dx = (int)Math.round(Math.sin(angle) * (double)i);
            int dy = (int)Math.round(Math.cos(angle) * (double)i);
            int dz = (int)((float)i * slope);
            if (!world.getMaterialAt((int)(x + dx), (int)(y + dy), (int)(height + size + dz + 1)).veryInsubstantial) continue;
            world.setMaterialAt(x + dx, y + dy, height + size + dz, i < l - 1 ? branchMaterial : capMaterial);
            if (random.nextInt(25) == 0) {
                world.setMaterialAt(x + dx, y + dy, height + size + dz + 1, random.nextBoolean() ? Material.RED_MUSHROOM : Material.BROWN_MUSHROOM);
            }
            if ((i <= 1 || (i - 1) % 3 != 0) && i != l - 1) continue;
            this.renderCanopy(x + dx, y + dy, height + dz, size, world, random);
        }
    }

    @Override
    protected void maybePlaceLeaves(int x, int y, int h, int r, float distance, MinecraftWorld minecraftWorld, Random random) {
        if (minecraftWorld.getMaterialAt(x, y, h) == Material.AIR && distance <= (float)r) {
            minecraftWorld.setMaterialAt(x, y, h, this.leafMaterial);
        }
    }

    protected void renderCocoaPods(int x, int y, int height, int size, MinecraftWorld world, Random random) {
        if (size < 12) {
            this.renderCocoaPods(x - 1, y, height, size, world, random, Direction.EAST);
            this.renderCocoaPods(x, y - 1, height, size, world, random, Direction.SOUTH);
            this.renderCocoaPods(x + 1, y, height, size, world, random, Direction.WEST);
            this.renderCocoaPods(x, y + 1, height, size, world, random, Direction.NORTH);
        } else if (size < 32) {
            this.renderCocoaPods(x - 1, y, height, size, world, random, Direction.EAST);
            this.renderCocoaPods(x - 1, y + 1, height, size, world, random, Direction.EAST);
            this.renderCocoaPods(x, y - 1, height, size, world, random, Direction.SOUTH);
            this.renderCocoaPods(x + 1, y - 1, height, size, world, random, Direction.SOUTH);
            this.renderCocoaPods(x + 2, y, height, size, world, random, Direction.WEST);
            this.renderCocoaPods(x + 2, y + 1, height, size, world, random, Direction.WEST);
            this.renderCocoaPods(x, y + 2, height, size, world, random, Direction.NORTH);
            this.renderCocoaPods(x + 1, y + 2, height, size, world, random, Direction.NORTH);
        }
    }

    protected void renderCocoaPods(int x, int y, int height, int size, MinecraftWorld world, Random random, Direction direction) {
        Cursor cursor = new Cursor(world, x, y, height + 1, direction);
        for (int i = 0; i < size; ++i) {
            if (random.nextInt(15) == 0 && cursor.isFreeOrInsubstantial()) {
                cursor.setBlockWithDirection(COCOA_PODS[random.nextInt(3)]);
            }
            cursor.up();
        }
    }
}

