/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.trees;

import java.util.Random;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.layers.trees.TreeType;

public class Bush
extends TreeType {
    private static final long serialVersionUID = 1L;

    public Bush() {
        super(Material.WOOD_OAK, Material.LEAVES_OAK);
    }

    @Override
    public void renderTree(int blockInWorldX, int blockInWorldY, int height, int strength, MinecraftWorld minecraftWorld, Dimension dimension, Random random) {
        int z;
        minecraftWorld.setMaterialAt(blockInWorldX, blockInWorldY, height + 1, this.trunkMaterial);
        int r = strength < 2 ? 2 : 2 + random.nextInt(Math.min(strength, 6) / 2);
        int minZ = dimension.getMinHeight() + (dimension.isBottomless() ? 0 : 1);
        int maxZ = dimension.getMaxHeight() - 1;
        for (int dz = -r; dz <= r && (z = height + dz) >= minZ && z <= maxZ; ++dz) {
            float distance = Math.abs(dz - 1);
            this.maybePlaceLeaves(blockInWorldX, blockInWorldY, z, r, distance, minecraftWorld, random);
            int maxDistance = Math.min(4 - Math.abs(dz - 1), r);
            for (int d = 1; d <= maxDistance; ++d) {
                for (int i = 0; i < d; ++i) {
                    distance = MathUtils.getDistance((int)(d - i), (int)i, (int)(dz - 1));
                    this.maybePlaceLeaves(blockInWorldX - d + i, blockInWorldY - i, z, r, distance, minecraftWorld, random);
                    this.maybePlaceLeaves(blockInWorldX + i, blockInWorldY - d + i, z, r, distance, minecraftWorld, random);
                    this.maybePlaceLeaves(blockInWorldX + d - i, blockInWorldY + i, z, r, distance, minecraftWorld, random);
                    this.maybePlaceLeaves(blockInWorldX - i, blockInWorldY + d - i, z, r, distance, minecraftWorld, random);
                }
            }
        }
    }
}

