/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.renderers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pepsoft.util.ColourUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.biomeschemes.StaticBiomeInfo;
import org.pepsoft.worldpainter.layers.renderers.ByteLayerRenderer;
import org.pepsoft.worldpainter.layers.renderers.ColourSchemeRenderer;

public class BiomeRenderer
implements ByteLayerRenderer,
ColourSchemeRenderer,
CustomBiomeManager.CustomBiomeListener {
    private final int[] colours = new int[256];
    private final boolean[] custom = new boolean[256];
    private final Map<Integer, Integer> customColours = new HashMap<Integer, Integer>();
    private final boolean[][][] patterns;
    private ColourScheme colourScheme;
    private static final int BLACK = 0;

    public BiomeRenderer(CustomBiomeManager customBiomeManager) {
        int count = StaticBiomeInfo.INSTANCE.getBiomeCount();
        this.patterns = new boolean[count][][];
        for (int i = 0; i < count; ++i) {
            this.patterns[i] = StaticBiomeInfo.INSTANCE.getPattern(i);
        }
        if (customBiomeManager != null) {
            List<CustomBiome> customBiomes = customBiomeManager.getCustomBiomes();
            for (CustomBiome customBiome : customBiomes) {
                this.customColours.put(customBiome.getId(), customBiome.getColour());
                this.custom[customBiome.getId()] = true;
            }
            this.resetColours();
            customBiomeManager.addListener(this);
        } else {
            this.resetColours();
        }
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    @Override
    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
        this.resetColours();
    }

    @Override
    public int getPixelColour(int x, int y, int underlyingColour, int value) {
        if (value == 255) {
            return underlyingColour;
        }
        if (!this.custom[value] && this.patterns != null && value < this.patterns.length && this.patterns[value] != null && this.patterns[value][x & 0xF][y & 0xF]) {
            return ColourUtils.mix((int)underlyingColour, (int)0);
        }
        return ColourUtils.mix((int)underlyingColour, (int)this.colours[value]);
    }

    @Override
    public void customBiomeAdded(CustomBiome customBiome) {
        this.customColours.put(customBiome.getId(), customBiome.getColour());
        this.custom[customBiome.getId()] = true;
        this.resetColours();
    }

    @Override
    public void customBiomeChanged(CustomBiome customBiome) {
        this.customColours.put(customBiome.getId(), customBiome.getColour());
        this.resetColours();
    }

    @Override
    public void customBiomeRemoved(CustomBiome customBiome) {
        this.customColours.remove(customBiome.getId());
        this.custom[customBiome.getId()] = false;
        this.resetColours();
    }

    private void resetColours() {
        for (int i = 0; i < 256; ++i) {
            this.colours[i] = this.custom[i] ? this.customColours.get(i) : (StaticBiomeInfo.INSTANCE.isBiomePresent(i) && this.colourScheme != null ? StaticBiomeInfo.INSTANCE.getColour(i, this.colourScheme) : CustomBiome.pickColour(i));
        }
    }
}

