/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.plants;

import java.util.Optional;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.layers.plants.Category;
import org.pepsoft.worldpainter.layers.plants.Plant;
import org.pepsoft.worldpainter.layers.plants.PlantWithGrowth;

class VariableHeightPlant
extends PlantWithGrowth {
    public static final int DEFAULT_MAX_GROWTH = 99;
    protected final Material bottomMaterial;
    protected final Material topMaterial;
    protected final int defaultGrowth;
    protected final int growth;
    protected final Point3i dimensions;
    protected final Platform platform;

    VariableHeightPlant(String name, Material middleMaterial, int defaultHeight, Category ... category) {
        this(name, category, "block/" + middleMaterial.simpleName + ".png", null, middleMaterial, null, defaultHeight, defaultHeight, null);
    }

    VariableHeightPlant(String name, Material middleMaterial, String iconName, int defaultHeight, Category ... category) {
        this(name, category, iconName, null, middleMaterial, null, defaultHeight, defaultHeight, null);
    }

    VariableHeightPlant(String name, Material middleMaterial, Material topMaterial, int defaultHeight, Category ... category) {
        this(name, category, "block/" + topMaterial.simpleName + ".png", null, middleMaterial, topMaterial, defaultHeight, defaultHeight, null);
    }

    VariableHeightPlant(String name, Material middleMaterial, Material topMaterial, String iconName, int defaultHeight, Category ... category) {
        this(name, category, iconName, null, middleMaterial, topMaterial, defaultHeight, defaultHeight, null);
    }

    VariableHeightPlant(String name, Material bottomMaterial, Material middleMaterial, Material topMaterial, int defaultHeight, Category ... category) {
        this(name, category, "block/" + topMaterial.simpleName + ".png", bottomMaterial, middleMaterial, topMaterial, defaultHeight, defaultHeight, null);
    }

    VariableHeightPlant(String name, Material bottomMaterial, Material middleMaterial, Material topMaterial, String iconName, int defaultHeight, Category ... category) {
        this(name, category, iconName, bottomMaterial, middleMaterial, topMaterial, defaultHeight, defaultHeight, null);
    }

    private VariableHeightPlant(String name, Category[] categories, String iconName, Material bottomMaterial, Material middleMaterial, Material topMaterial, int defaultGrowth, int growth, Platform platform) {
        super(name, middleMaterial, iconName, 99, categories);
        this.bottomMaterial = bottomMaterial;
        this.topMaterial = topMaterial;
        this.defaultGrowth = defaultGrowth;
        this.growth = growth;
        this.platform = platform;
        this.dimensions = new Point3i(1, 1, growth);
    }

    @Override
    public int getDefaultGrowth() {
        return this.defaultGrowth;
    }

    @Override
    public Point3i getDimensions() {
        return this.dimensions;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        if (z == this.growth - 1) {
            return this.getTopMaterial().orElse(this.material);
        }
        if (z == 0) {
            return this.getBottomMaterial().orElse(this.material);
        }
        return this.material;
    }

    @Override
    public Plant realise(int growth, Platform platform) {
        return new VariableHeightPlant(this.name, this.categories, this.iconName, this.bottomMaterial, this.material, this.topMaterial, this.defaultGrowth, growth, platform);
    }

    Optional<Material> getBottomMaterial() {
        return Optional.ofNullable(this.bottomMaterial);
    }

    Optional<Material> getTopMaterial() {
        return Optional.ofNullable(this.topMaterial);
    }
}

