/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.groundcover;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayerExporter;

public class GroundCoverLayer
extends CustomLayer {
    @Deprecated
    private Material material;
    @Deprecated
    private int colour;
    private int thickness = 1;
    private int edgeWidth = 1;
    private MixedMaterial mixedMaterial;
    private EdgeShape edgeShape = EdgeShape.SHEER;
    private NoiseSettings noiseSettings;
    private boolean smooth;
    private LayerAnchor layerAnchor = LayerAnchor.TERRAIN;
    private static final long serialVersionUID = 1L;

    public GroundCoverLayer(String name, MixedMaterial material, int colour) {
        super(name, "a layer of " + material.getName() + " on top of the terrain", Layer.DataSize.BIT, 30, colour);
        this.mixedMaterial = material;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setDescription("a " + this.thickness + " block layer of " + name + " on top of the terrain");
    }

    @Override
    public String getType() {
        return "Ground Cover";
    }

    public MixedMaterial getMaterial() {
        return this.mixedMaterial;
    }

    public void setMaterial(MixedMaterial material) {
        this.mixedMaterial = material;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
        this.setDescription("a " + thickness + " block layer of " + this.getName() + " on top of the terrain");
    }

    public int getEdgeWidth() {
        return this.edgeWidth;
    }

    public void setEdgeWidth(int edgeWidth) {
        this.edgeWidth = edgeWidth;
    }

    public EdgeShape getEdgeShape() {
        return this.edgeShape;
    }

    public void setEdgeShape(EdgeShape edgeShape) {
        if (edgeShape == null) {
            throw new NullPointerException();
        }
        this.edgeShape = edgeShape;
    }

    public NoiseSettings getNoiseSettings() {
        return this.noiseSettings;
    }

    public void setNoiseSettings(NoiseSettings noiseSettings) {
        this.noiseSettings = noiseSettings;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean smooth) {
        this.smooth = smooth;
    }

    public LayerAnchor getLayerAnchor() {
        return this.layerAnchor;
    }

    public void setLayerAnchor(LayerAnchor layerAnchor) {
        this.layerAnchor = layerAnchor;
    }

    @Override
    public Class<? extends LayerExporter> getExporterType() {
        return GroundCoverLayerExporter.class;
    }

    @Override
    public GroundCoverLayerExporter getExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        return new GroundCoverLayerExporter(dimension, platform, this);
    }

    @Override
    public GroundCoverLayer clone() {
        GroundCoverLayer clone = (GroundCoverLayer)super.clone();
        clone.mixedMaterial = this.mixedMaterial.clone();
        MixedMaterialManager.getInstance().register(clone.mixedMaterial);
        if (this.noiseSettings != null) {
            clone.noiseSettings = this.noiseSettings.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.colour != 0) {
            this.setColour(this.colour);
            this.colour = 0;
        }
        if (this.thickness == 0) {
            this.thickness = 1;
        }
        if (this.mixedMaterial == null) {
            this.mixedMaterial = MixedMaterial.create(DefaultPlugin.JAVA_ANVIL, this.material);
            this.material = null;
        }
        if (this.edgeShape == null) {
            this.edgeWidth = 1;
            this.edgeShape = this.thickness == 1 ? EdgeShape.SHEER : EdgeShape.ROUNDED;
        }
        if (this.layerAnchor == null) {
            this.layerAnchor = LayerAnchor.BEDROCK;
        }
    }

    public static enum LayerAnchor {
        BEDROCK,
        TERRAIN,
        TOP_OF_LAYER;

    }

    public static enum EdgeShape {
        SHEER,
        LINEAR,
        SMOOTH,
        ROUNDED;

    }
}

