/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import java.awt.Rectangle;
import java.util.List;
import java.util.UUID;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.Box;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.BlockBasedExportSettings;
import org.pepsoft.worldpainter.exporting.BlockPropertiesCalculator;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.FrostExporter;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WPObjectExporter<L extends Layer>
extends AbstractLayerExporter<L> {
    private static final String[] AIR_AND_FLUIDS = new String[]{"minecraft:air", "minecraft:water", "minecraft:lava"};
    private static final Logger logger = LoggerFactory.getLogger(WPObjectExporter.class);

    public WPObjectExporter(Dimension dimension, Platform platform, ExporterSettings settings, L layer) {
        super(dimension, platform, settings, layer);
    }

    public static void renderObject(MinecraftWorld world, Dimension dimension, Platform platform, WPObject object, int x, int y, int z) {
        WPObjectExporter.renderObject(world, dimension, platform, object, x, y, z, false);
    }

    public static void renderObject(MinecraftWorld world, Dimension dimension, Platform platform, WPObject object, int x, int y, int z, boolean obliterate) {
        try {
            List<TileEntity> tileEntities;
            Material replaceMaterial;
            Point3i dim = object.getDimensions();
            Point3i offset = object.getOffset();
            int minHeight = world.getMinHeight();
            int maxHeight = world.getMaxHeight();
            if (z + offset.z + dim.z - 1 >= maxHeight) {
                return;
            }
            int undergroundMode = object.getAttribute(WPObject.ATTRIBUTE_UNDERGROUND_MODE);
            int leafDecayMode = object.getAttribute(WPObject.ATTRIBUTE_LEAF_DECAY_MODE);
            boolean bottomless = dimension.isBottomless();
            if (object.hasAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL)) {
                replaceMaterial = object.getAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL);
            } else if (object.hasAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR)) {
                int[] ids = object.getAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR);
                replaceMaterial = Material.get(ids[0], ids[1]);
            } else {
                replaceMaterial = null;
            }
            boolean replaceBlocks = replaceMaterial != null;
            boolean extendFoundation = object.getAttribute(WPObject.ATTRIBUTE_EXTEND_FOUNDATION);
            boolean waterLoggedLeaves = platform.capabilities.contains((Object)Platform.Capability.WATERLOGGED_LEAVES);
            for (int dx = 0; dx < dim.x; ++dx) {
                for (int dy = 0; dy < dim.y; ++dy) {
                    int worldX = x + dx + offset.x;
                    int worldY = y + dy + offset.y;
                    int terrainHeight = dimension.getIntHeightAt(worldX, worldY);
                    for (int dz = 0; dz < dim.z; ++dz) {
                        if (!object.getMask(dx, dy, dz)) continue;
                        Material objectMaterial = object.getMaterial(dx, dy, dz);
                        Material finalMaterial = replaceBlocks && objectMaterial == replaceMaterial ? Material.AIR : objectMaterial;
                        int worldZ = z + dz + offset.z;
                        if (worldZ < minHeight + (bottomless || obliterate ? 0 : 1)) continue;
                        if (obliterate) {
                            WPObjectExporter.placeBlock(world, worldX, worldY, worldZ, finalMaterial, leafDecayMode, waterLoggedLeaves);
                        } else {
                            Material existingMaterial = world.getMaterialAt(worldX, worldY, worldZ);
                            if (worldZ <= terrainHeight) {
                                switch (undergroundMode) {
                                    case 1: {
                                        WPObjectExporter.placeBlock(world, worldX, worldY, worldZ, finalMaterial, leafDecayMode, waterLoggedLeaves);
                                        break;
                                    }
                                    case 2: {
                                        if (finalMaterial.veryInsubstantial) break;
                                        WPObjectExporter.placeBlock(world, worldX, worldY, worldZ, finalMaterial, leafDecayMode, waterLoggedLeaves);
                                        break;
                                    }
                                    case 3: {
                                        if (!existingMaterial.veryInsubstantial) break;
                                        WPObjectExporter.placeBlock(world, worldX, worldY, worldZ, finalMaterial, leafDecayMode, waterLoggedLeaves);
                                    }
                                }
                            } else if (existingMaterial.veryInsubstantial) {
                                WPObjectExporter.placeBlock(world, worldX, worldY, worldZ, finalMaterial, leafDecayMode, waterLoggedLeaves);
                            }
                        }
                        if (!extendFoundation || dz != 0 || terrainHeight == Integer.MIN_VALUE || worldZ <= terrainHeight || finalMaterial.veryInsubstantial) continue;
                        for (int legZ = worldZ - 1; legZ >= minHeight && world.getMaterialAt((int)worldX, (int)worldY, (int)legZ).veryInsubstantial; --legZ) {
                            WPObjectExporter.placeBlock(world, worldX, worldY, legZ, finalMaterial, leafDecayMode, waterLoggedLeaves);
                        }
                    }
                }
            }
            List<Entity> entities = object.getEntities();
            if (entities != null) {
                for (Entity entity : entities) {
                    double[] relPos = entity.getRelPos();
                    double entityX = (double)x + relPos[0] + (double)offset.x;
                    double entityY = (double)y + relPos[2] + (double)offset.y;
                    double entityZ = (double)z + relPos[1] + (double)offset.z;
                    if (entityZ < (double)minHeight || entityZ >= (double)maxHeight) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("NOT adding entity " + entity.getId() + " @ " + entityX + "," + entityY + "," + entityZ + " because z coordinate is out of range!");
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Adding entity " + entity.getId() + " @ " + entityX + "," + entityY + "," + entityZ);
                    }
                    entity.setUUID(UUID.randomUUID());
                    world.addEntity(entityX, entityY, entityZ, entity);
                }
            }
            if ((tileEntities = object.getTileEntities()) != null) {
                for (TileEntity tileEntity : tileEntities) {
                    int tileEntityX = x + tileEntity.getX() + offset.x;
                    int tileEntityY = y + tileEntity.getZ() + offset.y;
                    int tileEntityZ = z + tileEntity.getY() + offset.z;
                    String entityId = tileEntity.getId();
                    if (tileEntityZ < minHeight || tileEntityZ >= maxHeight) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("NOT adding tile entity " + entityId + " @ " + tileEntityX + "," + tileEntityY + "," + tileEntityZ + " because z coordinate is out of range!");
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Adding tile entity " + entityId + " @ " + tileEntityX + "," + tileEntityY + "," + tileEntityZ);
                    }
                    world.addTileEntity(tileEntityX, tileEntityY, tileEntityZ, tileEntity);
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage() + " (object: " + object.getName() + " at " + x + "," + y + "," + z + ")", e);
        }
    }

    public static void renderObjectInverted(MinecraftWorld world, Platform platform, WPObject object, int x, int y, int z) {
        try {
            List<TileEntity> tileEntities;
            Material replaceMaterial;
            Point3i dim = object.getDimensions();
            Point3i offset = object.getOffset();
            int minHeight = world.getMinHeight();
            int maxHeight = world.getMaxHeight();
            if (z - offset.z >= maxHeight) {
                return;
            }
            int leafDecayMode = object.getAttribute(WPObject.ATTRIBUTE_LEAF_DECAY_MODE);
            if (object.hasAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL)) {
                replaceMaterial = object.getAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL);
            } else if (object.hasAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR)) {
                int[] ids = object.getAttribute(WPObject.ATTRIBUTE_REPLACE_WITH_AIR);
                replaceMaterial = Material.get(ids[0], ids[1]);
            } else {
                replaceMaterial = null;
            }
            boolean replaceBlocks = replaceMaterial != null;
            boolean waterLoggedLeaves = platform.capabilities.contains((Object)Platform.Capability.WATERLOGGED_LEAVES);
            for (int dx = 0; dx < dim.x; ++dx) {
                for (int dy = 0; dy < dim.y; ++dy) {
                    int worldX = x + dx + offset.x;
                    int worldY = y + dy + offset.y;
                    for (int dz = 0; dz < dim.z; ++dz) {
                        if (!object.getMask(dx, dy, dz)) continue;
                        Material objectMaterial = object.getMaterial(dx, dy, dz);
                        Material finalMaterial = replaceBlocks && objectMaterial == replaceMaterial ? Material.AIR : objectMaterial;
                        int worldZ = z - dz - offset.z;
                        Material existingMaterial = world.getMaterialAt(worldX, worldY, worldZ);
                        if (!existingMaterial.veryInsubstantial) continue;
                        WPObjectExporter.placeBlock(world, worldX, worldY, worldZ, finalMaterial, leafDecayMode, waterLoggedLeaves);
                    }
                }
            }
            List<Entity> entities = object.getEntities();
            if (entities != null) {
                for (Entity entity : entities) {
                    double[] relPos = entity.getRelPos();
                    double entityX = (double)x + relPos[0] + (double)offset.x;
                    double entityY = (double)y + relPos[2] + (double)offset.y;
                    double entityZ = (double)z - relPos[1] - (double)offset.z;
                    if (entityZ < (double)minHeight || entityZ >= (double)maxHeight) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("NOT adding entity " + entity.getId() + " @ " + entityX + "," + entityY + "," + entityZ + " because z coordinate is out of range!");
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Adding entity " + entity.getId() + " @ " + entityX + "," + entityY + "," + entityZ);
                    }
                    entity.setUUID(UUID.randomUUID());
                    world.addEntity(entityX, entityY, entityZ, entity);
                }
            }
            if ((tileEntities = object.getTileEntities()) != null) {
                for (TileEntity tileEntity : tileEntities) {
                    int tileEntityX = x + tileEntity.getX() + offset.x;
                    int tileEntityY = y + tileEntity.getZ() + offset.y;
                    int tileEntityZ = z - tileEntity.getY() - offset.z;
                    String entityId = tileEntity.getId();
                    if (tileEntityZ < minHeight || tileEntityZ >= maxHeight) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("NOT adding tile entity " + entityId + " @ " + tileEntityX + "," + tileEntityY + "," + tileEntityZ + " because z coordinate is out of range!");
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Adding tile entity " + entityId + " @ " + tileEntityX + "," + tileEntityY + "," + tileEntityZ);
                    }
                    world.addTileEntity(tileEntityX, tileEntityY, tileEntityZ, tileEntity);
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage() + " (object: " + object.getName() + " at " + x + "," + y + "," + z + ")", e);
        }
    }

    public static boolean isSane(WPObject object, int x, int y, int z, int minHeight, int maxHeight) {
        Point3i dimensions = object.getDimensions();
        Point3i offset = object.getOffset();
        if ((long)x + (long)offset.x < Integer.MIN_VALUE || (long)x + (long)dimensions.x - 1L + (long)offset.x > Integer.MAX_VALUE) {
            return false;
        }
        if ((long)y + (long)offset.y < Integer.MIN_VALUE || (long)y + (long)dimensions.y - 1L + (long)offset.y > Integer.MAX_VALUE) {
            return false;
        }
        if ((long)z + (long)offset.z >= (long)maxHeight) {
            return false;
        }
        return (long)z + (long)dimensions.z - 1L + (long)offset.z >= (long)minHeight;
    }

    public static boolean isRoom(MinecraftWorld world, Dimension dimension, WPObject object, int x, int y, int z, Placement placement) {
        Point3i dimensions = object.getDimensions();
        Point3i offset = object.getOffset();
        int collisionMode = object.getAttribute(WPObject.ATTRIBUTE_COLLISION_MODE);
        int minHeight = world.getMinHeight();
        int maxHeight = world.getMaxHeight();
        boolean collideWithFloor = object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_WATER_NO_COLLIDE) == false;
        boolean allowConnectingBlocks = false;
        boolean bottomlessWorld = dimension.isBottomless();
        int minZ = minHeight + (bottomlessWorld ? 0 : 1);
        if ((long)z + (long)dimensions.z - 1L + (long)offset.z >= (long)maxHeight) {
            if (logger.isTraceEnabled()) {
                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " because it does not fit below the map height of " + maxHeight);
            }
            return false;
        }
        if ((long)z + (long)dimensions.z - 1L + (long)offset.z < (long)minHeight) {
            if (logger.isTraceEnabled()) {
                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " because it is entirely below the bedrock");
            }
            return false;
        }
        if (placement == Placement.ON_LAND && collisionMode != 3) {
            for (int dx = 0; dx < dimensions.x; ++dx) {
                for (int dy = 0; dy < dimensions.y; ++dy) {
                    int worldX = x + dx + offset.x;
                    int worldY = y + dy + offset.y;
                    for (int dz = 0; dz < dimensions.z; ++dz) {
                        if (!object.getMask(dx, dy, dz)) continue;
                        Material objectBlock = object.getMaterial(dx, dy, dz);
                        if (objectBlock.veryInsubstantial) continue;
                        int worldZ = z + dz + offset.z;
                        if (worldZ < minZ) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " because it extends below the bottom of the map");
                            }
                            return false;
                        }
                        if (worldZ >= maxHeight) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " because it extends above the top of the map");
                            }
                            return false;
                        }
                        if (worldZ <= dimension.getIntHeightAt(worldX, worldY)) continue;
                        Material material = world.getMaterialAt(worldX, worldY, worldZ);
                        if (collisionMode == 1 ? material != Material.AIR && !material.isNamed("minecraft:water") && !material.isNamed("minecraft:lava") : !material.veryInsubstantial) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " due to collision with existing above ground block of type " + world.getMaterialAt(worldX, worldY, worldZ));
                            }
                            return false;
                        }
                        if (!WPObjectExporter.wouldConnect(world, worldX, worldY, worldZ, objectBlock)) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " because it would cause a connecting block");
                        }
                        return false;
                    }
                }
            }
        } else if (placement == Placement.FLOATING) {
            for (int dx = 0; dx < dimensions.x; ++dx) {
                for (int dy = 0; dy < dimensions.y; ++dy) {
                    int worldX = x + dx + offset.x;
                    int worldY = y + dy + offset.y;
                    int terrainHeight = dimension.getIntHeightAt(worldX, worldY);
                    for (int dz = 0; dz < dimensions.z; ++dz) {
                        if (!object.getMask(dx, dy, dz)) continue;
                        Material objectBlock = object.getMaterial(dx, dy, dz);
                        if (objectBlock.veryInsubstantial) continue;
                        int worldZ = z + dz + offset.z;
                        if (worldZ < minZ) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " because it extends below the bottom of the map");
                            }
                            return false;
                        }
                        if (worldZ >= maxHeight) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " because it extends above the top of the map");
                            }
                            return false;
                        }
                        if (worldZ <= terrainHeight && collideWithFloor) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " due to collision with floor");
                            }
                            return false;
                        }
                        if (worldZ <= terrainHeight || collisionMode == 3) continue;
                        if (collisionMode == 1 ? !world.getMaterialAt(worldX, worldY, worldZ).isNamedOneOf(AIR_AND_FLUIDS) : !world.getMaterialAt((int)worldX, (int)worldY, (int)worldZ).veryInsubstantial) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " due to collision with existing above ground block of type " + world.getMaterialAt(worldX, worldY, worldZ));
                            }
                            return false;
                        }
                        if (!WPObjectExporter.wouldConnect(world, worldX, worldY, worldZ, objectBlock)) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("No room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement) + " because it would cause a connecting block");
                        }
                        return false;
                    }
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("There is room for object " + object.getName() + " @ " + x + "," + y + "," + z + " with placement " + (Object)((Object)placement));
        }
        return true;
    }

    private static boolean wouldConnect(MinecraftWorld world, int worldX, int worldY, int worldZ, Material objectBlock) {
        if (WPObjectExporter.wouldConnect(objectBlock, world.getMaterialAt(worldX - 1, worldY, worldZ))) {
            if (logger.isTraceEnabled()) {
                logger.trace(objectBlock + " @ " + worldX + "," + worldY + "," + worldZ + " would connect to " + world.getMaterialAt(worldX - 1, worldY, worldZ) + " @ dx = -1");
            }
            return true;
        }
        if (WPObjectExporter.wouldConnect(objectBlock, world.getMaterialAt(worldX, worldY - 1, worldZ))) {
            if (logger.isTraceEnabled()) {
                logger.trace(objectBlock + " @ " + worldX + "," + worldY + "," + worldZ + " would connect to " + world.getMaterialAt(worldX, worldY - 1, worldZ) + " @ dy = -1");
            }
            return true;
        }
        if (WPObjectExporter.wouldConnect(objectBlock, world.getMaterialAt(worldX + 1, worldY, worldZ))) {
            if (logger.isTraceEnabled()) {
                logger.trace(objectBlock + " @ " + worldX + "," + worldY + "," + worldZ + " would connect to " + world.getMaterialAt(worldX + 1, worldY, worldZ) + " @ dx = 1");
            }
            return true;
        }
        if (WPObjectExporter.wouldConnect(objectBlock, world.getMaterialAt(worldX, worldY + 1, worldZ))) {
            if (logger.isTraceEnabled()) {
                logger.trace(objectBlock + " @ " + worldX + "," + worldY + "," + worldZ + " would connect to " + world.getMaterialAt(worldX, worldY + 1, worldZ) + " @ dy = 1");
            }
            return true;
        }
        return false;
    }

    private static boolean wouldConnect(Material blockTypeOne, Material blockTypeTwo) {
        if (blockTypeOne == Material.AIR || blockTypeTwo == Material.AIR) {
            return false;
        }
        if (blockTypeOne.solid) {
            if (blockTypeTwo.solid) {
                return false;
            }
            return WPObjectExporter.wouldConnect(blockTypeTwo, blockTypeOne);
        }
        switch (blockTypeOne.name) {
            case "minecraft:oak_fence": {
                return blockTypeTwo.isNamed("minecraft:oak_fence") || blockTypeTwo.solid;
            }
            case "minecraft:nether_brick_fence": {
                return blockTypeTwo.isNamed("minecraft:nether_brick_fence") || blockTypeTwo.solid;
            }
            case "minecraft:spruce_fence": {
                return blockTypeTwo.isNamed("minecraft:spruce_fence") || blockTypeTwo.solid;
            }
            case "minecraft:jungle_fence": {
                return blockTypeTwo.isNamed("minecraft:jungle_fence") || blockTypeTwo.solid;
            }
            case "minecraft:dark_oak_fence": {
                return blockTypeTwo.isNamed("minecraft:dark_oak_fence") || blockTypeTwo.solid;
            }
            case "minecraft:acacia_fence": {
                return blockTypeTwo.isNamed("minecraft:acacia_fence") || blockTypeTwo.solid;
            }
            case "minecraft:birch_fence": {
                return blockTypeTwo.isNamed("minecraft:birch_fence") || blockTypeTwo.solid;
            }
            case "minecraft:cobblestone_wall": {
                return blockTypeTwo.isNamed("minecraft:cobblestone_wall") || blockTypeTwo.solid;
            }
            case "minecraft:iron_bars": {
                return blockTypeTwo.isNamed("minecraft:iron_bars") || blockTypeTwo.solid;
            }
            case "minecraft:glass_pane": {
                return blockTypeTwo.isNamed("minecraft:glass_pane") || blockTypeTwo.solid;
            }
        }
        return false;
    }

    private static Box getBounds(WPObject object, int x, int y, int z) {
        Point3i dimensions = object.getDimensions();
        Point3i offset = object.getOffset();
        return new Box(x + offset.x, x + offset.x + dimensions.x, y + offset.y, y + offset.y + dimensions.y, z + offset.z, z + offset.z + dimensions.z);
    }

    private static void placeBlock(MinecraftWorld world, int x, int y, int z, Material material, int leafDecayMode, boolean waterloggedLeaves) {
        boolean materialHasPropertyWaterlogged;
        if (material.leafBlock) {
            materialHasPropertyWaterlogged = waterloggedLeaves;
            if (leafDecayMode != 1) {
                material = leafDecayMode == 2 ? material.withProperty(Material.PERSISTENT, false) : material.withProperty(Material.PERSISTENT, true);
            }
        } else {
            materialHasPropertyWaterlogged = material.hasProperty(Material.WATERLOGGED);
        }
        Material existingMaterial = world.getMaterialAt(x, y, z);
        boolean existingMaterialContainsWater = existingMaterial.containsWater();
        if ((existingMaterial.translucent || existingMaterial.hasProperty(Material.WATERLOGGED)) && materialHasPropertyWaterlogged) {
            material = existingMaterialContainsWater ? material.withProperty(Material.WATERLOGGED, true) : material.withProperty(Material.WATERLOGGED, false);
        }
        if (!material.veryInsubstantial || !existingMaterialContainsWater || material.containsWater() || material == Material.AIR) {
            world.setMaterialAt(x, y, z, material);
        }
    }

    public static enum Placement {
        NONE,
        FLOATING,
        ON_LAND;

    }

    public static class WPObjectFixup
    implements Fixup {
        private final WPObject object;
        private final int x;
        private final int y;
        private final int z;
        private final Placement placement;
        private static final long serialVersionUID = 1L;

        public WPObjectFixup(WPObject object, int x, int y, int z, Placement placement) {
            this.object = object;
            this.x = x;
            this.y = y;
            this.z = z;
            this.placement = placement;
        }

        @Override
        public void fixup(MinecraftWorld world, Dimension dimension, Platform platform, WorldExportSettings worldExportSettings, ExportSettings exportSettings) {
            if (WPObjectExporter.isRoom(world, dimension, this.object, this.x, this.y, this.z, this.placement)) {
                ExporterSettings frostLayerSettings;
                boolean applyFrost;
                if (logger.isTraceEnabled()) {
                    logger.trace("Placing custom object " + this.object.getName() + " @ " + this.x + "," + this.y + "," + this.z + " in fixup");
                }
                WPObjectExporter.renderObject(world, dimension, platform, this.object, this.x, this.y, this.z);
                if (dimension.getBitLayerValueAt(Frost.INSTANCE, this.x, this.y)) {
                    applyFrost = true;
                    frostLayerSettings = null;
                } else {
                    frostLayerSettings = dimension.getLayerSettings(Frost.INSTANCE);
                    boolean bl = applyFrost = frostLayerSettings != null && frostLayerSettings.isApplyEverywhere();
                }
                if (applyFrost) {
                    FrostExporter frostExporter = new FrostExporter(dimension, platform, frostLayerSettings);
                    Point3i offset = this.object.getOffset();
                    Point3i dim = this.object.getDimensions();
                    Rectangle area = new Rectangle(this.x + offset.x, this.y + offset.y, dim.x, dim.y);
                    frostExporter.addFeatures(area, null, world);
                }
                Box bounds = WPObjectExporter.getBounds(this.object, this.x, this.y, this.z);
                bounds.setZ1(Math.max(bounds.getZ1() - 1, world.getMinHeight()));
                bounds.setZ2(Math.min(bounds.getZ2() + 1, world.getMaxHeight()));
                try {
                    PlatformManager.getInstance().getPostProcessor(platform).postProcess(world, bounds, exportSettings, null);
                }
                catch (ProgressReceiver.OperationCancelled e) {
                    throw new InternalError();
                }
                if (exportSettings instanceof BlockBasedExportSettings && BlockPropertiesCalculator.isBlockPropertiesPassNeeded(platform, worldExportSettings, (BlockBasedExportSettings)exportSettings)) {
                    this.recalculateBlockProperties(world, bounds, platform, worldExportSettings, (BlockBasedExportSettings)exportSettings);
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace("No room for custom object " + this.object.getName() + " @ " + this.x + "," + this.y + "," + this.z + " in fixup");
            }
        }

        private void recalculateBlockProperties(MinecraftWorld world, Box lightBox, Platform platform, WorldExportSettings worldExportSettings, BlockBasedExportSettings exportSettings) {
            BlockPropertiesCalculator blockPropertiesCalculator = new BlockPropertiesCalculator(world, platform, worldExportSettings, exportSettings);
            Box dirtyArea = new Box(lightBox.getX1() - 1, lightBox.getX2() + 1, MathUtils.clamp((int)world.getMinHeight(), (int)(lightBox.getZ1() - 4), (int)(world.getMaxHeight() - 1)), lightBox.getZ2(), lightBox.getY1() - 1, lightBox.getY2() + 1);
            if (dirtyArea.getVolume() == 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Dirty area for lighting calculation is empty; skipping lighting calculation");
                }
                return;
            }
            blockPropertiesCalculator.setDirtyArea(dirtyArea);
            if (logger.isTraceEnabled()) {
                logger.trace("Recalculating light in " + blockPropertiesCalculator.getDirtyArea());
            }
            blockPropertiesCalculator.firstPass();
            while (blockPropertiesCalculator.secondPass()) {
            }
            blockPropertiesCalculator.finalise();
        }
    }
}

