/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.River;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.util.GeometryUtil;

public class RiverExporter
extends AbstractLayerExporter<River>
implements SecondPassLayerExporter {
    private final PerlinNoise floorNoise = new PerlinNoise(0L);

    public RiverExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        super(dimension, platform, settings != null ? settings : new RiverSettings(), River.INSTANCE);
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return Collections.singleton(SecondPassLayerExporter.Stage.ADD_FEATURES);
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        int y;
        int x;
        RiverSettings settings = new RiverSettings();
        int shoreHeight = settings.getShoreHeight();
        boolean shore = shoreHeight > 0;
        MixedMaterial riverBedMaterial = settings.getRiverBedMaterial();
        int riverConnectionRadius = settings.getRiverConnectionRadius();
        int maxDepth = shoreHeight + settings.getMaxDepth();
        int depthVariation = settings.getMaxDepth() - settings.getMinDepth();
        long seed = this.dimension.getSeed();
        if (this.floorNoise.getSeed() != seed) {
            this.floorNoise.setSeed(seed);
        }
        for (x = area.x; x < area.x + area.width; ++x) {
            for (y = area.y; y < area.y + area.height; ++y) {
                int z;
                int dz;
                if (!this.dimension.getBitLayerValueAt(River.INSTANCE, x, y)) continue;
                float distanceToShore = this.dimension.getDistanceToEdge(River.INSTANCE, x, y, maxDepth);
                int depth = (int)Math.min(distanceToShore, (float)(maxDepth - Math.round((this.floorNoise.getPerlinNoise((double)((float)x / 4.099f), (double)((float)y / 4.099f)) + 0.5f) * (float)depthVariation)));
                int terrainHeight = this.dimension.getIntHeightAt(x, y);
                int waterLevel = this.dimension.getWaterLevelAt(x, y);
                if (waterLevel > terrainHeight && !this.dimension.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y)) {
                    for (dz = 0; dz >= -depth - 1; --dz) {
                        z = waterLevel + dz;
                        if (dz > -depth) {
                            minecraftWorld.setMaterialAt(x, y, z, Material.STATIONARY_WATER);
                            continue;
                        }
                        if (z > terrainHeight) continue;
                        minecraftWorld.setMaterialAt(x, y, z, riverBedMaterial.getMaterial(seed, x, y, z));
                    }
                    continue;
                }
                for (dz = 0; dz >= -depth - 1 && (z = terrainHeight + dz) > 0; --dz) {
                    Material existingMaterial;
                    if (dz <= -depth) {
                        existingMaterial = minecraftWorld.getMaterialAt(x, y, z);
                        if (existingMaterial.veryInsubstantial) continue;
                        minecraftWorld.setMaterialAt(x, y, z, riverBedMaterial.getMaterial(seed, x, y, z));
                        continue;
                    }
                    if (dz > -shoreHeight) {
                        existingMaterial = minecraftWorld.getMaterialAt(x, y, z);
                        if (!existingMaterial.isNotNamed("minecraft:water")) continue;
                        minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
                        continue;
                    }
                    if (dz == -shoreHeight) {
                        minecraftWorld.setMaterialAt(x, y, z, Material.STATIONARY_WATER);
                        continue;
                    }
                    minecraftWorld.setMaterialAt(x, y, z, Material.STATIONARY_WATER);
                }
            }
        }
        if (shore) {
            for (x = area.x; x < area.x + area.width; ++x) {
                for (y = area.y; y < area.y + area.height; ++y) {
                    int waterLevel = this.dimension.getWaterLevelAt(x, y);
                    if (!this.dimension.getBitLayerValueAt(River.INSTANCE, x, y) || waterLevel <= this.dimension.getIntHeightAt(x, y) || this.dimension.getFloodedCount(x, y, 1, false) >= 9) continue;
                    int finalX = x;
                    int finalY = y;
                    boolean[] higherRiverAround = new boolean[1];
                    GeometryUtil.visitFilledCircle(riverConnectionRadius, (dx, dy, d) -> {
                        int x1 = finalX + dx;
                        int y1 = finalY + dy;
                        if (this.dimension.getBitLayerValueAt(River.INSTANCE, x1, y1) && this.dimension.getIntHeightAt(x1, y1) - shoreHeight > waterLevel) {
                            higherRiverAround[0] = true;
                            return false;
                        }
                        return true;
                    });
                    if (higherRiverAround[0]) {
                        GeometryUtil.visitFilledCircle(riverConnectionRadius, (dx, dy, d) -> {
                            int x1 = finalX + dx;
                            int y1 = finalY + dy;
                            if (this.dimension.getBitLayerValueAt(River.INSTANCE, x1, y1) && this.dimension.getWaterLevelAt(x1, y1) < waterLevel) {
                                int z = waterLevel;
                                Material existingMaterial = minecraftWorld.getMaterialAt(x1, y1, z);
                                while (z > 0 && existingMaterial.isNotNamedOneOf("minecraft:water", "minecraft:ice") && existingMaterial.veryInsubstantial) {
                                    minecraftWorld.setMaterialAt(x1, y1, z, Material.STATIONARY_WATER);
                                    existingMaterial = minecraftWorld.getMaterialAt(x1, y1, --z);
                                }
                            }
                            return true;
                        });
                        continue;
                    }
                    GeometryUtil.visitFilledCircle(riverConnectionRadius, (dx, dy, d) -> {
                        int x1 = finalX + dx;
                        int y1 = finalY + dy;
                        if (this.dimension.getBitLayerValueAt(River.INSTANCE, x1, y1) && this.dimension.getWaterLevelAt(x1, y1) < waterLevel) {
                            int z = waterLevel - (int)d;
                            Material existingMaterial = minecraftWorld.getMaterialAt(x1, y1, z);
                            while (z > 0 && existingMaterial.isNotNamedOneOf("minecraft:water", "minecraft:ice") && existingMaterial.veryInsubstantial) {
                                minecraftWorld.setMaterialAt(x1, y1, z, Material.STATIONARY_WATER);
                                existingMaterial = minecraftWorld.getMaterialAt(x1, y1, --z);
                            }
                        }
                        return true;
                    });
                }
            }
        }
        for (x = area.x; x < area.x + area.width; ++x) {
            for (y = area.y; y < area.y + area.height; ++y) {
                if (!this.dimension.getBitLayerValueAt(River.INSTANCE, x, y)) continue;
                int lowestWaterHeight = -1;
                for (int z = this.dimension.getIntHeightAt(x, y); z > 0; --z) {
                    if (!minecraftWorld.getMaterialAt(x, y, z).isNamed("minecraft:water") || !minecraftWorld.getMaterialAt(x, y, z - 1).isNotNamed("minecraft:water")) continue;
                    lowestWaterHeight = z;
                    break;
                }
                if (lowestWaterHeight == -1) continue;
                this.raiseWaterTo(this.dimension, minecraftWorld, x + 1, y, lowestWaterHeight - 1);
                this.raiseWaterTo(this.dimension, minecraftWorld, x, y + 1, lowestWaterHeight - 1);
                this.raiseWaterTo(this.dimension, minecraftWorld, x - 1, y, lowestWaterHeight - 1);
                this.raiseWaterTo(this.dimension, minecraftWorld, x, y - 1, lowestWaterHeight - 1);
            }
        }
        return null;
    }

    private void raiseWaterTo(Dimension dimension, MinecraftWorld world, int x, int y, int raiseTo) {
        int z;
        if (!dimension.getBitLayerValueAt(River.INSTANCE, x, y)) {
            return;
        }
        int waterLevel = -1;
        for (z = dimension.getIntHeightAt(x, y); z > this.minHeight; --z) {
            Material existingMaterial = world.getMaterialAt(x, y, z);
            if (existingMaterial == Material.AIR) continue;
            if (existingMaterial.isNamed("minecraft:water")) {
                waterLevel = z;
                break;
            }
            return;
        }
        if (waterLevel != -1) {
            for (z = waterLevel; z <= raiseTo; ++z) {
                world.setMaterialAt(x, y, z, Material.STATIONARY_WATER);
            }
        }
    }

    public static class RiverSettings
    implements ExporterSettings {
        private int shoreHeight = 2;
        private int minDepth = 4;
        private int maxDepth = 7;
        private int riverConnectionRadius = 10;
        private MixedMaterial riverBedMaterial = new MixedMaterial("Riverbed", new MixedMaterial.Row[]{new MixedMaterial.Row(Material.GRASS_BLOCK, 650, 1.0f), new MixedMaterial.Row(Material.GRAVEL, 200, 1.0f), new MixedMaterial.Row(Material.CLAY, 50, 1.0f), new MixedMaterial.Row(Material.STONE, 100, 1.0f)}, 7, 255, 3.0f);
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isApplyEverywhere() {
            return false;
        }

        public int getShoreHeight() {
            return this.shoreHeight;
        }

        public void setShoreHeight(int shoreHeight) {
            this.shoreHeight = shoreHeight;
        }

        public int getMinDepth() {
            return this.minDepth;
        }

        public void setMinDepth(int minDepth) {
            this.minDepth = minDepth;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public void setMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        public MixedMaterial getRiverBedMaterial() {
            return this.riverBedMaterial;
        }

        public void setRiverBedMaterial(MixedMaterial riverBedMaterial) {
            this.riverBedMaterial = riverBedMaterial;
        }

        public int getRiverConnectionRadius() {
            return this.riverConnectionRadius;
        }

        public void setRiverConnectionRadius(int riverConnectionRadius) {
            this.riverConnectionRadius = riverConnectionRadius;
        }

        @Override
        public River getLayer() {
            return River.INSTANCE;
        }

        @Override
        public RiverSettings clone() {
            try {
                return (RiverSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

