/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.util.Version;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesExporter
extends AbstractLayerExporter<Resources>
implements FirstPassLayerExporter {
    private final Material[] activeMaterials;
    private final PerlinNoise[] noiseGenerators;
    private final int[] minLevels;
    private final int[] maxLevels;
    private final float[][] chances;
    private static final Map<String, Material> ORE_TO_DEEPSLATE_VARIANT = ImmutableMap.of((Object)"minecraft:coal_ore", (Object)Material.DEEPSLATE_COAL_ORE, (Object)"minecraft:copper_ore", (Object)Material.DEEPSLATE_COPPER_ORE, (Object)"minecraft:lapis_ore", (Object)Material.DEEPSLATE_LAPIS_ORE, (Object)"minecraft:iron_ore", (Object)Material.DEEPSLATE_IRON_ORE, (Object)"minecraft:gold_ore", (Object)Material.DEEPSLATE_GOLD_ORE, (Object)"minecraft:redstone_ore", (Object)Material.DEEPSLATE_REDSTONE_ORE, (Object)"minecraft:diamond_ore", (Object)Material.DEEPSLATE_DIAMOND_ORE, (Object)"minecraft:emerald_ore", (Object)Material.DEEPSLATE_EMERALD_ORE);

    public ResourcesExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        super(dimension, platform, settings != null ? settings : ResourcesExporterSettings.defaultSettings(platform, dimension.getAnchor(), dimension.getMinHeight(), dimension.getMaxHeight()), Resources.INSTANCE);
        int i;
        ResourcesExporterSettings resourcesSettings = (ResourcesExporterSettings)this.settings;
        Set<Material> allMaterials = resourcesSettings.getMaterials();
        ArrayList<Material> activeMaterials = new ArrayList<Material>(allMaterials.size());
        for (Material material : allMaterials) {
            if (resourcesSettings.getChance(material) <= 0) continue;
            activeMaterials.add(material);
        }
        this.activeMaterials = activeMaterials.toArray(new Material[activeMaterials.size()]);
        this.noiseGenerators = new PerlinNoise[this.activeMaterials.length];
        long[] seedOffsets = new long[this.activeMaterials.length];
        this.minLevels = new int[this.activeMaterials.length];
        this.maxLevels = new int[this.activeMaterials.length];
        this.chances = new float[this.activeMaterials.length][16];
        for (i = 0; i < this.activeMaterials.length; ++i) {
            this.noiseGenerators[i] = new PerlinNoise(0L);
            seedOffsets[i] = resourcesSettings.getSeedOffset(this.activeMaterials[i]);
            this.minLevels[i] = resourcesSettings.getMinLevel(this.activeMaterials[i]);
            this.maxLevels[i] = resourcesSettings.getMaxLevel(this.activeMaterials[i]);
            this.chances[i] = new float[16];
            for (int j = 0; j < 16; ++j) {
                this.chances[i][j] = PerlinNoise.getLevelForPromillage((float)Math.min((float)(resourcesSettings.getChance(this.activeMaterials[i]) * j) / 8.0f, 1000.0f));
            }
        }
        for (i = 0; i < this.activeMaterials.length; ++i) {
            if (this.noiseGenerators[i].getSeed() == dimension.getSeed() + seedOffsets[i]) continue;
            this.noiseGenerators[i].setSeed(dimension.getSeed() + seedOffsets[i]);
        }
    }

    @Override
    public void render(Tile tile, Chunk chunk) {
        int minimumLevel = ((ResourcesExporterSettings)this.settings).getMinimumLevel();
        int xOffset = (chunk.getxPos() & 7) << 4;
        int zOffset = (chunk.getzPos() & 7) << 4;
        boolean coverSteepTerrain = this.dimension.isCoverSteepTerrain();
        boolean nether = this.dimension.getAnchor().dim == 1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int resourcesValue;
                int localX = xOffset + x;
                int localY = zOffset + z;
                int worldX = tile.getX() * 128 + localX;
                int worldY = tile.getY() * 128 + localY;
                if (tile.getBitLayerValue(Void.INSTANCE, localX, localY) || (resourcesValue = Math.max(minimumLevel, tile.getLayerValue(Resources.INSTANCE, localX, localY))) <= 0) continue;
                int terrainheight = tile.getIntHeight(localX, localY);
                int topLayerDepth = this.dimension.getTopLayerDepth(worldX, worldY, terrainheight);
                int subsurfaceMaxHeight = terrainheight - topLayerDepth;
                if (coverSteepTerrain) {
                    subsurfaceMaxHeight = Math.min(subsurfaceMaxHeight, Math.min(Math.min(this.dimension.getIntHeightAt(worldX - 1, worldY, Integer.MAX_VALUE), this.dimension.getIntHeightAt(worldX + 1, worldY, Integer.MAX_VALUE)), Math.min(this.dimension.getIntHeightAt(worldX, worldY - 1, Integer.MAX_VALUE), this.dimension.getIntHeightAt(worldX, worldY + 1, Integer.MAX_VALUE))));
                }
                double dx = (float)worldX / 4.099f;
                double dy = (float)worldY / 4.099f;
                double dirtX = (float)worldX / 16.411f;
                double dirtY = (float)worldY / 16.411f;
                block2: for (int y = Math.min(subsurfaceMaxHeight, this.maxZ); y > this.minZ; --y) {
                    double dz = (float)y / 4.099f;
                    double dirtZ = (float)y / 16.411f;
                    for (int i = 0; i < this.activeMaterials.length; ++i) {
                        float chance = this.chances[i][resourcesValue];
                        if (!(chance <= 0.5f) || y < this.minLevels[i] || y > this.maxLevels[i] || !(this.activeMaterials[i].isNamedOneOf("minecraft:dirt", "minecraft:gravel") ? this.noiseGenerators[i].getPerlinNoise(dirtX, dirtY, dirtZ) >= chance : this.noiseGenerators[i].getPerlinNoise(dx, dy, dz) >= chance)) continue;
                        Material existingMaterial = chunk.getMaterial(x, y, z);
                        if (existingMaterial.isNamed("minecraft:deepslate") && ORE_TO_DEEPSLATE_VARIANT.containsKey(this.activeMaterials[i].name)) {
                            chunk.setMaterial(x, y, z, ORE_TO_DEEPSLATE_VARIANT.get(this.activeMaterials[i].name));
                            continue block2;
                        }
                        if (nether && this.activeMaterials[i].isNamed("minecraft:gold_ore")) {
                            chunk.setMaterial(x, y, z, Material.NETHER_GOLD_ORE);
                            continue block2;
                        }
                        chunk.setMaterial(x, y, z, this.activeMaterials[i]);
                        continue block2;
                    }
                }
            }
        }
    }

    static class ResourceSettings
    implements Serializable,
    Cloneable {
        Material material;
        int minLevel;
        int maxLevel;
        int chance;
        long seedOffset;
        private static final long serialVersionUID = 1L;

        ResourceSettings(Material material, int minLevel, int maxLevel, int chance, long seedOffset) {
            this.material = material;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.chance = chance;
            this.seedOffset = seedOffset;
        }

        public ResourceSettings clone() {
            try {
                return (ResourceSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }

    public static class ResourcesExporterSettings
    implements ExporterSettings {
        private int minimumLevel = 8;
        private Map<Material, ResourceSettings> settings;
        @Deprecated
        private Map<Integer, Integer> maxLevels = null;
        @Deprecated
        private Map<Integer, Integer> chances = null;
        @Deprecated
        private Map<Integer, Long> seedOffsets = null;
        @Deprecated
        private Map<Integer, Integer> minLevels = null;
        private int version = 3;
        private static final long serialVersionUID = 1L;
        private static final Logger logger = LoggerFactory.getLogger(ResourcesExporter.class);

        private ResourcesExporterSettings(Map<Material, ResourceSettings> settings) {
            this.settings = settings;
        }

        @Override
        public boolean isApplyEverywhere() {
            return this.minimumLevel > 0;
        }

        public int getMinimumLevel() {
            return this.minimumLevel;
        }

        public void setMinimumLevel(int minimumLevel) {
            this.minimumLevel = minimumLevel;
        }

        public Set<Material> getMaterials() {
            return this.settings.keySet();
        }

        public int getMinLevel(Material material) {
            return this.settings.get((Object)material).minLevel;
        }

        public void setMinLevel(Material material, int minLevel) {
            this.settings.get((Object)material).minLevel = minLevel;
        }

        public int getMaxLevel(Material material) {
            return this.settings.get((Object)material).maxLevel;
        }

        public void setMaxLevel(Material material, int maxLevel) {
            this.settings.get((Object)material).maxLevel = maxLevel;
        }

        public int getChance(Material material) {
            return this.settings.get((Object)material).chance;
        }

        public void setChance(Material material, int chance) {
            this.settings.get((Object)material).chance = chance;
        }

        public long getSeedOffset(Material material) {
            return this.settings.get((Object)material).seedOffset;
        }

        @Override
        public Resources getLayer() {
            return Resources.INSTANCE;
        }

        @Override
        public void setMinMaxHeight(int oldMinHeight, int newMinHeight, int oldMaxHeight, int newMaxHeight, HeightTransform transform) {
            for (Material material : this.settings.keySet()) {
                int maxLevel = this.settings.get((Object)material).maxLevel;
                if (maxLevel == oldMaxHeight - 1) {
                    maxLevel = newMaxHeight - 1;
                } else if (maxLevel > 1) {
                    maxLevel = MathUtils.clamp((int)newMinHeight, (int)transform.transformHeight(maxLevel), (int)(newMaxHeight - 1));
                }
                this.settings.get((Object)material).maxLevel = maxLevel;
            }
        }

        @Override
        public ResourcesExporterSettings clone() {
            try {
                ResourcesExporterSettings clone = (ResourcesExporterSettings)super.clone();
                clone.settings = new LinkedHashMap<Material, ResourceSettings>();
                this.settings.forEach((material, settings) -> clone.settings.put((Material)material, settings.clone()));
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public static ResourcesExporterSettings defaultSettings(Platform platform, Dimension.Anchor anchor, int minHeight, int maxHeight) {
            Random random = new Random();
            HashMap<Material, ResourceSettings> settings = new HashMap<Material, ResourceSettings>();
            Version mcVersion = platform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION);
            switch (anchor.dim) {
                case 0: {
                    settings.put(Material.DIRT, new ResourceSettings(Material.DIRT, 0, maxHeight - 1, 57, random.nextLong()));
                    settings.put(Material.GRAVEL, new ResourceSettings(Material.GRAVEL, minHeight, maxHeight - 1, 28, random.nextLong()));
                    settings.put(Material.GOLD_ORE, new ResourceSettings(Material.GOLD_ORE, minHeight, 31, 1, random.nextLong()));
                    settings.put(Material.IRON_ORE, new ResourceSettings(Material.IRON_ORE, minHeight, maxHeight - 1, 6, random.nextLong()));
                    settings.put(Material.COAL, new ResourceSettings(Material.COAL, 0, maxHeight - 1, 10, random.nextLong()));
                    settings.put(Material.LAPIS_LAZULI_ORE, new ResourceSettings(Material.LAPIS_LAZULI_ORE, minHeight, 31, 1, random.nextLong()));
                    settings.put(Material.DIAMOND_ORE, new ResourceSettings(Material.DIAMOND_ORE, minHeight, 15, 1, random.nextLong()));
                    settings.put(Material.REDSTONE_ORE, new ResourceSettings(Material.REDSTONE_ORE, minHeight, 15, 8, random.nextLong()));
                    settings.put(Material.STATIONARY_WATER, new ResourceSettings(Material.STATIONARY_WATER, minHeight, maxHeight - 1, 1, random.nextLong()));
                    settings.put(Material.STATIONARY_LAVA, new ResourceSettings(Material.STATIONARY_LAVA, minHeight, 15, 2, random.nextLong()));
                    settings.put(Material.EMERALD_ORE, new ResourceSettings(Material.EMERALD_ORE, 64, maxHeight - 1, mcVersion.isAtLeast(Constants.V_1_2) ? 1 : 0, random.nextLong()));
                    settings.put(Material.COPPER_ORE, new ResourceSettings(Material.COPPER_ORE, 0, 88, mcVersion.isAtLeast(Constants.V_1_17) ? 6 : 0, random.nextLong()));
                    settings.put(Material.QUARTZ_ORE, new ResourceSettings(Material.QUARTZ_ORE, minHeight, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.ANCIENT_DEBRIS, new ResourceSettings(Material.ANCIENT_DEBRIS, minHeight, maxHeight - 1, 0, random.nextLong()));
                    break;
                }
                case 1: {
                    settings.put(Material.QUARTZ_ORE, new ResourceSettings(Material.QUARTZ_ORE, minHeight, maxHeight - 1, mcVersion.isAtLeast(Constants.V_1_2) ? 7 : 0, random.nextLong()));
                    settings.put(Material.GOLD_ORE, new ResourceSettings(Material.GOLD_ORE, minHeight, maxHeight - 1, mcVersion.isAtLeast(Constants.V_1_15) ? 3 : 0, random.nextLong()));
                    settings.put(Material.ANCIENT_DEBRIS, new ResourceSettings(Material.ANCIENT_DEBRIS, minHeight, maxHeight - 1, mcVersion.isAtLeast(Constants.V_1_15) ? 1 : 0, random.nextLong()));
                    settings.put(Material.DIRT, new ResourceSettings(Material.DIRT, 0, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.GRAVEL, new ResourceSettings(Material.GRAVEL, minHeight, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.IRON_ORE, new ResourceSettings(Material.IRON_ORE, minHeight, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.COAL, new ResourceSettings(Material.COAL, 0, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.LAPIS_LAZULI_ORE, new ResourceSettings(Material.LAPIS_LAZULI_ORE, minHeight, 31, 0, random.nextLong()));
                    settings.put(Material.DIAMOND_ORE, new ResourceSettings(Material.DIAMOND_ORE, minHeight, 15, 0, random.nextLong()));
                    settings.put(Material.REDSTONE_ORE, new ResourceSettings(Material.REDSTONE_ORE, minHeight, 15, 0, random.nextLong()));
                    settings.put(Material.STATIONARY_WATER, new ResourceSettings(Material.STATIONARY_WATER, minHeight, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.STATIONARY_LAVA, new ResourceSettings(Material.STATIONARY_LAVA, minHeight, 15, 0, random.nextLong()));
                    settings.put(Material.EMERALD_ORE, new ResourceSettings(Material.EMERALD_ORE, 64, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.COPPER_ORE, new ResourceSettings(Material.COPPER_ORE, 0, 88, 0, random.nextLong()));
                    break;
                }
                case 2: {
                    settings.put(Material.DIRT, new ResourceSettings(Material.DIRT, 0, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.GRAVEL, new ResourceSettings(Material.GRAVEL, minHeight, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.GOLD_ORE, new ResourceSettings(Material.GOLD_ORE, minHeight, 31, 0, random.nextLong()));
                    settings.put(Material.IRON_ORE, new ResourceSettings(Material.IRON_ORE, minHeight, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.COAL, new ResourceSettings(Material.COAL, 0, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.LAPIS_LAZULI_ORE, new ResourceSettings(Material.LAPIS_LAZULI_ORE, minHeight, 31, 0, random.nextLong()));
                    settings.put(Material.DIAMOND_ORE, new ResourceSettings(Material.DIAMOND_ORE, minHeight, 15, 0, random.nextLong()));
                    settings.put(Material.REDSTONE_ORE, new ResourceSettings(Material.REDSTONE_ORE, minHeight, 15, 0, random.nextLong()));
                    settings.put(Material.STATIONARY_WATER, new ResourceSettings(Material.STATIONARY_WATER, minHeight, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.STATIONARY_LAVA, new ResourceSettings(Material.STATIONARY_LAVA, minHeight, 15, 0, random.nextLong()));
                    settings.put(Material.EMERALD_ORE, new ResourceSettings(Material.EMERALD_ORE, 64, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.COPPER_ORE, new ResourceSettings(Material.COPPER_ORE, 0, 88, 0, random.nextLong()));
                    settings.put(Material.QUARTZ_ORE, new ResourceSettings(Material.QUARTZ_ORE, minHeight, maxHeight - 1, 0, random.nextLong()));
                    settings.put(Material.ANCIENT_DEBRIS, new ResourceSettings(Material.ANCIENT_DEBRIS, minHeight, maxHeight - 1, 0, random.nextLong()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Dimension " + anchor.dim + " not supported");
                }
            }
            ResourcesExporterSettings result = new ResourcesExporterSettings(settings);
            if (anchor.role == Dimension.Role.CAVE_FLOOR) {
                result.setMinimumLevel(0);
            }
            return result;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Random random;
            in.defaultReadObject();
            if (this.version < 1) {
                if (!this.maxLevels.containsKey(8)) {
                    logger.warn("Fixing water and lava settings");
                    this.maxLevels.put(8, this.maxLevels.get(9));
                    this.chances.put(8, this.chances.get(9));
                    this.seedOffsets.put(8, this.seedOffsets.get(9));
                    this.maxLevels.put(10, this.maxLevels.get(11));
                    this.chances.put(10, this.chances.get(11));
                    this.seedOffsets.put(10, this.seedOffsets.get(11));
                    this.maxLevels.remove(9);
                    this.chances.remove(9);
                    this.seedOffsets.remove(9);
                    this.maxLevels.remove(11);
                    this.chances.remove(11);
                    this.seedOffsets.remove(11);
                }
                if (!this.maxLevels.containsKey(129)) {
                    this.maxLevels.put(129, 31);
                    this.chances.put(129, 0);
                }
                random = new Random();
                if (!this.seedOffsets.containsKey(129)) {
                    this.seedOffsets.put(129, random.nextLong());
                }
                if (this.minLevels == null) {
                    this.minLevels = new HashMap<Integer, Integer>();
                    for (int blockType : this.maxLevels.keySet()) {
                        this.minLevels.put(blockType, 0);
                    }
                }
                if (!this.minLevels.containsKey(153)) {
                    this.minLevels.put(153, 0);
                    this.maxLevels.put(153, 255);
                    this.chances.put(153, 0);
                    this.seedOffsets.put(153, random.nextLong());
                }
                this.settings = new LinkedHashMap<Material, ResourceSettings>();
                for (int blockType : this.maxLevels.keySet()) {
                    Material material = Material.get(blockType);
                    this.settings.put(material, new ResourceSettings(material, this.minLevels.get(blockType), this.maxLevels.get(blockType), this.chances.get(blockType), this.seedOffsets.get(blockType)));
                }
                this.minLevels = null;
                this.maxLevels = null;
                this.chances = null;
                this.seedOffsets = null;
            }
            if (this.version < 2) {
                random = new Random();
                this.settings.put(Material.COPPER_ORE, new ResourceSettings(Material.COPPER_ORE, 0, 88, 0, random.nextLong()));
                this.settings.put(Material.ANCIENT_DEBRIS, new ResourceSettings(Material.ANCIENT_DEBRIS, -64, 319, 0, random.nextLong()));
            }
            if (this.version < 3) {
                if (this.settings.containsKey(Material.WATER)) {
                    this.settings.put(Material.STATIONARY_WATER, this.settings.get(Material.WATER));
                    this.settings.remove(Material.WATER);
                }
                if (this.settings.containsKey(Material.LAVA)) {
                    this.settings.put(Material.STATIONARY_LAVA, this.settings.get(Material.LAVA));
                    this.settings.remove(Material.LAVA);
                }
            }
            this.version = 3;
        }
    }
}

