/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import com.google.common.collect.Sets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.IncidentalLayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.Bo2Layer;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.layers.exporters.WPObjectExporter;
import org.pepsoft.worldpainter.objects.MirroredObject;
import org.pepsoft.worldpainter.objects.RotatedObject;
import org.pepsoft.worldpainter.objects.WPObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bo2LayerExporter
extends WPObjectExporter<Bo2Layer>
implements SecondPassLayerExporter,
IncidentalLayerExporter {
    private final Random applyRandom = new Random();
    private final Set<WPObject> preparedObjects = Sets.newIdentityHashSet();
    private static final Logger logger = LoggerFactory.getLogger(Bo2LayerExporter.class);

    public Bo2LayerExporter(Dimension dimension, Platform platform, Bo2Layer layer) {
        super(dimension, platform, null, layer);
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return Collections.singleton(SecondPassLayerExporter.Stage.ADD_FEATURES);
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        try {
            Bo2ObjectProvider objectProvider = ((Bo2Layer)this.layer).getObjectProvider();
            ArrayList<Fixup> fixups = new ArrayList<Fixup>();
            int density = ((Bo2Layer)this.layer).getDensity() * 64;
            for (int chunkX = area.x; chunkX < area.x + area.width; chunkX += 16) {
                for (int chunkY = area.y; chunkY < area.y + area.height; chunkY += 16) {
                    if (!this.dimension.isTilePresent(chunkX >> 7, chunkY >> 7)) continue;
                    long seed = this.dimension.getSeed() + (long)(chunkX >> 4) * 65537L + (long)(chunkY >> 4) * 4099L;
                    Random random = new Random(seed);
                    objectProvider.setSeed(seed);
                    for (int x = chunkX; x < chunkX + 16; ++x) {
                        for (int y = chunkY; y < chunkY + 16; ++y) {
                            int z;
                            int rotateSteps;
                            WPObjectExporter.Placement placement;
                            int strength = this.dimension.getLayerValueAt(this.layer, x, y);
                            if (strength <= 0 || random.nextInt(density) > strength * strength) continue;
                            WPObject object = objectProvider.getObject();
                            int variation = object.getAttribute(WPObject.ATTRIBUTE_Y_VARIATION);
                            int height = (object.getAttribute(WPObject.ATTRIBUTE_HEIGHT_MODE) == 1 ? this.dimension.getIntHeightAt(x, y) + 1 : 0) + object.getAttribute(WPObject.ATTRIBUTE_VERTICAL_OFFSET) + (variation > 0 ? random.nextInt(variation + 1) - (variation + 1) / 2 : 0);
                            if (height < this.minHeight || height >= this.maxHeight || (placement = this.getPlacement(minecraftWorld, this.dimension, x, y, height, object, random)) == WPObjectExporter.Placement.NONE) continue;
                            boolean randomRotationAndMirroring = object.getAttribute(WPObject.ATTRIBUTE_RANDOM_ROTATION);
                            if ((randomRotationAndMirroring || object.getAttribute(WPObject.ATTRIBUTE_RANDOM_MIRRORING_ONLY).booleanValue()) && random.nextBoolean()) {
                                object = new MirroredObject(object, !randomRotationAndMirroring && random.nextBoolean(), this.platform);
                            }
                            if ((randomRotationAndMirroring || object.getAttribute(WPObject.ATTRIBUTE_RANDOM_ROTATION_ONLY).booleanValue()) && (rotateSteps = random.nextInt(4)) > 0) {
                                object = new RotatedObject(object, rotateSteps, this.platform);
                            }
                            int n = z = placement == WPObjectExporter.Placement.ON_LAND ? height : this.dimension.getWaterLevelAt(x, y) + 1;
                            if (!Bo2LayerExporter.isSane(object, x, y, z, this.minHeight, this.maxHeight)) continue;
                            this.prepareForExport(object, this.dimension);
                            if (!Bo2LayerExporter.isRoom(minecraftWorld, this.dimension, object, x, y, z, placement)) continue;
                            if (!this.fitsInExportedArea(exportedArea, object, x, y)) {
                                fixups.add(new WPObjectExporter.WPObjectFixup(object, x, y, z, placement));
                                continue;
                            }
                            Bo2LayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, object, x, y, z);
                        }
                    }
                }
            }
            return fixups;
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage() + " (layer: " + ((Bo2Layer)this.layer).getName() + ")", e);
        }
    }

    @Override
    public Fixup apply(Point3i location, int intensity, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        long seed = this.dimension.getSeed() + (long)location.x + (long)location.y * 4099L + (long)location.z * 65537L + (long)((Bo2Layer)this.layer).hashCode();
        this.applyRandom.setSeed(seed);
        if (intensity > 0 && this.applyRandom.nextInt(((Bo2Layer)this.layer).getDensity() * 20) <= intensity * intensity / 225) {
            Material materialBelow;
            Bo2ObjectProvider objectProvider = ((Bo2Layer)this.layer).getObjectProvider();
            objectProvider.setSeed(seed + 1L);
            WPObject object = objectProvider.getObject();
            int variation = object.getAttribute(WPObject.ATTRIBUTE_Y_VARIATION);
            int height = (object.getAttribute(WPObject.ATTRIBUTE_HEIGHT_MODE) == 1 ? location.z : 0) + object.getAttribute(WPObject.ATTRIBUTE_VERTICAL_OFFSET) + (variation > 0 ? this.applyRandom.nextInt(variation + 1) - (variation + 1) / 2 : 0);
            if (height < this.minHeight || height >= this.maxHeight) {
                return null;
            }
            Material existingMaterial = minecraftWorld.getMaterialAt(location.x, location.y, height);
            Material material = materialBelow = height > this.minHeight ? minecraftWorld.getMaterialAt(location.x, location.y, height - 1) : Material.AIR;
            if (object.getAttribute(WPObject.ATTRIBUTE_SPAWN_IN_LAVA) != false && existingMaterial.isNamed("minecraft:lava") || object.getAttribute(WPObject.ATTRIBUTE_SPAWN_IN_WATER) != false && existingMaterial.isNamed("minecraft:water") || object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_LAND) != false && !materialBelow.veryInsubstantial || !object.getAttribute(WPObject.ATTRIBUTE_NEEDS_FOUNDATION).booleanValue() && materialBelow.veryInsubstantial) {
                int rotateSteps;
                boolean randomRotationAndMirroring = object.getAttribute(WPObject.ATTRIBUTE_RANDOM_ROTATION);
                if ((randomRotationAndMirroring || object.getAttribute(WPObject.ATTRIBUTE_RANDOM_MIRRORING_ONLY).booleanValue()) && this.applyRandom.nextBoolean()) {
                    object = new MirroredObject(object, !randomRotationAndMirroring && this.applyRandom.nextBoolean(), this.platform);
                }
                if ((randomRotationAndMirroring || object.getAttribute(WPObject.ATTRIBUTE_RANDOM_ROTATION_ONLY).booleanValue()) && (rotateSteps = this.applyRandom.nextInt(4)) > 0) {
                    object = new RotatedObject(object, rotateSteps, this.platform);
                }
                if (!Bo2LayerExporter.isSane(object, location.x, location.y, height, minecraftWorld.getMinHeight(), minecraftWorld.getMaxHeight())) {
                    return null;
                }
                this.prepareForExport(object, this.dimension);
                if (!Bo2LayerExporter.isRoom(minecraftWorld, this.dimension, object, location.x, location.y, height, WPObjectExporter.Placement.ON_LAND)) {
                    return null;
                }
                if (!this.fitsInExportedArea(exportedArea, object, location.x, location.y)) {
                    return new WPObjectExporter.WPObjectFixup(object, location.x, location.y, height, WPObjectExporter.Placement.ON_LAND);
                }
                Bo2LayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, object, location.x, location.y, height);
            }
        }
        return null;
    }

    private boolean fitsInExportedArea(Rectangle exportedArea, WPObject object, int x, int y) {
        Point3i dimensions = object.getDimensions();
        Point3i offset = object.getOffset();
        return x + offset.x >= exportedArea.x && x + offset.x + dimensions.x - 1 <= exportedArea.x + exportedArea.width - 1 && y + offset.y >= exportedArea.y && y + offset.y + dimensions.y - 1 <= exportedArea.y + exportedArea.height - 1;
    }

    private WPObjectExporter.Placement getPlacement(MinecraftWorld minecraftWorld, Dimension dimension, int x, int y, int z, WPObject object, Random random) {
        boolean flooded;
        boolean spawnUnderWater = object.getAttribute(WPObject.ATTRIBUTE_SPAWN_IN_WATER);
        boolean spawnUnderLava = object.getAttribute(WPObject.ATTRIBUTE_SPAWN_IN_LAVA);
        boolean spawnOnWater = object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_WATER);
        boolean spawnOnLava = object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_LAVA);
        if (object.getAttribute(WPObject.ATTRIBUTE_HEIGHT_MODE) == 1) {
            flooded = dimension.getWaterLevelAt(x, y) >= z;
        } else {
            boolean bl = flooded = z > dimension.getIntHeightAt(x, y) && dimension.getWaterLevelAt(x, y) >= z;
        }
        if (flooded && (spawnUnderWater || spawnUnderLava || spawnOnWater || spawnOnLava)) {
            boolean lava = dimension.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y);
            if (lava ? spawnUnderLava && spawnOnLava : spawnUnderWater && spawnOnWater) {
                logger.trace("Object {} @ {},{},{} potentially placeable under or on water or lava", new Object[]{object.getName(), x, y, z});
                return random.nextBoolean() ? WPObjectExporter.Placement.ON_LAND : WPObjectExporter.Placement.FLOATING;
            }
            if (lava ? spawnUnderLava : spawnUnderWater) {
                logger.trace("Object {} @ {},{},{} potentially placeable under water or lava", new Object[]{object.getName(), x, y, z});
                return WPObjectExporter.Placement.ON_LAND;
            }
            if (lava ? spawnOnLava : spawnOnWater) {
                logger.trace("Object {} @ {},{},{} potentially placeable on water or lava", new Object[]{object.getName(), x, y, z});
                return WPObjectExporter.Placement.FLOATING;
            }
        } else if (!flooded) {
            Material materialUnderCoords;
            Material material = materialUnderCoords = z > minecraftWorld.getMinHeight() ? minecraftWorld.getMaterialAt(x, y, z - 1) : Material.AIR;
            if (object.getAttribute(WPObject.ATTRIBUTE_SPAWN_ON_LAND).booleanValue() && !materialUnderCoords.veryInsubstantial) {
                logger.trace("Object {} @ {},{},{} potentially placeable on land", new Object[]{object.getName(), x, y, z});
                return WPObjectExporter.Placement.ON_LAND;
            }
            if (!object.getAttribute(WPObject.ATTRIBUTE_NEEDS_FOUNDATION).booleanValue() && materialUnderCoords.veryInsubstantial) {
                logger.trace("Object {} @ {},{},{} potentially placeable in the air", new Object[]{object.getName(), x, y, z});
                return WPObjectExporter.Placement.ON_LAND;
            }
        }
        logger.trace("Object {} @ {},{},{} not placeable", new Object[]{object.getName(), x, y, z});
        return WPObjectExporter.Placement.NONE;
    }

    private void prepareForExport(WPObject object, Dimension dimension) {
        if (!this.preparedObjects.contains(object)) {
            object.prepareForExport(dimension);
            this.preparedObjects.add(object);
        }
    }
}

