/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Random;
import javax.swing.Action;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.renderers.LayerRenderer;
import org.pepsoft.worldpainter.layers.renderers.TransparentColourRenderer;

public abstract class CustomLayer
extends Layer
implements Cloneable {
    private int colour;
    private int biome = -1;
    private int version = 3;
    private boolean hide;
    private boolean export = true;
    private String palette = "Custom Layers";
    private Integer index = null;
    private transient BufferedImage icon;
    private transient LayerRenderer renderer;
    public static final String KEY_DIMENSION = "org.pepsoft.worldpainter.dimension";
    private static final int CURRENT_VERSION = 3;
    private static final Random ID_GENERATOR = new Random();
    private static final long serialVersionUID = 1L;

    public CustomLayer(String name, String description, Layer.DataSize dataSize, int priority, int colour) {
        super(CustomLayer.createId(name), name, description, dataSize, false, priority);
        this.colour = colour;
        this.renderer = new TransparentColourRenderer(colour);
    }

    public CustomLayer(String name, String description, Layer.DataSize dataSize, int priority, char mnemonic, int colour) {
        super(CustomLayer.createId(name), name, description, dataSize, false, priority, mnemonic);
        this.colour = colour;
        this.renderer = new TransparentColourRenderer(colour);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int colour) {
        if (colour != this.colour) {
            this.colour = colour;
            this.icon = null;
            this.renderer = new TransparentColourRenderer(colour);
        }
    }

    public int getBiome() {
        return this.biome;
    }

    public void setBiome(int biome) {
        this.biome = biome;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public String getPalette() {
        return this.palette;
    }

    public void setPalette(String palette) {
        this.palette = palette;
    }

    public boolean isExport() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setMinMaxHeight(int oldMinHeight, int newMinHeight, int oldMaxHeight, int newMaxHeight, HeightTransform transform) {
    }

    public String getType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public BufferedImage getIcon() {
        if (this.icon == null) {
            this.icon = this.createIcon();
        }
        return this.icon;
    }

    @Override
    public LayerRenderer getRenderer() {
        return this.renderer;
    }

    public List<Action> getActions() {
        return null;
    }

    public CustomLayer clone() {
        try {
            CustomLayer clone = (CustomLayer)super.clone();
            clone.id = CustomLayer.createId(this.getName());
            clone.hide = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private BufferedImage createIcon() {
        BufferedImage iconImage = new BufferedImage(16, 16, 2);
        for (int x = 1; x < 15; ++x) {
            for (int y = 1; y < 15; ++y) {
                if (x == 1 || x == 14 || y == 1 || y == 14) {
                    iconImage.setRGB(x, y, -16777216);
                    continue;
                }
                iconImage.setRGB(x, y, 0xFF000000 | this.colour);
            }
        }
        return iconImage;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.renderer = new TransparentColourRenderer(this.colour);
        if (this.version < 1) {
            this.biome = -1;
        }
        if (this.version < 2) {
            this.palette = "Custom Layers";
        }
        if (this.version < 3) {
            this.export = true;
        }
        this.version = 3;
    }

    private static String createId(String name) {
        return name + "." + Long.toHexString(ID_GENERATOR.nextLong());
    }
}

