/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.TileProvider;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.WPTileProvider;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.heightMaps.BitmapHeightMap;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.FrostExporter;
import org.pepsoft.worldpainter.layers.exporters.ResourcesExporter;
import org.pepsoft.worldpainter.themes.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeightMapImporter {
    private Platform platform = Configuration.getInstance().getDefaultPlatform();
    private HeightMap heightMap;
    private int worldLowLevel;
    private int worldWaterLevel = 62;
    private int worldHighLevel = 255;
    private int minHeight = 0;
    private int maxHeight = 256;
    private int maxZ;
    private double imageLowLevel;
    private double imageHighLevel = 255.0;
    private double voidBelowLevel;
    private TileFactory tileFactory;
    private Theme theme;
    private String name;
    private boolean onlyRaise;
    private boolean oneOnOne;
    private boolean highRes;
    private boolean mayBeScaled;
    private boolean useVoidBelow;
    private File imageFile;
    private double levelScale;
    private long minecraftSeed = 27594263L;
    private Rectangle extentInTiles;
    private static final Logger logger = LoggerFactory.getLogger(HeightMapImporter.class);

    public World2 importToNewWorld(Dimension.Anchor anchor, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        Dimension dimension;
        Rectangle extent = this.heightMap.getExtent();
        logger.info("Importing world from height map {} (size: {}x{})", new Object[]{this.name, extent.width, extent.height});
        this.calculateFlags();
        World2 world = new World2(this.platform, this.minecraftSeed, this.tileFactory);
        world.addHistoryEntry(5, this.imageFile);
        world.setName(this.name);
        if (anchor.equals(Dimension.Anchor.NORMAL_DETAIL)) {
            dimension = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        } else {
            HeightMapTileFactory dimensionTileFactory = anchor.role == Dimension.Role.MASTER ? new HeightMapTileFactory(this.tileFactory.getSeed(), ((HeightMapTileFactory)this.tileFactory).getHeightMap().scaled(0.0625f), this.tileFactory.getMinHeight(), this.tileFactory.getMaxHeight(), ((HeightMapTileFactory)this.tileFactory).isFloodWithLava(), ((HeightMapTileFactory)this.tileFactory).getTheme()) : new HeightMapTileFactory(this.tileFactory.getSeed(), ((HeightMapTileFactory)this.tileFactory).getHeightMap(), this.tileFactory.getMinHeight(), this.tileFactory.getMaxHeight(), ((HeightMapTileFactory)this.tileFactory).isFloodWithLava(), ((HeightMapTileFactory)this.tileFactory).getTheme());
            dimension = new Dimension(world, anchor.getDefaultName(), this.minecraftSeed, dimensionTileFactory, anchor);
            if (anchor.role == Dimension.Role.MASTER) {
                dimension.setScale(16.0f);
            }
            world.addDimension(dimension);
        }
        Configuration config = Configuration.getInstance();
        world.setCreateGoodiesChest(config.isDefaultCreateGoodiesChest());
        world.setMapFeatures(config.isDefaultMapFeatures());
        world.setGameType(config.getDefaultGameType());
        world.setAllowCheats(config.isDefaultAllowCheats());
        if (!this.highRes) {
            FrostExporter.FrostSettings frostSettings = new FrostExporter.FrostSettings();
            frostSettings.setMode(0);
            dimension.setLayerSettings(Frost.INSTANCE, frostSettings);
        }
        this.importToDimension(dimension, true, progressReceiver);
        MapGenerator generator = config.getDefaultGenerator();
        dimension.setGenerator(generator);
        Dimension defaults = config.getDefaultTerrainAndLayerSettings();
        dimension.setBorder(defaults.getBorder());
        dimension.setBorderSize(defaults.getBorderSize());
        dimension.setBorderLevel(this.worldWaterLevel);
        dimension.setWallType(defaults.getWallType());
        dimension.setRoofType(defaults.getRoofType());
        dimension.setSubsurfaceMaterial(defaults.getSubsurfaceMaterial());
        dimension.setPopulate(defaults.isPopulate());
        dimension.setTopLayerMinDepth(defaults.getTopLayerMinDepth());
        dimension.setTopLayerVariation(defaults.getTopLayerVariation());
        dimension.setBottomless(defaults.isBottomless());
        for (Map.Entry<Layer, ExporterSettings> entry : defaults.getAllLayerSettings().entrySet()) {
            dimension.setLayerSettings(entry.getKey(), entry.getValue().clone());
        }
        ((ResourcesExporter.ResourcesExporterSettings)dimension.getLayerSettings(Resources.INSTANCE)).setMinimumLevel(config.getDefaultResourcesMinimumLevel());
        dimension.setGridEnabled(config.isDefaultGridEnabled());
        dimension.setGridSize(config.getDefaultGridSize());
        dimension.setContoursEnabled(config.isDefaultContoursEnabled());
        dimension.setContourSeparation(config.getDefaultContourSeparation());
        world.setSpawnPoint(new Point(extent.x + extent.width / 2, extent.y + extent.height / 2));
        dimension.setLastViewPosition(world.getSpawnPoint());
        return world;
    }

    /*
     * Unable to fully structure code
     */
    public void importToDimension(Dimension dimension, boolean createTiles, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        if (dimension.getMinHeight() != this.minHeight) {
            throw new IllegalArgumentException(String.format("Dimension has different minHeight (%d) than configured (%d)", new Object[]{dimension.getMinHeight(), this.minHeight}));
        }
        if (dimension.getMaxHeight() != this.maxHeight) {
            throw new IllegalArgumentException(String.format("Dimension has different maxHeight (%d) than configured (%d)", new Object[]{dimension.getMaxHeight(), this.maxHeight}));
        }
        if (dimension.getWorld() != null) {
            dimension.getWorld().addHistoryEntry(21, new Serializable[]{dimension.getName(), this.imageFile});
        }
        extent = this.heightMap.getExtent();
        x1 = extent.x;
        x2 = extent.x + extent.width - 1;
        y1 = extent.y;
        y2 = extent.y + extent.height - 1;
        this.calculateFlags();
        tileX1 = this.extentInTiles.x;
        tileY1 = this.extentInTiles.y;
        tileX2 = this.extentInTiles.x + this.extentInTiles.width - 1;
        tileY2 = this.extentInTiles.y + this.extentInTiles.height - 1;
        totalTileCount = this.extentInTiles.width * this.extentInTiles.height;
        floor = Math.max(this.worldWaterLevel - 20, this.minHeight);
        variation = Math.min(15, (this.worldWaterLevel - floor) / 2);
        noiseGenerator = new PerlinNoise(0L);
        noiseGenerator.setSeed(dimension.getSeed());
        tileCount = 0;
        for (tileX = tileX1; tileX <= tileX2; ++tileX) {
            for (tileY = tileY1; tileY <= tileY2; ++tileY) {
                tile = dimension.getTileForEditing(tileX, tileY);
                if (tile != null) ** GOTO lbl35
                if (createTiles) {
                    tile = this.tileFactory.createTile(tileX, tileY);
                    tileIsNew = true;
                } else {
                    ++tileCount;
                    if (progressReceiver == null) continue;
                    progressReceiver.setProgress((float)tileCount / (float)totalTileCount);
                    continue;
lbl35:
                    // 1 sources

                    tileIsNew = false;
                    tile.inhibitEvents();
                }
                xOffset = tileX << 7;
                yOffset = tileY << 7;
                for (x = 0; x < 128; ++x) {
                    for (y = 0; y < 128; ++y) {
                        imageX = xOffset + x;
                        imageY = yOffset + y;
                        if (imageX >= x1 && imageX <= x2 && imageY >= y1 && imageY <= y2) {
                            imageLevel = this.heightMap.getHeight(imageX, imageY);
                            height = this.calculateHeight(imageLevel);
                            if (this.onlyRaise && !tileIsNew) {
                                if (!(height > tile.getHeight(x, y))) continue;
                                tile.setHeight(x, y, height);
                                if (this.theme == null) continue;
                                this.theme.apply(tile, x, y);
                                continue;
                            }
                            tile.setHeight(x, y, height);
                            tile.setWaterLevel(x, y, this.worldWaterLevel);
                            if (this.useVoidBelow && imageLevel <= this.voidBelowLevel) {
                                tile.setBitLayerValue(Void.INSTANCE, x, y, true);
                            }
                            if (this.theme == null) continue;
                            this.theme.apply(tile, x, y);
                            continue;
                        }
                        if (!tileIsNew) continue;
                        tile.setHeight(x, y, (float)floor + (noiseGenerator.getPerlinNoise((double)((float)imageX / 32.771f), (double)((float)imageY / 32.771f)) + 0.5f) * (float)variation);
                        tile.setTerrain(x, y, Terrain.BEACHES);
                        tile.setWaterLevel(x, y, this.worldWaterLevel);
                        if (!this.useVoidBelow) continue;
                        tile.setBitLayerValue(Void.INSTANCE, x, y, true);
                    }
                }
                if (tileIsNew) {
                    dimension.addTile(tile);
                } else {
                    tile.releaseEvents();
                }
                ++tileCount;
                if (progressReceiver == null) continue;
                progressReceiver.setProgress((float)tileCount / (float)totalTileCount);
            }
        }
    }

    public TileProvider getPreviewProvider(Dimension targetDimension, ColourScheme colourScheme, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin) {
        if (this.tileFactory instanceof HeightMapTileFactory) {
            this.calculateFlags();
            HeightMap previewHeightMap = this.highRes ? this.heightMap.minus(this.imageLowLevel).times(this.levelScale).plus(this.worldLowLevel) : (this.oneOnOne ? (this.mayBeScaled ? this.heightMap : this.heightMap.minus(0.4375)) : this.heightMap.minus(this.imageLowLevel).times(this.levelScale).plus(this.worldLowLevel));
            HeightMapTileFactory heightMapTileFactory = (HeightMapTileFactory)this.tileFactory;
            Theme theme = (this.theme != null ? this.theme : heightMapTileFactory.getTheme()).clone();
            theme.setWaterHeight(this.worldWaterLevel);
            PreviewTileFactory tileFactory = new PreviewTileFactory(1L, previewHeightMap, targetDimension, this.minHeight, this.maxHeight, heightMapTileFactory.isFloodWithLava(), theme, this.heightMap, this.useVoidBelow, this.voidBelowLevel, this.theme == null);
            return new WPTileProvider(tileFactory, colourScheme, null, null, contourLines, contourSeparation, lightOrigin, null);
        }
        return null;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public HeightMap getHeightMap() {
        return this.heightMap;
    }

    public void setHeightMap(HeightMap heightMap) {
        if (heightMap != null && heightMap.getExtent() == null) {
            throw new IllegalArgumentException("Height map must have an extent");
        }
        this.heightMap = heightMap;
    }

    public int getWorldLowLevel() {
        return this.worldLowLevel;
    }

    public void setWorldLowLevel(int worldLowLevel) {
        this.worldLowLevel = worldLowLevel;
    }

    public int getWorldWaterLevel() {
        return this.worldWaterLevel;
    }

    public void setWorldWaterLevel(int worldWaterLevel) {
        this.worldWaterLevel = worldWaterLevel;
    }

    public int getWorldHighLevel() {
        return this.worldHighLevel;
    }

    public void setWorldHighLevel(int worldHighLevel) {
        this.worldHighLevel = worldHighLevel;
    }

    public double getImageLowLevel() {
        return this.imageLowLevel;
    }

    public void setImageLowLevel(double imageLowLevel) {
        this.imageLowLevel = imageLowLevel;
    }

    public double getImageHighLevel() {
        return this.imageHighLevel;
    }

    public void setImageHighLevel(double imageHighLevel) {
        this.imageHighLevel = imageHighLevel;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public boolean isVoidBelow() {
        return this.useVoidBelow;
    }

    public void setVoidBelow(boolean voidBelow) {
        this.useVoidBelow = voidBelow;
    }

    public double getVoidBelowLevel() {
        return this.voidBelowLevel;
    }

    public void setVoidBelowLevel(double voidBelowLevel) {
        this.voidBelowLevel = voidBelowLevel;
    }

    public TileFactory getTileFactory() {
        return this.tileFactory;
    }

    public void setTileFactory(TileFactory tileFactory) {
        this.tileFactory = tileFactory;
        if (tileFactory instanceof HeightMapTileFactory && this.theme == null) {
            this.setTheme(((HeightMapTileFactory)tileFactory).getTheme());
        }
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }

    public boolean isOnlyRaise() {
        return this.onlyRaise;
    }

    public void setOnlyRaise(boolean onlyRaise) {
        this.onlyRaise = onlyRaise;
    }

    public long getMinecraftSeed() {
        return this.minecraftSeed;
    }

    public void setMinecraftSeed(long minecraftSeed) {
        this.minecraftSeed = minecraftSeed;
    }

    private void calculateFlags() {
        this.mayBeScaled = !(this.heightMap instanceof BitmapHeightMap) && (!(this.heightMap instanceof TransformingHeightMap) || ((TransformingHeightMap)this.heightMap).getScaleX() != 1.0f || ((TransformingHeightMap)this.heightMap).getScaleY() != 1.0f || !(((TransformingHeightMap)this.heightMap).getBaseHeightMap() instanceof BitmapHeightMap));
        this.oneOnOne = (double)this.worldLowLevel == this.imageLowLevel && (double)this.worldHighLevel == this.imageHighLevel;
        this.highRes = this.imageHighLevel >= (double)this.maxHeight && this.worldHighLevel < this.maxHeight;
        this.levelScale = (double)(this.worldHighLevel - this.worldLowLevel) / (this.imageHighLevel - this.imageLowLevel);
        this.maxZ = this.maxHeight - 1;
        Rectangle extent = this.heightMap.getExtent();
        int tileX1 = extent.x >> 7;
        int tileY1 = extent.y >> 7;
        int tileX2 = extent.x + extent.width - 1 >> 7;
        int tileY2 = extent.y + extent.height - 1 >> 7;
        this.extentInTiles = new Rectangle(tileX1, tileY1, tileX2 - tileX1 + 1, tileY2 - tileY1 + 1);
    }

    private float calculateHeight(double imageLevel) {
        if (this.highRes) {
            return MathUtils.clamp((float)this.minHeight, (float)((float)((imageLevel - this.imageLowLevel) * this.levelScale + (double)this.worldLowLevel)), (float)this.maxZ);
        }
        return MathUtils.clamp((float)this.minHeight, (float)((float)(this.oneOnOne ? (this.mayBeScaled ? imageLevel : imageLevel - 0.4375) : (imageLevel - this.imageLowLevel) * this.levelScale + (double)this.worldLowLevel)), (float)this.maxZ);
    }

    private static class PreviewTileFactory
    extends HeightMapTileFactory {
        private final HeightMap imageHeightMap;
        private final boolean useVoidBelow;
        private final boolean leaveTerrain;
        private final double voidBelowLevel;
        private final Dimension targetDimension;

        private PreviewTileFactory(long seed, HeightMap heightMap, Dimension targetDimension, int minHeight, int maxHeight, boolean floodWithLava, Theme theme, HeightMap imageHeightMap, boolean voidBelow, double voidBelowLevel, boolean leaveTerrain) {
            super(seed, heightMap, minHeight, maxHeight, floodWithLava, theme);
            this.targetDimension = targetDimension;
            this.imageHeightMap = imageHeightMap;
            this.useVoidBelow = voidBelow;
            this.voidBelowLevel = voidBelowLevel;
            this.leaveTerrain = leaveTerrain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tile createTile(int tileX, int tileY) {
            Tile targetTile;
            Tile tile = super.createTile(tileX, tileY);
            if (this.targetDimension != null && (targetTile = this.targetDimension.getTile(tileX, tileY)) != null) {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        float targetHeight = targetTile.getHeight(x, y);
                        if (targetHeight >= tile.getHeight(x, y)) {
                            tile.setHeight(x, y, targetHeight);
                            tile.setWaterLevel(x, y, targetTile.getWaterLevel(x, y));
                            tile.setBitLayerValue(FloodWithLava.INSTANCE, x, y, targetTile.getBitLayerValue(FloodWithLava.INSTANCE, x, y));
                            tile.setTerrain(x, y, targetTile.getTerrain(x, y));
                            continue;
                        }
                        if (!this.leaveTerrain) continue;
                        tile.setTerrain(x, y, targetTile.getTerrain(x, y));
                    }
                }
            }
            if (this.useVoidBelow) {
                int worldTileX = tileX * 128;
                int worldTileY = tileY * 128;
                tile.inhibitEvents();
                try {
                    for (int x = 0; x < 128; ++x) {
                        for (int y = 0; y < 128; ++y) {
                            int blockX = worldTileX + x;
                            int blockY = worldTileY + y;
                            if (!(this.imageHeightMap.getHeight(blockX, blockY) <= this.voidBelowLevel)) continue;
                            tile.setBitLayerValue(Void.INSTANCE, x, y, true);
                        }
                    }
                }
                finally {
                    tile.releaseEvents();
                }
            }
            return tile;
        }
    }
}

