/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.history;

import java.io.Serializable;
import java.text.MessageFormat;
import org.pepsoft.worldpainter.Version;

public class HistoryEntry
implements Serializable {
    public final int key;
    public final long timestamp;
    public final String wpVersion = Version.VERSION;
    public final String wpBuild = Version.BUILD;
    public final String userId = System.getProperty("user.name");
    public final Serializable[] args;
    public static final int WORLD_LEGACY_PRE_0_2 = 1;
    public static final int WORLD_LEGACY_PRE_2_0_0 = 2;
    public static final int WORLD_CREATED = 3;
    public static final int WORLD_IMPORTED_FROM_MINECRAFT_MAP = 4;
    public static final int WORLD_IMPORTED_FROM_HEIGHT_MAP = 5;
    public static final int WORLD_RECOVERED = 6;
    public static final int WORLD_LOADED = 7;
    public static final int WORLD_SAVED = 8;
    public static final int WORLD_EXPORTED_FULL = 9;
    public static final int WORLD_EXPORTED_PARTIAL = 10;
    public static final int WORLD_MERGED_FULL = 11;
    public static final int WORLD_MERGED_PARTIAL = 12;
    public static final int WORLD_DIMENSION_ADDED = 13;
    public static final int WORLD_DIMENSION_REMOVED = 14;
    public static final int WORLD_TILES_ADDED = 15;
    public static final int WORLD_TILES_REMOVED = 16;
    public static final int WORLD_DIMENSION_SHIFTED_HORIZONTALLY = 17;
    public static final int WORLD_DIMENSION_SHIFTED_VERTICALLY = 18;
    public static final int WORLD_DIMENSION_ROTATED = 19;
    public static final int WORLD_MAX_HEIGHT_CHANGED = 20;
    public static final int WORLD_HEIGHT_MAP_IMPORTED_TO_DIMENSION = 21;
    public static final int WORLD_MASK_IMPORTED_TO_DIMENSION = 22;
    public static final int WORLD_RECOVERED_FROM_AUTOSAVE = 23;
    public static final int WORLD_MIN_HEIGHT_CHANGED = 24;
    public static final int WORLD_RETARGETED = 25;
    public static final int WORLD_DIMENSION_SCALED = 26;
    private static final long serialVersionUID = 1L;

    public HistoryEntry(int key, Serializable ... args) {
        this.key = key;
        this.timestamp = System.currentTimeMillis();
        this.args = args.length > 0 ? args : null;
    }

    public String getText() {
        switch (this.key) {
            case 1: {
                return "World created with WorldPainter older than 0.2";
            }
            case 2: {
                return "World created with WorldPainter older than 2.0.0";
            }
            case 3: {
                return MessageFormat.format("World created with WorldPainter {0}", this.wpVersion);
            }
            case 4: {
                return MessageFormat.format("World imported from Minecraft map {0} at {1} with WorldPainter {2}", this.args[0], this.args[1], this.wpVersion);
            }
            case 5: {
                return MessageFormat.format("World imported from height map {0} with WorldPainter {1}", this.args[0], this.wpVersion);
            }
            case 6: {
                return MessageFormat.format("World recovered from corrupted file with WorldPainter {0}", this.wpVersion);
            }
            case 7: {
                return MessageFormat.format("World loaded from file {0}", this.args[0]);
            }
            case 8: {
                return MessageFormat.format("World saved to file {0}", this.args[0]);
            }
            case 9: {
                return MessageFormat.format("World fully exported as Minecraft map named {0} at {1} with WorldPainter {2}", this.args[0], this.args[1], this.wpVersion);
            }
            case 10: {
                return MessageFormat.format("World partially exported as Minecraft map named {0} at {1} with WorldPainter {2}", this.args[0], this.args[1], this.wpVersion);
            }
            case 11: {
                return MessageFormat.format("World fully merged with Minecraft map named {0} at {1} with WorldPainter {2}", this.args[0], this.args[1], this.wpVersion);
            }
            case 12: {
                return MessageFormat.format("World partially merged with Minecraft map named {0} at {1} with WorldPainter {2}", this.args[0], this.args[1], this.wpVersion);
            }
            case 13: {
                return MessageFormat.format("Dimension {0} added to world", this.args[0]);
            }
            case 14: {
                return MessageFormat.format("Dimension {0} removed from world", this.args[0]);
            }
            case 15: {
                return MessageFormat.format("{0} tiles added to dimension {1}", this.args[1], this.args[0]);
            }
            case 16: {
                return MessageFormat.format("{0} tiles removed from dimension {1}", this.args[1], this.args[0]);
            }
            case 17: {
                return MessageFormat.format("Dimension {0} shifted {1} blocks east and {2} blocks south", this.args[0], this.args[1], this.args[2]);
            }
            case 18: {
                return MessageFormat.format("Dimension {0} shifted {1} blocks up", this.args[0], this.args[1]);
            }
            case 19: {
                return MessageFormat.format("Dimension {0} rotated {1} degrees", this.args[0], this.args[1]);
            }
            case 24: {
                return MessageFormat.format("Minimum height of world changed to {0}", this.args[0]);
            }
            case 20: {
                return MessageFormat.format("Maximum height of world changed to {0}", this.args[0]);
            }
            case 21: {
                return MessageFormat.format("Height map {1} imported into dimension {0}", this.args[0], this.args[1]);
            }
            case 22: {
                return MessageFormat.format("Mask {1} imported into dimension {0} as layer {2}", this.args[0], this.args[1], this.args[2]);
            }
            case 23: {
                return MessageFormat.format("World recovered from autosave with WorldPainter {0}", this.wpVersion);
            }
            case 25: {
                return MessageFormat.format("World retargeted from map format {0} to {1}", this.args[0], this.args[1]);
            }
            case 26: {
                return MessageFormat.format("Dimension {0} scaled by {1}%", this.args[0], this.args[1]);
            }
        }
        return MessageFormat.format("Unknown event ID {0} by WorldPainter {0} ({1})", this.key, this.wpVersion, this.wpBuild);
    }
}

