/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.CombiningHeightMap;

public final class SumHeightMap
extends CombiningHeightMap {
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_SUM_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/plus.png");

    public SumHeightMap(HeightMap heightMap1, HeightMap heightMap2) {
        super(heightMap1, heightMap2);
    }

    public SumHeightMap(String name, HeightMap heightMap1, HeightMap heightMap2) {
        super(name, heightMap1, heightMap2);
    }

    @Override
    protected double doGetHeight(int x, int y) {
        return this.children[0].getHeight(x, y) + this.children[1].getHeight(x, y);
    }

    @Override
    protected double doGetHeight(float x, float y) {
        return this.children[0].getHeight(x, y) + this.children[1].getHeight(x, y);
    }

    @Override
    public SumHeightMap clone() {
        SumHeightMap clone = new SumHeightMap(this.name, this.children[0].clone(), this.children[1].clone());
        clone.setSeed(this.getSeed());
        return clone;
    }

    @Override
    public Icon getIcon() {
        return ICON_SUM_HEIGHTMAP;
    }

    @Override
    protected Object readResolve() throws ObjectStreamException {
        if (this.heightMap1 != null) {
            return new SumHeightMap(this.heightMap1, this.heightMap2);
        }
        return super.readResolve();
    }

    @Override
    public double[] getRange() {
        double[] range0 = this.children[0].getRange();
        double[] range1 = this.children[1].getRange();
        return new double[]{range0[0] + range1[0], range0[1] + range1[1]};
    }
}

