/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import javax.swing.Icon;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;

public class MandelbrotHeightMap
extends AbstractHeightMap {
    private static final int MAX_ITERATIONS = 255;
    private static final double[] RANGE = new double[]{0.0, 255.0};
    private static final long serialVersionUID = 1L;

    @Override
    public double getHeight(float x0, float y0) {
        int iteration;
        float x = 0.0f;
        float y = 0.0f;
        for (iteration = 0; x * x + y * y < 4.0f && iteration < 255; ++iteration) {
            float xtemp = x * x - y * y + x0;
            y = 2.0f * x * y + y0;
            x = xtemp;
        }
        return iteration;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public double[] getRange() {
        return RANGE;
    }
}

