/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.awt.Rectangle;
import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;

public class DisplacementHeightMap
extends DelegatingHeightMap {
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_DISPLACEMENT_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/displacement.png");

    public DisplacementHeightMap(HeightMap baseHeightMap, HeightMap angleMap, HeightMap distanceMap) {
        super("baseHeightMap", "angleMap", "distanceMap");
        this.setHeightMap(0, baseHeightMap);
        this.setHeightMap(1, angleMap);
        this.setHeightMap(2, distanceMap);
    }

    public DisplacementHeightMap(String name, HeightMap baseHeightMap, HeightMap angleMap, HeightMap distanceMap) {
        super("baseHeightMap", "angleMap", "distanceMap");
        this.setName(name);
        this.setHeightMap(0, baseHeightMap);
        this.setHeightMap(1, angleMap);
        this.setHeightMap(2, distanceMap);
    }

    public HeightMap getBaseHeightMap() {
        return this.children[0];
    }

    public HeightMap getAngleMap() {
        return this.children[1];
    }

    public HeightMap getDistanceMap() {
        return this.children[2];
    }

    public void setAngleMap(HeightMap angleMap) {
        this.replace(1, angleMap);
    }

    public void setBaseHeightMap(HeightMap baseHeightMap) {
        this.replace(0, baseHeightMap);
    }

    public void setDistanceMap(HeightMap distanceMap) {
        this.replace(2, distanceMap);
    }

    @Override
    protected double doGetHeight(float x, float y) {
        double angle = this.children[1].getHeight(x, y);
        double distance = this.children[2].getHeight(x, y);
        float actualX = (float)((double)x + Math.sin(angle) * distance);
        float actualY = (float)((double)y + Math.cos(angle) * distance);
        return this.children[0].getHeight(actualX, actualY);
    }

    @Override
    public Rectangle getExtent() {
        return this.children[0].getExtent();
    }

    @Override
    protected int doGetColour(int x, int y) {
        double angle = this.children[1].getHeight(x, y);
        double distance = this.children[2].getHeight(x, y);
        double actualX = (double)x + Math.sin(angle) * distance;
        double actualY = (double)y + Math.cos(angle) * distance;
        return this.children[0].getColour((int)Math.round(actualX), (int)Math.round(actualY));
    }

    @Override
    public Icon getIcon() {
        return ICON_DISPLACEMENT_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        return this.children[0].getRange();
    }

    @Override
    public DisplacementHeightMap clone() {
        DisplacementHeightMap clone = new DisplacementHeightMap(this.name, this.children[0].clone(), this.children[1].clone(), this.children[2].clone());
        clone.setSeed(this.getSeed());
        return clone;
    }
}

