/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.CombiningHeightMap;

public class DifferenceHeightMap
extends CombiningHeightMap {
    private static final long serialVersionUID = -3655960245610539242L;
    private static final Icon ICON_DIFFERENCE_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/minus.png");

    public DifferenceHeightMap(HeightMap heightMap1, HeightMap heightMap2) {
        super(heightMap1, heightMap2);
    }

    public DifferenceHeightMap(String name, HeightMap heightMap1, HeightMap heightMap2) {
        super(name, heightMap1, heightMap2);
    }

    @Override
    protected double doGetHeight(int x, int y) {
        return this.children[0].getHeight(x, y) - this.children[1].getHeight(x, y);
    }

    @Override
    protected double doGetHeight(float x, float y) {
        return this.children[0].getHeight(x, y) - this.children[1].getHeight(x, y);
    }

    @Override
    public Icon getIcon() {
        return ICON_DIFFERENCE_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        double[] range0 = this.children[0].getRange();
        double[] range1 = this.children[1].getRange();
        return new double[]{range0[0] - range1[0], range0[1] - range1[1]};
    }

    @Override
    public CombiningHeightMap clone() {
        DifferenceHeightMap clone = new DifferenceHeightMap(this.name, this.children[0].clone(), this.children[1].clone());
        clone.setSeed(this.seed);
        return clone;
    }
}

