/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;

public final class BitmapHeightMap
extends AbstractHeightMap {
    private final BufferedImage image;
    private final int channel;
    private final int width;
    private final int height;
    private final int bitDepth;
    private final Raster raster;
    private final Rectangle extent;
    private final File imageFile;
    private final boolean repeat;
    private final boolean smoothScaling;
    private final boolean floatingPoint;
    private final boolean hasAlpha;
    private final boolean signed;
    private final double minHeight;
    private final double maxHeight;
    private double[] range;
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_BITMAP_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/height_map.png");

    private BitmapHeightMap(String name, BufferedImage image, int channel, File imageFile, boolean repeat, boolean smoothScaling) {
        super(name);
        this.image = image;
        this.channel = channel;
        this.imageFile = imageFile;
        this.repeat = repeat;
        this.smoothScaling = smoothScaling;
        this.raster = image.getRaster();
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.extent = repeat ? null : new Rectangle(0, 0, this.width, this.height);
        this.bitDepth = this.raster.getSampleModel().getSampleSize(0);
        int transferType = this.raster.getTransferType();
        switch (transferType) {
            case 4: {
                this.minHeight = -3.4028234663852886E38;
                this.maxHeight = 3.4028234663852886E38;
                this.floatingPoint = true;
                this.signed = true;
                break;
            }
            case 5: {
                this.minHeight = -1.7976931348623157E308;
                this.maxHeight = Double.MAX_VALUE;
                this.floatingPoint = true;
                this.signed = true;
                break;
            }
            case 2: {
                this.minHeight = -(1L << this.bitDepth - 1);
                this.maxHeight = (1L << this.bitDepth - 1) - 1L;
                this.floatingPoint = false;
                this.signed = true;
                break;
            }
            default: {
                this.minHeight = 0.0;
                this.maxHeight = (1L << this.bitDepth) - 1L;
                this.floatingPoint = false;
                this.signed = false;
            }
        }
        this.hasAlpha = image.getColorModel().hasAlpha();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean isSmoothScaling() {
        return this.smoothScaling;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public boolean isFloatingPoint() {
        return this.floatingPoint;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public boolean isSigned() {
        return this.signed;
    }

    @Override
    public double getHeight(int x, int y) {
        if (this.repeat) {
            return this.getSample(MathUtils.mod((int)x, (int)this.width), MathUtils.mod((int)y, (int)this.height));
        }
        if (this.extent.contains(x, y)) {
            return this.getSample(x, y);
        }
        return this.minHeight;
    }

    @Override
    public double getHeight(float x, float y) {
        if (!this.smoothScaling) {
            return this.getHeight((int)x, (int)y);
        }
        x -= Math.signum(x) / 2.0f;
        y -= Math.signum(y) / 2.0f;
        int xFloor = (int)Math.floor(x);
        int yFloor = (int)Math.floor(y);
        float xDelta = x - (float)xFloor;
        float yDelta = y - (float)yFloor;
        double val1 = this.cubicInterpolate(this.getExtHeight(xFloor - 1, yFloor - 1), this.getExtHeight(xFloor - 1, yFloor), this.getExtHeight(xFloor - 1, yFloor + 1), this.getExtHeight(xFloor - 1, yFloor + 2), yDelta);
        double val2 = this.cubicInterpolate(this.getExtHeight(xFloor, yFloor - 1), this.getExtHeight(xFloor, yFloor), this.getExtHeight(xFloor, yFloor + 1), this.getExtHeight(xFloor, yFloor + 2), yDelta);
        double val3 = this.cubicInterpolate(this.getExtHeight(xFloor + 1, yFloor - 1), this.getExtHeight(xFloor + 1, yFloor), this.getExtHeight(xFloor + 1, yFloor + 1), this.getExtHeight(xFloor + 1, yFloor + 2), yDelta);
        double val4 = this.cubicInterpolate(this.getExtHeight(xFloor + 2, yFloor - 1), this.getExtHeight(xFloor + 2, yFloor), this.getExtHeight(xFloor + 2, yFloor + 1), this.getExtHeight(xFloor + 2, yFloor + 2), yDelta);
        return this.cubicInterpolate(val1, val2, val3, val4, xDelta);
    }

    private double getExtHeight(int x, int y) {
        if (this.repeat) {
            return this.getSample(MathUtils.mod((int)x, (int)this.width), MathUtils.mod((int)y, (int)this.height));
        }
        if (this.extent.contains(x, y)) {
            return this.getSample(x, y);
        }
        if (x < 0) {
            if (y < 0) {
                return this.getSample(0, 0);
            }
            if (y < this.height) {
                return this.getSample(0, y);
            }
            return this.getSample(0, this.height - 1);
        }
        if (x < this.width) {
            if (y < 0) {
                return this.getSample(x, 0);
            }
            return this.getSample(x, this.height - 1);
        }
        if (y < 0) {
            return this.getSample(this.width - 1, 0);
        }
        if (y < this.height) {
            return this.getSample(this.width - 1, y);
        }
        return this.getSample(this.width - 1, this.height - 1);
    }

    @Override
    public Rectangle getExtent() {
        return this.extent;
    }

    @Override
    public int getColour(int x, int y) {
        if (this.repeat) {
            return this.image.getRGB(MathUtils.mod((int)x, (int)this.width), MathUtils.mod((int)y, (int)this.height));
        }
        if (this.extent.contains(x, y)) {
            return this.image.getRGB(x, y);
        }
        return 0;
    }

    @Override
    public Icon getIcon() {
        return ICON_BITMAP_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        if (this.range == null) {
            double imageLowValue = Double.MAX_VALUE;
            double imageHighValue = -1.7976931348623157E308;
            block0: for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    double value = this.getSample(x, y);
                    if (value < imageLowValue) {
                        imageLowValue = value;
                    }
                    if (value > imageHighValue) {
                        imageHighValue = value;
                    }
                    if (imageLowValue <= this.minHeight && imageHighValue >= this.maxHeight) break block0;
                }
            }
            this.range = new double[]{imageLowValue, imageHighValue};
        }
        return this.range;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public static BitmapHeightMapBuilder build() {
        return new BitmapHeightMapBuilder();
    }

    private double cubicInterpolate(double y0, double y1, double y2, double y3, float \u03bc) {
        return y1 + 0.5 * (double)\u03bc * (y2 - y0 + (double)\u03bc * (2.0 * y0 - 5.0 * y1 + 4.0 * y2 - y3 + (double)\u03bc * (3.0 * (y1 - y2) + y3 - y0)));
    }

    private double getSample(int x, int y) {
        if (this.floatingPoint) {
            return this.raster.getSampleDouble(x, y, this.channel);
        }
        return this.signed ? (double)this.raster.getSample(x, y, this.channel) : (double)((long)this.raster.getSample(x, y, this.channel) & 0xFFFFFFFFL);
    }

    public static class BitmapHeightMapBuilder {
        private String name;
        private BufferedImage image;
        private int channel;
        private File file;
        private boolean repeat;
        private boolean smoothScaling;

        public BitmapHeightMapBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public BitmapHeightMapBuilder withChannel(int channel) {
            this.channel = channel;
            return this;
        }

        public BitmapHeightMapBuilder withImage(BufferedImage image) {
            this.image = image;
            return this;
        }

        public BitmapHeightMapBuilder withFile(File file) {
            this.file = file;
            return this;
        }

        public BitmapHeightMapBuilder withRepeat(boolean repeat) {
            this.repeat = repeat;
            return this;
        }

        public BitmapHeightMapBuilder withSmoothScaling(boolean smoothScaling) {
            this.smoothScaling = smoothScaling;
            return this;
        }

        public BitmapHeightMap now() {
            return new BitmapHeightMap(this.name, this.image, this.channel, this.file, this.repeat, this.smoothScaling);
        }
    }
}

