/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.awt.Rectangle;
import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;

public class BicubicHeightMap
extends DelegatingHeightMap {
    private final int width;
    private final int height;
    private final Rectangle extent;
    private final boolean repeat;
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_BITMAP_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/height_map.png");

    public BicubicHeightMap(HeightMap baseHeightMap) {
        this(baseHeightMap, false);
    }

    public BicubicHeightMap(HeightMap baseHeightMap, boolean repeat) {
        super(new String[]{"baseHeightMap"});
        this.repeat = repeat;
        this.extent = baseHeightMap.getExtent();
        if (this.extent != null && (this.extent.x != 0 || this.extent.y != 0)) {
            throw new IllegalArgumentException("Only extents with the origin at zero are currently supported");
        }
        this.width = this.extent != null ? this.extent.width : -1;
        int n = this.height = this.extent != null ? this.extent.height : -1;
        if (repeat && this.extent == null) {
            throw new IllegalArgumentException("Base height map must have an extent if it is to be repeated");
        }
        this.setHeightMap(0, baseHeightMap);
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    @Override
    protected double doGetHeight(int x, int y) {
        if (this.repeat) {
            return this.children[0].getHeight(MathUtils.mod((int)x, (int)this.width), MathUtils.mod((int)y, (int)this.height));
        }
        return this.children[0].getHeight(x, y);
    }

    @Override
    protected double doGetHeight(float x, float y) {
        x -= Math.signum(x) / 2.0f;
        y -= Math.signum(y) / 2.0f;
        int xFloor = (int)Math.floor(x);
        int yFloor = (int)Math.floor(y);
        float xDelta = x - (float)xFloor;
        float yDelta = y - (float)yFloor;
        double upperLeftValue = this.getExtHeight(xFloor, yFloor);
        double upperRightValue = this.getExtHeight(xFloor, yFloor + 1);
        double lowerLeftValue = this.getExtHeight(xFloor + 1, yFloor);
        double lowerRightValue = this.getExtHeight(xFloor + 1, yFloor + 1);
        double min = Math.min(Math.min(upperLeftValue, upperRightValue), Math.min(lowerLeftValue, lowerRightValue));
        double max = Math.max(Math.max(upperLeftValue, upperRightValue), Math.max(lowerLeftValue, lowerRightValue));
        double val1 = this.cubicInterpolate(this.getExtHeight(xFloor - 1, yFloor - 1), this.getExtHeight(xFloor - 1, yFloor), this.getExtHeight(xFloor - 1, yFloor + 1), this.getExtHeight(xFloor - 1, yFloor + 2), yDelta);
        double val2 = this.cubicInterpolate(this.getExtHeight(xFloor, yFloor - 1), upperLeftValue, upperRightValue, this.getExtHeight(xFloor, yFloor + 2), yDelta);
        double val3 = this.cubicInterpolate(this.getExtHeight(xFloor + 1, yFloor - 1), lowerLeftValue, lowerRightValue, this.getExtHeight(xFloor + 1, yFloor + 2), yDelta);
        double val4 = this.cubicInterpolate(this.getExtHeight(xFloor + 2, yFloor - 1), this.getExtHeight(xFloor + 2, yFloor), this.getExtHeight(xFloor + 2, yFloor + 1), this.getExtHeight(xFloor + 2, yFloor + 2), yDelta);
        return MathUtils.clamp((double)min, (double)this.cubicInterpolate(val1, val2, val3, val4, xDelta), (double)max);
    }

    private double getExtHeight(float x, float y) {
        if (this.repeat) {
            return this.children[0].getHeight(MathUtils.mod((float)x, (float)this.width), MathUtils.mod((float)y, (float)this.height));
        }
        if (this.extent == null || this.extent.contains(x, y)) {
            return this.children[0].getHeight(x, y);
        }
        if (x < 0.0f) {
            if (y < 0.0f) {
                return this.children[0].getHeight(0.0f, 0.0f);
            }
            if (y < (float)this.height) {
                return this.children[0].getHeight(0.0f, y);
            }
            return this.children[0].getHeight(0.0f, (float)this.height - 1.0f);
        }
        if (x < (float)this.width) {
            if (y < 0.0f) {
                return this.children[0].getHeight(x, 0.0f);
            }
            return this.children[0].getHeight(x, (float)this.height - 1.0f);
        }
        if (y < 0.0f) {
            return this.children[0].getHeight((float)this.width - 1.0f, 0.0f);
        }
        if (y < (float)this.height) {
            return this.children[0].getHeight((float)this.width - 1.0f, y);
        }
        return this.children[0].getHeight((float)this.width - 1.0f, (float)this.height - 1.0f);
    }

    @Override
    public Rectangle getExtent() {
        return this.extent;
    }

    @Override
    public Icon getIcon() {
        return ICON_BITMAP_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        return this.children[0].getRange();
    }

    private double cubicInterpolate(double y0, double y1, double y2, double y3, float \u03bc) {
        return y1 + 0.5 * (double)\u03bc * (y2 - y0 + (double)\u03bc * (2.0 * y0 - 5.0 * y1 + 4.0 * y2 - y3 + (double)\u03bc * (3.0 * (y1 - y2) + y3 - y0)));
    }
}

