/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;

public class BandedHeightMap
extends AbstractHeightMap {
    private final int segment1Length;
    private final int segment2Length;
    private final int totalLength;
    private final double segment1EndHeight;
    private final double segment2EndHeight;
    private final double segment1EndDelta;
    private final double segment2EndDelta;
    private final boolean smooth;
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_BANDED_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/sawtooth.png");
    private static final double[] RANGE = new double[]{0.0, 1.0};

    public BandedHeightMap(int segment1Length, double segment1EndHeight, int segment2Length, double segment2EndHeight, boolean smooth) {
        this(null, segment1Length, segment1EndHeight, segment2Length, segment2EndHeight, smooth);
    }

    public BandedHeightMap(String name, int segment1Length, double segment1EndHeight, int segment2Length, double segment2EndHeight, boolean smooth) {
        super(name);
        this.segment1Length = segment1Length;
        this.segment1EndHeight = segment1EndHeight;
        this.segment2Length = segment2Length;
        this.segment2EndHeight = segment2EndHeight;
        this.smooth = smooth;
        this.totalLength = segment1Length + segment2Length;
        this.segment1EndDelta = segment1EndHeight - segment2EndHeight;
        this.segment2EndDelta = segment2EndHeight - segment1EndHeight;
    }

    public double getSegment1EndHeight() {
        return this.segment1EndHeight;
    }

    public int getSegment1Length() {
        return this.segment1Length;
    }

    public int getSegment2Length() {
        return this.segment2Length;
    }

    public double getSegment2EndHeight() {
        return this.segment2EndHeight;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    @Override
    public double getHeight(float x0, float y0) {
        float d = MathUtils.mod((float)x0, (float)this.totalLength);
        if (d < (float)this.segment1Length) {
            if (this.smooth) {
                return this.segment2EndHeight + (0.5 - Math.cos((double)d * Math.PI / (double)this.segment1Length) / 2.0) * this.segment1EndDelta;
            }
            return this.segment2EndHeight + (double)(d / (float)this.segment1Length) * this.segment1EndDelta;
        }
        if (this.smooth) {
            return this.segment1EndHeight + (0.5 - Math.cos((double)(d - (float)this.segment1Length) * Math.PI / (double)this.segment2Length) / 2.0) * this.segment2EndDelta;
        }
        return this.segment1EndHeight + (double)((d - (float)this.segment1Length) / (float)this.segment2Length) * this.segment2EndDelta;
    }

    @Override
    public Icon getIcon() {
        return ICON_BANDED_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        return RANGE;
    }
}

