/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.awt.Rectangle;
import java.io.Serializable;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;

public abstract class AbstractHeightMap
implements HeightMap,
Cloneable,
Serializable {
    protected String name;
    protected long seed;
    DelegatingHeightMap parent;
    private static final long serialVersionUID = 1L;

    public AbstractHeightMap() {
        this.name = null;
    }

    public AbstractHeightMap(String name) {
        this.name = name;
    }

    public DelegatingHeightMap getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public AbstractHeightMap clone() {
        try {
            return (AbstractHeightMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Rectangle getExtent() {
        return null;
    }

    @Override
    public int getColour(int x, int y) {
        int value = (int)MathUtils.clamp((long)0L, (long)Math.round(this.getHeight(x, y)), (long)255L);
        return value << 16 | value << 8 | value;
    }

    @Override
    public double getHeight(float x, float y) {
        return this.getHeight(Math.round(x), Math.round(y));
    }

    @Override
    public double getHeight(int x, int y) {
        return this.getHeight((float)x, (float)y);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public double getConstantValue() {
        throw new UnsupportedOperationException("Not a constant height map");
    }

    @Override
    public double getBaseHeight() {
        return this.getRange()[0];
    }
}

