/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.gardenofeden;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.pepsoft.worldpainter.WPContextProvider;
import org.pepsoft.worldpainter.gardenofeden.Theme;
import org.pepsoft.worldpainter.util.MinecraftUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeListCellRenderer
extends DefaultListCellRenderer {
    private final BufferedImage texturePack;
    private final Map<Theme, Icon> iconCache = new HashMap<Theme, Icon>();
    private static final Logger logger = LoggerFactory.getLogger(ThemeListCellRenderer.class);
    private static final long serialVersionUID = 1L;

    public ThemeListCellRenderer() {
        File file = MinecraftUtil.findMinecraftJar(WPContextProvider.getWPContext().getMinecraftJarProvider());
        if (file != null) {
            logger.info("Loading default Minecraft texture map from " + file);
            try {
                JarFile minecraftJar = new JarFile(file);
                JarEntry entry = minecraftJar.getJarEntry("terrain.png");
                if (entry != null) {
                    try (InputStream in = minecraftJar.getInputStream(entry);){
                        this.texturePack = ImageIO.read(in);
                    }
                }
                this.texturePack = null;
            }
            catch (IOException e) {
                throw new RuntimeException("I/O error getting default texture map from minecraft.jar", e);
            }
        } else {
            logger.warn("Minecraft installation not found; could not load default texture map!");
            this.texturePack = null;
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (this.texturePack != null && value != null) {
            this.setText(null);
            Icon preview = this.iconCache.get((Theme)value);
            if (preview == null) {
                preview = new ImageIcon(((Theme)value).getPreview(this.texturePack));
                this.iconCache.put((Theme)value, preview);
            }
            this.setIcon(preview);
        }
        return this;
    }
}

