/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.gardenofeden;

import java.util.Set;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.gardenofeden.Seed;

public class GardenExporter {
    public void firstPass(Dimension dimension, Tile tile, Platform platform, MinecraftWorld minecraftWorld, Set<Seed> processedSeeds) {
        tile.getSeeds().stream().filter(seed -> !processedSeeds.contains(seed)).forEach(seed -> this.processSeedFirstPass((Seed)seed, processedSeeds, dimension, tile, platform, minecraftWorld));
    }

    public void secondPass(Dimension dimension, Tile tile, Platform platform, MinecraftWorld minecraftWorld, Set<Seed> processedSeeds) {
        tile.getSeeds().stream().filter(seed -> !processedSeeds.contains(seed)).forEach(seed -> this.processSeedSecondPass((Seed)seed, processedSeeds, dimension, tile, platform, minecraftWorld));
    }

    private void processSeedFirstPass(Seed seed, Set<Seed> processedSeeds, Dimension dimension, Tile tile, Platform platform, MinecraftWorld world) {
        if (seed.parent != null && !processedSeeds.contains(seed.parent)) {
            this.processSeedFirstPass(seed.parent, processedSeeds, dimension, tile, platform, world);
        }
        if (seed.isSprouted()) {
            seed.buildFirstPass(dimension, tile, platform, world);
            processedSeeds.add(seed);
        }
    }

    private void processSeedSecondPass(Seed seed, Set<Seed> processedSeeds, Dimension dimension, Tile tile, Platform platform, MinecraftWorld world) {
        if (seed.parent != null && !processedSeeds.contains(seed.parent)) {
            this.processSeedSecondPass(seed.parent, processedSeeds, dimension, tile, platform, world);
        }
        if (seed.isSprouted()) {
            seed.buildSecondPass(dimension, tile, platform, world);
            processedSeeds.add(seed);
        }
    }
}

